# coding: utf-8

"""
    Humanloop API

    The Humanloop API allows you to interact with Humanloop from your product or service.  You can do this through HTTP requests from any language or via our official Python or TypeScript SDK.  To install the official [Python SDK](https://pypi.org/project/humanloop/), run the following command:  ```bash pip install humanloop ```  To install the official [TypeScript SDK](https://www.npmjs.com/package/humanloop), run the following command:  ```bash npm i humanloop ```  ---  Guides and further details about key concepts can be found in [our docs](https://docs.humanloop.com/).

    The version of the OpenAPI document: 4.0.1
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING

from humanloop.type.config_type import ConfigType
from humanloop.type.evaluator_response import EvaluatorResponse
from humanloop.type.experiment_response import ExperimentResponse
from humanloop.type.feedback_types import FeedbackTypes
from humanloop.type.project_config_response import ProjectConfigResponse
from humanloop.type.project_user_response import ProjectUserResponse

class RequiredProjectResponse(TypedDict):
    # Project ID
    id: str

    # Unique project name.
    name: str

    # Users associated to the project.
    users: typing.List[ProjectUserResponse]

    # The count of datapoints that have been logged to the project.
    data_count: int

    # The feedback types that have been defined in the project.
    feedback_types: FeedbackTypes

    # Unique ID of the team the project belongs to. Starts with `tm_`.
    team_id: str

    created_at: datetime

    updated_at: datetime

class OptionalProjectResponse(TypedDict, total=False):
    # Experiment that has been set as the project's active deployment. At most one of active_experiment and active_model_config can be set.
    active_experiment: ExperimentResponse

    # Config that has been set as the project's active deployment. At most one of active_experiment and active_model_config can be set.
    active_config: ProjectConfigResponse

    config_type: ConfigType

    # Evaluators that have been set as active for the project.
    active_evaluators: 'typing.List[EvaluatorResponse]'

    # String ID of the directory the project belongs to. Starts with `dir_`.
    directory_id: str

class ProjectResponse(RequiredProjectResponse, OptionalProjectResponse):
    pass
