#! /usr/bin/env python3
# -*- coding: utf-8; py-indent-offset: 4 -*-
#
# Author:  Linuxfabrik GmbH, Zurich, Switzerland
# Contact: info (at) linuxfabrik (dot) ch
#          https://www.linuxfabrik.ch/
# License: The Unlicense, see LICENSE file.

# https://github.com/Linuxfabrik/monitoring-plugins/blob/main/CONTRIBUTING.rst

"""This library stores information from https://endoflife.date/api/ for offline usage
and therefore needs to be updated periodically when version checks don't have access to the
Internet."""

# pylint: disable=C0302

__author__ = 'Linuxfabrik GmbH, Zurich/Switzerland'
__version__ = '2023112901'

ENDOFLIFE_DATE = {

    'https://endoflife.date/api/apache.json': [
    {   'cycle': '2.4',
        'eol': False,
        'latest': '2.4.65',
        'latestReleaseDate': '2025-07-23',
        'link': 'https://downloads.apache.org/httpd/CHANGES_2.4',
        'lts': False,
        'releaseDate': '2012-02-21'},
    {   'cycle': '2.2',
        'eol': '2017-07-11',
        'latest': '2.2.34',
        'latestReleaseDate': '2017-07-11',
        'link': 'https://archive.apache.org/dist/httpd/CHANGES_2.2.34',
        'lts': False,
        'releaseDate': '2005-12-01'},
    {   'cycle': '2.0',
        'eol': '2013-07-10',
        'latest': '2.0.65',
        'latestReleaseDate': '2013-07-09',
        'link': 'https://archive.apache.org/dist/httpd/CHANGES_2.0.65',
        'lts': False,
        'releaseDate': '2002-04-05'},
    {   'cycle': '1.3',
        'eol': '2010-02-03',
        'latest': '1.3.42',
        'latestReleaseDate': '2010-02-02',
        'link': 'https://archive.apache.org/dist/httpd/CHANGES_1.3.42',
        'lts': False,
        'releaseDate': '1998-06-01'},
    ],


    'https://endoflife.date/api/composer.json': [
    {   'cycle': '2.8',
        'eol': False,
        'latest': '2.8.11',
        'latestReleaseDate': '2025-08-21',
        'lts': False,
        'releaseDate': '2024-10-02'},
    {   'cycle': '2.7',
        'eol': '2024-10-02',
        'latest': '2.7.9',
        'latestReleaseDate': '2024-09-04',
        'lts': False,
        'releaseDate': '2024-02-08'},
    {   'cycle': '2.6',
        'eol': '2024-02-08',
        'latest': '2.6.6',
        'latestReleaseDate': '2023-12-08',
        'lts': False,
        'releaseDate': '2023-09-01'},
    {   'cycle': '2.5',
        'eol': '2023-09-01',
        'latest': '2.5.8',
        'latestReleaseDate': '2023-06-09',
        'lts': False,
        'releaseDate': '2022-12-20'},
    {   'cycle': '2.4',
        'eol': '2022-12-20',
        'latest': '2.4.4',
        'latestReleaseDate': '2022-10-27',
        'lts': False,
        'releaseDate': '2022-08-16'},
    {   'cycle': '2.3',
        'eol': '2022-08-16',
        'latest': '2.3.10',
        'latestReleaseDate': '2022-07-13',
        'lts': False,
        'releaseDate': '2022-03-30'},
    {   'cycle': '2.2',
        'eol': False,
        'latest': '2.2.25',
        'latestReleaseDate': '2024-12-11',
        'lts': True,
        'releaseDate': '2021-12-22'},
    {   'cycle': '1',
        'eol': '2020-10-24',
        'latest': '1.10.27',
        'latestReleaseDate': '2023-09-29',
        'lts': False,
        'releaseDate': '2016-04-05'},
    ],


    'https://endoflife.date/api/fedora.json': [
    {   'codename': 'Adams',
        'cycle': '42',
        'eol': '2026-05-13',
        'latest': '42',
        'latestReleaseDate': '2025-04-15',
        'lts': False,
        'releaseDate': '2025-04-15',
        'releaseLabel': '__RELEASE_CYCLE__ (__CODENAME__)'},
    {   'cycle': '41',
        'eol': '2025-11-19',
        'latest': '41',
        'latestReleaseDate': '2024-10-29',
        'lts': False,
        'releaseDate': '2024-10-29'},
    {   'cycle': '40',
        'eol': '2025-05-13',
        'latest': '40',
        'latestReleaseDate': '2024-04-23',
        'lts': False,
        'releaseDate': '2024-04-23'},
    {   'cycle': '39',
        'eol': '2024-11-26',
        'latest': '39',
        'latestReleaseDate': '2023-11-07',
        'lts': False,
        'releaseDate': '2023-11-07'},
    {   'cycle': '38',
        'eol': '2024-05-21',
        'latest': '38',
        'latestReleaseDate': '2023-04-18',
        'lts': False,
        'releaseDate': '2023-04-18'},
    {   'cycle': '37',
        'eol': '2023-12-05',
        'latest': '37',
        'latestReleaseDate': '2022-11-15',
        'lts': False,
        'releaseDate': '2022-11-15'},
    {   'cycle': '36',
        'eol': '2023-05-16',
        'latest': '36',
        'latestReleaseDate': '2022-05-10',
        'lts': False,
        'releaseDate': '2022-05-10'},
    {   'cycle': '35',
        'eol': '2022-12-13',
        'latest': '35',
        'latestReleaseDate': '2021-11-02',
        'lts': False,
        'releaseDate': '2021-11-02'},
    {   'cycle': '34',
        'eol': '2022-06-07',
        'latest': '34',
        'latestReleaseDate': '2021-04-27',
        'lts': False,
        'releaseDate': '2021-04-27'},
    {   'cycle': '33',
        'eol': '2021-11-30',
        'latest': '33',
        'latestReleaseDate': '2020-10-27',
        'lts': False,
        'releaseDate': '2020-10-27'},
    {   'cycle': '32',
        'eol': '2021-05-25',
        'latest': '32',
        'latestReleaseDate': '2020-04-28',
        'lts': False,
        'releaseDate': '2020-04-28'},
    {   'cycle': '31',
        'eol': '2020-11-24',
        'latest': '31',
        'latestReleaseDate': '2019-10-29',
        'lts': False,
        'releaseDate': '2019-10-29'},
    {   'cycle': '30',
        'eol': '2020-05-26',
        'latest': '30',
        'latestReleaseDate': '2019-04-30',
        'lts': False,
        'releaseDate': '2019-04-30'},
    {   'cycle': '29',
        'eol': '2019-11-26',
        'latest': '29',
        'latestReleaseDate': '2018-10-30',
        'lts': False,
        'releaseDate': '2018-10-30'},
    {   'cycle': '28',
        'eol': '2019-05-28',
        'latest': '28',
        'latestReleaseDate': '2018-05-01',
        'lts': False,
        'releaseDate': '2018-05-01'},
    {   'cycle': '27',
        'eol': '2018-11-30',
        'latest': '27',
        'latestReleaseDate': '2017-11-14',
        'lts': False,
        'releaseDate': '2017-11-14'},
    {   'cycle': '26',
        'eol': '2018-05-29',
        'latest': '26',
        'latestReleaseDate': '2017-07-11',
        'lts': False,
        'releaseDate': '2017-07-11'},
    {   'cycle': '25',
        'eol': '2017-12-12',
        'latest': '25',
        'latestReleaseDate': '2016-11-22',
        'lts': False,
        'releaseDate': '2016-11-22'},
    {   'cycle': '24',
        'eol': '2017-08-08',
        'latest': '24',
        'latestReleaseDate': '2016-06-21',
        'lts': False,
        'releaseDate': '2016-06-21'},
    {   'cycle': '23',
        'eol': '2016-12-20',
        'latest': '23',
        'latestReleaseDate': '2015-11-03',
        'lts': False,
        'releaseDate': '2015-11-03'},
    {   'cycle': '22',
        'eol': '2016-07-19',
        'latest': '22',
        'latestReleaseDate': '2015-05-26',
        'lts': False,
        'releaseDate': '2015-05-26'},
    {   'cycle': '21',
        'eol': '2015-12-01',
        'latest': '21',
        'latestReleaseDate': '2014-12-09',
        'lts': False,
        'releaseDate': '2014-12-09'},
    {   'codename': 'Heisenbug',
        'cycle': '20',
        'eol': '2015-06-23',
        'latest': '20',
        'latestReleaseDate': '2013-12-17',
        'lts': False,
        'releaseDate': '2013-12-17',
        'releaseLabel': '__RELEASE_CYCLE__ (__CODENAME__)'},
    {   'codename': "Schrödinger's Cat",
        'cycle': '19',
        'eol': '2015-01-06',
        'latest': '19',
        'latestReleaseDate': '2013-07-02',
        'link': 'https://docs.fedoraproject.org/en-US/releases/f19/',
        'lts': False,
        'releaseDate': '2013-07-02',
        'releaseLabel': '__RELEASE_CYCLE__ (__CODENAME__)'},
    {   'codename': 'Spherical Cow',
        'cycle': '18',
        'eol': '2014-01-14',
        'latest': '18',
        'latestReleaseDate': '2013-01-15',
        'link': 'https://docs.fedoraproject.org/en-US/releases/f18/',
        'lts': False,
        'releaseDate': '2013-01-15',
        'releaseLabel': '__RELEASE_CYCLE__ (__CODENAME__)'},
    {   'codename': 'Beefy Miracle',
        'cycle': '17',
        'eol': '2013-07-30',
        'latest': '17',
        'latestReleaseDate': '2012-05-29',
        'link': 'https://docs.fedoraproject.org/en-US/releases/f17/',
        'lts': False,
        'releaseDate': '2012-05-29',
        'releaseLabel': '__RELEASE_CYCLE__ (__CODENAME__)'},
    {   'codename': 'Verne',
        'cycle': '16',
        'eol': '2013-02-12',
        'latest': '16',
        'latestReleaseDate': '2011-11-08',
        'link': 'https://docs.fedoraproject.org/en-US/releases/f16/',
        'lts': False,
        'releaseDate': '2011-11-08',
        'releaseLabel': '__RELEASE_CYCLE__ (__CODENAME__)'},
    {   'codename': 'Lovelock',
        'cycle': '15',
        'eol': '2012-06-26',
        'latest': '15',
        'latestReleaseDate': '2011-05-24',
        'link': 'https://docs.fedoraproject.org/en-US/releases/f15/',
        'lts': False,
        'releaseDate': '2011-05-24',
        'releaseLabel': '__RELEASE_CYCLE__ (__CODENAME__)'},
    {   'codename': 'Laughlin',
        'cycle': '14',
        'eol': '2011-12-09',
        'latest': '14',
        'latestReleaseDate': '2010-11-02',
        'link': 'https://docs.fedoraproject.org/en-US/releases/f14/',
        'lts': False,
        'releaseDate': '2010-11-02',
        'releaseLabel': '__RELEASE_CYCLE__ (__CODENAME__)'},
    {   'codename': 'Goddard',
        'cycle': '13',
        'eol': '2011-06-24',
        'latest': '13',
        'latestReleaseDate': '2010-05-25',
        'link': 'https://docs.fedoraproject.org/en-US/releases/f13/',
        'lts': False,
        'releaseDate': '2010-05-25',
        'releaseLabel': '__RELEASE_CYCLE__ (__CODENAME__)'},
    {   'codename': 'Constantine',
        'cycle': '12',
        'eol': '2010-12-02',
        'latest': '12',
        'latestReleaseDate': '2009-11-17',
        'link': 'https://docs.fedoraproject.org/en-US/releases/f12/',
        'lts': False,
        'releaseDate': '2009-11-17',
        'releaseLabel': '__RELEASE_CYCLE__ (__CODENAME__)'},
    {   'codename': 'Leonidas',
        'cycle': '11',
        'eol': '2010-06-25',
        'latest': '11',
        'latestReleaseDate': '2009-06-09',
        'link': 'https://docs.fedoraproject.org/en-US/releases/f11/',
        'lts': False,
        'releaseDate': '2009-06-09',
        'releaseLabel': '__RELEASE_CYCLE__ (__CODENAME__)'},
    {   'codename': 'Cambridge',
        'cycle': '10',
        'eol': '2009-12-17',
        'latest': '10',
        'latestReleaseDate': '2008-11-25',
        'link': 'https://docs.fedoraproject.org/en-US/releases/f10/',
        'lts': False,
        'releaseDate': '2008-11-25',
        'releaseLabel': '__RELEASE_CYCLE__ (__CODENAME__)'},
    {   'codename': 'Sulphur',
        'cycle': '9',
        'eol': '2009-07-10',
        'latest': '9',
        'latestReleaseDate': '2008-05-13',
        'link': 'https://docs.fedoraproject.org/en-US/releases/f9/',
        'lts': False,
        'releaseDate': '2008-05-13',
        'releaseLabel': '__RELEASE_CYCLE__ (__CODENAME__)'},
    {   'codename': 'Werewolf',
        'cycle': '8',
        'eol': '2009-01-07',
        'latest': '8',
        'latestReleaseDate': '2007-11-08',
        'link': 'https://docs.fedoraproject.org/en-US/releases/f8/',
        'lts': False,
        'releaseDate': '2007-11-08',
        'releaseLabel': '__RELEASE_CYCLE__ (__CODENAME__)'},
    {   'codename': 'Moonshine',
        'cycle': '7',
        'eol': '2008-06-13',
        'latest': '7',
        'latestReleaseDate': '2007-05-31',
        'link': 'https://docs.fedoraproject.org/en-US/releases/f7/',
        'lts': False,
        'releaseDate': '2007-05-31',
        'releaseLabel': '__RELEASE_CYCLE__ (__CODENAME__)'},
    {   'codename': 'Zod',
        'cycle': '6',
        'eol': '2007-12-07',
        'latest': '6',
        'latestReleaseDate': '2006-10-24',
        'link': 'https://docs.fedoraproject.org/en-US/releases/f6/',
        'lts': False,
        'releaseDate': '2006-10-24',
        'releaseLabel': '__RELEASE_CYCLE__ (__CODENAME__)'},
    {   'codename': 'Bordeaux',
        'cycle': '5',
        'eol': '2007-07-02',
        'latest': '5',
        'latestReleaseDate': '2006-03-20',
        'link': 'https://docs.fedoraproject.org/en-US/releases/f5/',
        'lts': False,
        'releaseDate': '2006-03-20',
        'releaseLabel': '__RELEASE_CYCLE__ (__CODENAME__)'},
    {   'codename': 'Stentz',
        'cycle': '4',
        'eol': '2006-08-07',
        'latest': '4',
        'latestReleaseDate': '2005-06-13',
        'link': 'https://docs.fedoraproject.org/en-US/releases/f4/',
        'lts': False,
        'releaseDate': '2005-06-13',
        'releaseLabel': '__RELEASE_CYCLE__ (__CODENAME__)'},
    {   'codename': 'Heidelberg',
        'cycle': '3',
        'eol': '2006-01-16',
        'latest': '3',
        'latestReleaseDate': '2004-11-08',
        'link': 'https://docs.fedoraproject.org/en-US/releases/f3/',
        'lts': False,
        'releaseDate': '2004-11-08',
        'releaseLabel': '__RELEASE_CYCLE__ (__CODENAME__)'},
    {   'codename': 'Tettnang',
        'cycle': '2',
        'eol': '2005-04-11',
        'latest': '2',
        'latestReleaseDate': '2004-05-18',
        'link': 'https://docs.fedoraproject.org/en-US/releases/f2/',
        'lts': False,
        'releaseDate': '2004-05-18',
        'releaseLabel': '__RELEASE_CYCLE__ (__CODENAME__)'},
    {   'codename': 'Yarrow',
        'cycle': '1',
        'eol': '2004-09-20',
        'latest': '1',
        'latestReleaseDate': '2003-11-05',
        'link': 'https://docs.fedoraproject.org/en-US/releases/f1/',
        'lts': False,
        'releaseDate': '2003-11-05',
        'releaseLabel': '__RELEASE_CYCLE__ (__CODENAME__)'},
    ],


    'https://endoflife.date/api/fortios.json': [
    {   'cycle': '7.6',
        'eol': '2029-01-25',
        'lts': False,
        'releaseDate': '2024-07-25',
        'support': '2027-07-25'},
    {   'cycle': '7.4',
        'eol': '2027-11-11',
        'lts': False,
        'releaseDate': '2023-05-11',
        'support': '2026-05-11'},
    {   'cycle': '7.2',
        'eol': '2026-09-30',
        'lts': False,
        'releaseDate': '2022-03-31',
        'support': '2025-03-31'},
    {   'cycle': '7.0',
        'eol': '2025-09-30',
        'lts': False,
        'releaseDate': '2021-03-30',
        'support': '2024-03-30'},
    {   'cycle': '6.4',
        'eol': '2024-09-30',
        'lts': False,
        'releaseDate': '2020-03-31',
        'support': '2023-03-31'},
    {   'cycle': '6.2',
        'eol': '2023-09-28',
        'lts': False,
        'releaseDate': '2019-03-28',
        'support': '2022-03-28'},
    {   'cycle': '6.0',
        'eol': '2022-09-29',
        'lts': False,
        'releaseDate': '2018-03-29',
        'support': '2021-03-29'},
    ],


    'https://endoflife.date/api/gitlab.json': [
    {   'cycle': '18.3',
        'eol': '2025-11-20',
        'latest': '18.3.2',
        'latestReleaseDate': '2025-09-09',
        'lts': False,
        'releaseDate': '2025-08-21',
        'support': '2025-09-18'},
    {   'cycle': '18.2',
        'eol': '2025-10-16',
        'latest': '18.2.6',
        'latestReleaseDate': '2025-09-09',
        'lts': False,
        'releaseDate': '2025-07-16',
        'support': '2025-08-21'},
    {   'cycle': '18.1',
        'eol': '2025-09-18',
        'latest': '18.1.6',
        'latestReleaseDate': '2025-09-09',
        'lts': False,
        'releaseDate': '2025-06-18',
        'support': '2025-07-17'},
    {   'cycle': '18.0',
        'eol': '2025-08-21',
        'latest': '18.0.6',
        'latestReleaseDate': '2025-08-12',
        'lts': False,
        'releaseDate': '2025-05-14',
        'support': '2025-06-19'},
    {   'cycle': '17.11',
        'eol': '2025-07-17',
        'latest': '17.11.7',
        'latestReleaseDate': '2025-08-14',
        'lts': False,
        'releaseDate': '2025-04-16',
        'support': '2025-05-15'},
    {   'cycle': '17.10',
        'eol': '2025-06-19',
        'latest': '17.10.8',
        'latestReleaseDate': '2025-06-11',
        'lts': False,
        'releaseDate': '2025-03-19',
        'support': '2025-04-17'},
    {   'cycle': '17.9',
        'eol': '2025-05-15',
        'latest': '17.9.8',
        'latestReleaseDate': '2025-05-07',
        'lts': False,
        'releaseDate': '2025-02-19',
        'support': '2025-03-20'},
    {   'cycle': '17.8',
        'eol': '2025-04-17',
        'latest': '17.8.7',
        'latestReleaseDate': '2025-04-09',
        'lts': False,
        'releaseDate': '2025-01-15',
        'support': '2025-02-20'},
    {   'cycle': '17.7',
        'eol': '2025-03-20',
        'latest': '17.7.7',
        'latestReleaseDate': '2025-03-11',
        'lts': False,
        'releaseDate': '2024-12-18',
        'support': '2025-01-16'},
    {   'cycle': '17.6',
        'eol': '2025-02-20',
        'latest': '17.6.5',
        'latestReleaseDate': '2025-02-11',
        'lts': False,
        'releaseDate': '2024-11-20',
        'support': '2024-12-19'},
    {   'cycle': '17.5',
        'eol': '2025-01-16',
        'latest': '17.5.5',
        'latestReleaseDate': '2025-01-08',
        'lts': False,
        'releaseDate': '2024-10-16',
        'support': '2024-11-21'},
    {   'cycle': '17.4',
        'eol': '2024-12-19',
        'latest': '17.4.6',
        'latestReleaseDate': '2024-12-10',
        'lts': False,
        'releaseDate': '2024-09-18',
        'support': '2024-10-17'},
    {   'cycle': '17.3',
        'eol': '2024-11-21',
        'latest': '17.3.7',
        'latestReleaseDate': '2024-11-12',
        'lts': False,
        'releaseDate': '2024-08-14',
        'support': '2024-09-19'},
    {   'cycle': '17.2',
        'eol': '2024-10-17',
        'latest': '17.2.9',
        'latestReleaseDate': '2024-10-09',
        'lts': False,
        'releaseDate': '2024-07-17',
        'support': '2024-08-15'},
    {   'cycle': '17.1',
        'eol': '2024-09-19',
        'latest': '17.1.8',
        'latestReleaseDate': '2024-09-16',
        'lts': False,
        'releaseDate': '2024-06-19',
        'support': '2024-07-18'},
    {   'cycle': '17.0',
        'eol': '2024-08-15',
        'latest': '17.0.8',
        'latestReleaseDate': '2024-09-16',
        'lts': False,
        'releaseDate': '2024-05-15',
        'support': '2024-06-20'},
    {   'cycle': '16.11',
        'eol': '2024-07-18',
        'latest': '16.11.10',
        'latestReleaseDate': '2024-09-16',
        'lts': False,
        'releaseDate': '2024-04-17',
        'support': '2024-05-16'},
    {   'cycle': '16.10',
        'eol': '2024-06-20',
        'latest': '16.10.10',
        'latestReleaseDate': '2024-09-19',
        'lts': False,
        'releaseDate': '2024-03-20',
        'support': '2024-04-18'},
    {   'cycle': '16.9',
        'eol': '2024-05-16',
        'latest': '16.9.11',
        'latestReleaseDate': '2024-09-19',
        'lts': False,
        'releaseDate': '2024-02-14',
        'support': '2024-03-21'},
    {   'cycle': '16.8',
        'eol': '2024-04-18',
        'latest': '16.8.10',
        'latestReleaseDate': '2024-09-20',
        'lts': False,
        'releaseDate': '2024-01-17',
        'support': '2024-02-15'},
    {   'cycle': '16.7',
        'eol': '2024-03-21',
        'latest': '16.7.10',
        'latestReleaseDate': '2024-09-20',
        'lts': False,
        'releaseDate': '2023-12-20',
        'support': '2024-01-18'},
    {   'cycle': '16.6',
        'eol': '2024-02-15',
        'latest': '16.6.10',
        'latestReleaseDate': '2024-09-20',
        'lts': False,
        'releaseDate': '2023-11-15',
        'support': '2023-12-21'},
    {   'cycle': '16.5',
        'eol': '2024-01-18',
        'latest': '16.5.10',
        'latestReleaseDate': '2024-09-20',
        'lts': False,
        'releaseDate': '2023-10-20',
        'support': '2023-11-16'},
    {   'cycle': '16.4',
        'eol': '2023-12-21',
        'latest': '16.4.7',
        'latestReleaseDate': '2024-09-20',
        'lts': False,
        'releaseDate': '2023-09-21',
        'support': '2023-10-22'},
    {   'cycle': '16.3',
        'eol': '2023-11-16',
        'latest': '16.3.9',
        'latestReleaseDate': '2024-09-20',
        'lts': False,
        'releaseDate': '2023-08-21',
        'support': '2023-09-22'},
    {   'cycle': '16.2',
        'eol': '2023-10-22',
        'latest': '16.2.11',
        'latestReleaseDate': '2024-09-23',
        'lts': False,
        'releaseDate': '2023-07-21',
        'support': '2023-08-22'},
    {   'cycle': '16.1',
        'eol': '2023-09-22',
        'latest': '16.1.8',
        'latestReleaseDate': '2024-09-23',
        'lts': False,
        'releaseDate': '2023-06-21',
        'support': '2023-07-22'},
    {   'cycle': '16.0',
        'eol': '2023-08-22',
        'latest': '16.0.10',
        'latestReleaseDate': '2024-09-23',
        'lts': False,
        'releaseDate': '2023-05-18',
        'support': '2023-06-22'},
    {   'cycle': '15.11',
        'eol': '2023-07-22',
        'latest': '15.11.13',
        'latestReleaseDate': '2023-07-27',
        'lts': False,
        'releaseDate': '2023-04-21',
        'support': '2023-05-22'},
    {   'cycle': '15.10',
        'eol': '2023-06-22',
        'latest': '15.10.8',
        'latestReleaseDate': '2023-06-05',
        'lts': False,
        'releaseDate': '2023-03-21',
        'support': '2023-04-22'},
    {   'cycle': '15.9',
        'eol': '2023-05-22',
        'latest': '15.9.8',
        'latestReleaseDate': '2023-05-10',
        'lts': False,
        'releaseDate': '2023-02-21',
        'support': '2023-03-22'},
    {   'cycle': '15.8',
        'eol': '2023-04-22',
        'latest': '15.8.6',
        'latestReleaseDate': '2023-04-18',
        'lts': False,
        'releaseDate': '2023-01-20',
        'support': '2023-02-22'},
    {   'cycle': '15.7',
        'eol': '2023-03-22',
        'latest': '15.7.9',
        'latestReleaseDate': '2023-04-20',
        'lts': False,
        'releaseDate': '2022-12-21',
        'support': '2023-01-22'},
    {   'cycle': '15.6',
        'eol': '2023-02-22',
        'latest': '15.6.8',
        'latestReleaseDate': '2023-02-10',
        'lts': False,
        'releaseDate': '2022-11-21',
        'support': '2022-12-22'},
    {   'cycle': '15.5',
        'eol': '2023-01-22',
        'latest': '15.5.9',
        'latestReleaseDate': '2023-01-12',
        'lts': False,
        'releaseDate': '2022-10-21',
        'support': '2022-11-22'},
    {   'cycle': '15.4',
        'eol': '2022-12-22',
        'latest': '15.4.6',
        'latestReleaseDate': '2022-11-30',
        'lts': False,
        'releaseDate': '2022-09-21',
        'support': '2022-10-22'},
    {   'cycle': '15.3',
        'eol': '2022-11-22',
        'latest': '15.3.5',
        'latestReleaseDate': '2022-11-02',
        'lts': False,
        'releaseDate': '2022-08-19',
        'support': '2022-09-22'},
    {   'cycle': '15.2',
        'eol': '2022-10-22',
        'latest': '15.2.5',
        'latestReleaseDate': '2022-09-29',
        'lts': False,
        'releaseDate': '2022-07-21',
        'support': '2022-08-22'},
    {   'cycle': '15.1',
        'eol': '2022-09-22',
        'latest': '15.1.6',
        'latestReleaseDate': '2022-08-30',
        'lts': False,
        'releaseDate': '2022-06-21',
        'support': '2022-07-22'},
    {   'cycle': '15.0',
        'eol': '2022-08-22',
        'latest': '15.0.5',
        'latestReleaseDate': '2022-07-28',
        'lts': False,
        'releaseDate': '2022-05-20',
        'support': '2022-06-22'},
    {   'cycle': '14.10',
        'eol': '2022-07-22',
        'latest': '14.10.5',
        'latestReleaseDate': '2022-06-30',
        'lts': False,
        'releaseDate': '2022-04-21',
        'support': '2022-05-22'},
    {   'cycle': '14.9',
        'eol': '2022-06-22',
        'latest': '14.9.5',
        'latestReleaseDate': '2022-06-01',
        'lts': False,
        'releaseDate': '2022-03-21',
        'support': '2022-04-22'},
    {   'cycle': '14.8',
        'eol': '2022-05-22',
        'latest': '14.8.6',
        'latestReleaseDate': '2022-04-29',
        'lts': False,
        'releaseDate': '2022-02-21',
        'support': '2022-03-22'},
    {   'cycle': '14.7',
        'eol': '2022-04-22',
        'latest': '14.7.7',
        'latestReleaseDate': '2022-03-31',
        'lts': False,
        'releaseDate': '2022-01-21',
        'support': '2022-02-22'},
    {   'cycle': '14.6',
        'eol': '2022-03-22',
        'latest': '14.6.7',
        'latestReleaseDate': '2022-03-31',
        'lts': False,
        'releaseDate': '2021-12-21',
        'support': '2022-01-22'},
    {   'cycle': '14.5',
        'eol': '2022-02-22',
        'latest': '14.5.4',
        'latestReleaseDate': '2022-02-03',
        'lts': False,
        'releaseDate': '2021-11-19',
        'support': '2021-12-22'},
    {   'cycle': '14.4',
        'eol': '2022-01-22',
        'latest': '14.4.5',
        'latestReleaseDate': '2022-01-11',
        'lts': False,
        'releaseDate': '2021-10-21',
        'support': '2021-11-22'},
    {   'cycle': '14.3',
        'eol': '2021-12-22',
        'latest': '14.3.6',
        'latestReleaseDate': '2021-12-03',
        'lts': False,
        'releaseDate': '2021-09-21',
        'support': '2021-10-22'},
    {   'cycle': '14.2',
        'eol': '2021-11-22',
        'latest': '14.2.7',
        'latestReleaseDate': '2021-11-26',
        'lts': False,
        'releaseDate': '2021-08-20',
        'support': '2021-09-22'},
    {   'cycle': '14.1',
        'eol': '2021-10-22',
        'latest': '14.1.8',
        'latestReleaseDate': '2021-11-15',
        'lts': False,
        'releaseDate': '2021-07-21',
        'support': '2021-08-22'},
    {   'cycle': '14.0',
        'eol': '2021-09-22',
        'latest': '14.0.12',
        'latestReleaseDate': '2021-11-05',
        'lts': False,
        'releaseDate': '2021-06-21',
        'support': '2021-07-22'},
    {   'cycle': '13.12',
        'eol': '2021-08-22',
        'latest': '13.12.15',
        'latestReleaseDate': '2021-11-03',
        'lts': False,
        'releaseDate': '2021-05-21',
        'support': '2021-06-22'},
    {   'cycle': '13.11',
        'eol': '2021-07-22',
        'latest': '13.11.7',
        'latestReleaseDate': '2021-07-07',
        'lts': False,
        'releaseDate': '2021-04-21',
        'support': '2021-05-22'},
    {   'cycle': '13.10',
        'eol': '2021-06-22',
        'latest': '13.10.5',
        'latestReleaseDate': '2021-06-01',
        'lts': False,
        'releaseDate': '2021-03-18',
        'support': '2021-04-22'},
    ],


    'https://endoflife.date/api/grafana.json': [
    {   'cycle': '12.1',
        'eol': '2026-04-22',
        'latest': '12.1.1',
        'latestReleaseDate': '2025-08-13',
        'lts': False,
        'releaseDate': '2025-07-22',
        'support': True},
    {   'cycle': '12.0',
        'eol': '2026-02-05',
        'latest': '12.0.4',
        'latestReleaseDate': '2025-08-13',
        'lts': False,
        'releaseDate': '2025-05-05',
        'support': '2025-07-22'},
    {   'cycle': '11.6',
        'eol': '2026-06-25',
        'latest': '11.6.5',
        'latestReleaseDate': '2025-08-12',
        'lts': False,
        'releaseDate': '2025-03-25',
        'support': '2025-05-05'},
    {   'cycle': '11.5',
        'eol': '2025-10-28',
        'latest': '11.5.8',
        'latestReleaseDate': '2025-08-12',
        'lts': False,
        'releaseDate': '2025-01-28',
        'support': '2025-03-25'},
    {   'cycle': '11.4',
        'eol': '2025-09-05',
        'latest': '11.4.8',
        'latestReleaseDate': '2025-08-12',
        'lts': False,
        'releaseDate': '2024-12-05',
        'support': '2025-01-28'},
    {   'cycle': '11.3',
        'eol': '2025-07-22',
        'latest': '11.3.9',
        'latestReleaseDate': '2025-07-18',
        'lts': False,
        'releaseDate': '2024-10-22',
        'support': '2024-12-05'},
    {   'cycle': '11.2',
        'eol': '2025-05-27',
        'latest': '11.2.10+security-01',
        'latestReleaseDate': '2025-05-28',
        'lts': False,
        'releaseDate': '2024-08-27',
        'support': '2024-10-22'},
    {   'cycle': '11.1',
        'eol': '2025-04-23',
        'latest': '11.1.13',
        'latestReleaseDate': '2025-03-21',
        'lts': False,
        'releaseDate': '2024-06-25',
        'support': '2024-08-27'},
    {   'cycle': '11.0',
        'eol': '2025-02-14',
        'latest': '11.0.11',
        'latestReleaseDate': '2025-02-14',
        'lts': False,
        'releaseDate': '2024-05-14',
        'support': '2024-06-21'},
    {   'cycle': '10.4',
        'eol': '2025-06-05',
        'latest': '10.4.19+security-01',
        'latestReleaseDate': '2025-06-12',
        'lts': False,
        'releaseDate': '2024-03-05',
        'support': '2024-05-13'},
    {   'cycle': '10.3',
        'eol': '2024-10-23',
        'latest': '10.3.12',
        'latestReleaseDate': '2024-10-18',
        'lts': False,
        'releaseDate': '2024-01-23',
        'support': '2024-03-06'},
    {   'cycle': '10.2',
        'eol': '2024-07-24',
        'latest': '10.2.9',
        'latestReleaseDate': '2024-07-23',
        'lts': False,
        'releaseDate': '2023-10-24',
        'support': '2024-01-23'},
    {   'cycle': '10.1',
        'eol': '2024-01-23',
        'latest': '10.1.10',
        'latestReleaseDate': '2024-05-13',
        'lts': False,
        'releaseDate': '2023-08-23',
        'support': '2023-10-24'},
    {   'cycle': '10.0',
        'eol': '2023-10-24',
        'latest': '10.0.13',
        'latestReleaseDate': '2024-03-25',
        'lts': False,
        'releaseDate': '2023-06-09',
        'support': '2023-08-23'},
    {   'cycle': '9.5',
        'eol': '2024-05-14',
        'latest': '9.5.21',
        'latestReleaseDate': '2024-07-25',
        'lts': False,
        'releaseDate': '2023-04-06',
        'support': '2023-06-09'},
    {   'cycle': '9.4',
        'eol': '2023-06-09',
        'latest': '9.4.17',
        'latestReleaseDate': '2023-10-11',
        'lts': False,
        'releaseDate': '2023-02-27',
        'support': '2023-04-06'},
    {   'cycle': '9.3',
        'eol': '2023-04-06',
        'latest': '9.3.16',
        'latestReleaseDate': '2023-06-07',
        'lts': False,
        'releaseDate': '2022-11-29',
        'support': '2023-02-27'},
    {   'cycle': '9.2',
        'eol': '2023-02-27',
        'latest': '9.2.20',
        'latestReleaseDate': '2023-06-07',
        'lts': False,
        'releaseDate': '2022-10-11',
        'support': '2022-11-29'},
    {   'cycle': '9.1',
        'eol': '2022-11-29',
        'latest': '9.1.8',
        'latestReleaseDate': '2022-10-11',
        'lts': False,
        'releaseDate': '2022-08-16',
        'support': '2022-10-11'},
    {   'cycle': '9.0',
        'eol': '2022-10-11',
        'latest': '9.0.9',
        'latestReleaseDate': '2022-09-20',
        'lts': False,
        'releaseDate': '2022-06-13',
        'support': '2022-08-16'},
    {   'cycle': '8',
        'eol': '2023-06-09',
        'latest': '8.5.27',
        'latestReleaseDate': '2023-06-07',
        'lts': False,
        'releaseDate': '2021-06-08',
        'support': '2022-06-13'},
    {   'cycle': '7',
        'eol': '2022-06-14',
        'latest': '7.5.17',
        'latestReleaseDate': '2022-09-26',
        'lts': False,
        'releaseDate': '2020-05-15',
        'support': '2021-06-08'},
    {   'cycle': '6',
        'eol': '2021-06-08',
        'latest': '6.7.6',
        'latestReleaseDate': '2021-03-18',
        'lts': False,
        'releaseDate': '2019-02-25',
        'support': '2020-05-15'},
    ],


    'https://endoflife.date/api/graylog.json': [
    {   'cycle': '6.3',
        'eol': False,
        'latest': '6.3.3',
        'latestReleaseDate': '2025-09-03',
        'lts': False,
        'releaseDate': '2025-06-30'},
    {   'cycle': '6.2',
        'eol': False,
        'latest': '6.2.7',
        'latestReleaseDate': '2025-09-03',
        'lts': False,
        'releaseDate': '2025-04-28'},
    {   'cycle': '6.1',
        'eol': '2025-06-30',
        'latest': '6.1.15',
        'latestReleaseDate': '2025-09-03',
        'lts': False,
        'releaseDate': '2024-10-18'},
    {   'cycle': '6.0',
        'eol': '2025-04-28',
        'latest': '6.0.14',
        'latestReleaseDate': '2025-04-03',
        'lts': False,
        'releaseDate': '2024-05-06'},
    {   'cycle': '5.2',
        'eol': '2024-10-18',
        'latest': '5.2.12',
        'latestReleaseDate': '2024-10-02',
        'lts': False,
        'releaseDate': '2023-10-30'},
    {   'cycle': '5.1',
        'eol': '2024-05-06',
        'latest': '5.1.13',
        'latestReleaseDate': '2024-04-03',
        'lts': False,
        'releaseDate': '2023-05-11'},
    {   'cycle': '5.0',
        'eol': '2023-10-30',
        'latest': '5.0.13',
        'latestReleaseDate': '2023-10-12',
        'lts': False,
        'releaseDate': '2022-11-30'},
    {   'cycle': '4.3',
        'eol': '2023-05-11',
        'latest': '4.3.15',
        'latestReleaseDate': '2023-05-03',
        'lts': False,
        'releaseDate': '2022-05-17'},
    {   'cycle': '4.2',
        'eol': '2022-11-30',
        'latest': '4.2.13',
        'latestReleaseDate': '2022-09-16',
        'lts': False,
        'releaseDate': '2021-10-13'},
    {   'cycle': '4.1',
        'eol': '2022-05-17',
        'latest': '4.1.14',
        'latestReleaseDate': '2022-04-12',
        'lts': False,
        'releaseDate': '2021-06-23'},
    {   'cycle': '4.0',
        'eol': '2021-10-13',
        'latest': '4.0.17',
        'latestReleaseDate': '2022-07-06',
        'lts': False,
        'releaseDate': '2020-11-17'},
    {   'cycle': '3.3',
        'eol': '2022-04-12',
        'latest': '3.3.17',
        'latestReleaseDate': '2022-04-12',
        'lts': False,
        'releaseDate': '2020-05-20'},
    {   'cycle': '3.2',
        'eol': '2020-05-20',
        'latest': '3.2.6',
        'latestReleaseDate': '2020-06-10',
        'link': 'https://graylog.org/post/announcing-graylog-v3-2-6/',
        'lts': False,
        'releaseDate': '2020-01-31'},
    {   'cycle': '3.1',
        'eol': '2020-01-31',
        'latest': '3.1.4',
        'latestReleaseDate': '2020-01-14',
        'link': 'https://graylog.org/post/announcing-graylog-3-1-4/',
        'lts': False,
        'releaseDate': '2019-08-15'},
    {   'cycle': '3.0',
        'eol': '2019-08-15',
        'latest': '3.0.2',
        'latestReleaseDate': '2019-05-03',
        'link': 'https://graylog.org/post/announcing-graylog-3-0-2/',
        'lts': False,
        'releaseDate': '2019-02-11'},
    {   'cycle': '2.5',
        'eol': '2019-02-11',
        'latest': '2.5.2',
        'latestReleaseDate': '2019-03-15',
        'link': 'https://graylog.org/post/announcing-graylog-v2-5/',
        'lts': False,
        'releaseDate': '2018-12-01'},
    {   'cycle': '2.4',
        'eol': '2019-03-01',
        'latest': '2.4.7',
        'latestReleaseDate': '2019-03-01',
        'link': 'https://graylog.org/post/announcing-the-release-of-graylog-2-4-6/',
        'lts': False,
        'releaseDate': '2017-12-22'},
    {   'cycle': '2.3',
        'eol': '2017-12-22',
        'latest': '2.3.2',
        'latestReleaseDate': '2017-10-19',
        'link': 'https://graylog.org/post/announcing-graylog-v2-3-2/',
        'lts': False,
        'releaseDate': '2017-07-26'},
    {   'cycle': '2.2',
        'eol': '2017-07-26',
        'latest': '2.2.3',
        'latestReleaseDate': '2017-04-04',
        'link': 'https://graylog.org/post/announcing-graylog-v2-2-3/',
        'lts': False,
        'releaseDate': '2017-02-09'},
    {   'cycle': '2.1',
        'eol': '2017-02-09',
        'latest': '2.1.3',
        'latestReleaseDate': '2017-01-26',
        'link': 'https://graylog.org/post/announcing-graylog-2-1-3/',
        'lts': False,
        'releaseDate': '2016-09-01'},
    {   'cycle': '2.0',
        'eol': '2016-09-01',
        'latest': '2.0.3',
        'latestReleaseDate': '2016-06-20',
        'link': 'https://graylog.org/post/graylog-v2-0-3-released/',
        'lts': False,
        'releaseDate': '2016-04-26'},
    {   'cycle': '1.3',
        'eol': '2016-04-26',
        'latest': '1.3.4',
        'latestReleaseDate': '2016-03-16',
        'link': 'https://graylog.org/post/graylog-1-3-4-is-now-available/',
        'lts': False,
        'releaseDate': '2015-12-08'},
    {   'cycle': '1.2',
        'eol': '2015-12-08',
        'latest': '1.2.2',
        'latestReleaseDate': '2015-10-26',
        'link': 'https://graylog.org/post/graylog-1-2-2-is-now-available/',
        'lts': False,
        'releaseDate': '2015-09-14'},
    {   'cycle': '1.1',
        'eol': '2015-09-14',
        'latest': '1.1.6',
        'latestReleaseDate': '2015-08-06',
        'link': 'https://graylog.org/post/graylog-1-1-6-released/',
        'lts': False,
        'releaseDate': '2015-06-04'},
    {   'cycle': '1.0',
        'eol': '2015-06-04',
        'latest': '1.0.2',
        'latestReleaseDate': '2015-04-28',
        'link': None,
        'lts': False,
        'releaseDate': '2015-02-17'},
    ],


    'https://endoflife.date/api/icinga.json': [
    {   'cycle': '2.15',
        'eol': False,
        'latest': '2.15.0',
        'latestReleaseDate': '2025-06-17',
        'lts': False,
        'releaseDate': '2025-06-17',
        'support': True},
    {   'cycle': '2.14',
        'eol': False,
        'latest': '2.14.6',
        'latestReleaseDate': '2025-05-21',
        'lts': False,
        'releaseDate': '2023-07-12',
        'support': '2025-06-17'},
    {   'cycle': '2.13',
        'eol': '2025-06-17',
        'latest': '2.13.12',
        'latestReleaseDate': '2025-05-22',
        'lts': False,
        'releaseDate': '2021-08-02',
        'support': '2023-07-12'},
    {   'cycle': '2.12',
        'eol': '2023-07-12',
        'latest': '2.12.12',
        'latestReleaseDate': '2025-05-22',
        'lts': False,
        'releaseDate': '2020-08-03',
        'support': '2021-08-02'},
    {   'cycle': '2.11',
        'eol': '2021-08-02',
        'latest': '2.11.12',
        'latestReleaseDate': '2024-10-29',
        'lts': False,
        'releaseDate': '2019-09-19',
        'support': '2020-08-03'},
    {   'cycle': '2.10',
        'eol': '2020-08-03',
        'latest': '2.12.10',
        'latestReleaseDate': '2023-02-16',
        'lts': False,
        'releaseDate': '2018-10-11',
        'support': '2019-09-19'},
    {   'cycle': '2.9',
        'eol': '2018-10-11',
        'latest': '2.9.3',
        'latestReleaseDate': '2019-07-30',
        'lts': False,
        'releaseDate': '2018-07-17',
        'support': '2018-10-11'},
    {   'cycle': '2.8',
        'eol': '2018-07-17',
        'latest': '2.8.4',
        'latestReleaseDate': '2018-04-25',
        'lts': False,
        'releaseDate': '2017-11-16',
        'support': '2018-07-17'},
    {   'cycle': '2.7',
        'eol': '2017-11-16',
        'latest': '2.7.2',
        'latestReleaseDate': '2017-11-09',
        'lts': False,
        'releaseDate': '2017-08-02',
        'support': '2017-11-16'},
    {   'cycle': '2.6',
        'eol': '2017-08-02',
        'latest': '2.6.3',
        'latestReleaseDate': '2017-03-29',
        'lts': False,
        'releaseDate': '2016-12-13',
        'support': '2017-08-02'},
    {   'cycle': '2.5',
        'eol': '2016-12-13',
        'latest': '2.5.4',
        'latestReleaseDate': '2016-08-30',
        'lts': False,
        'releaseDate': '2016-08-22',
        'support': '2016-12-13'},
    {   'cycle': '2.4',
        'eol': '2016-08-22',
        'latest': '2.4.10',
        'latestReleaseDate': '2016-05-19',
        'lts': False,
        'releaseDate': '2015-11-16',
        'support': '2016-08-22'},
    {   'cycle': '2.3',
        'eol': '2015-11-16',
        'latest': '2.3.11',
        'latestReleaseDate': '2015-10-19',
        'lts': False,
        'releaseDate': '2015-03-09',
        'support': '2015-11-16'},
    {   'cycle': '2.2',
        'eol': '2015-03-09',
        'latest': '2.2.4',
        'latestReleaseDate': '2015-02-05',
        'lts': False,
        'releaseDate': '2014-11-17',
        'support': '2015-03-09'},
    {   'cycle': '2.1',
        'eol': '2014-11-17',
        'latest': '2.1.1',
        'latestReleaseDate': '2014-09-16',
        'lts': False,
        'releaseDate': '2014-08-29',
        'support': '2014-11-17'},
    {   'cycle': '2.0',
        'eol': '2014-08-29',
        'latest': '2.0.2',
        'latestReleaseDate': '2014-08-07',
        'lts': False,
        'releaseDate': '2014-06-16',
        'support': '2014-08-29'},
    {   'cycle': '1',
        'eol': '2018-12-31',
        'latest': '1.14.2',
        'latestReleaseDate': '2017-12-20',
        'link': None,
        'lts': False,
        'releaseDate': '2009-12-15',
        'support': '2014-06-16'},
    ],


    'https://endoflife.date/api/keycloak.json': [
    {   'cycle': '26.3',
        'eol': False,
        'latest': '26.3.4',
        'latestReleaseDate': '2025-09-12',
        'lts': False,
        'releaseDate': '2025-07-02'},
    {   'cycle': '26.2',
        'eol': '2025-07-02',
        'latest': '26.2.5',
        'latestReleaseDate': '2025-05-28',
        'lts': False,
        'releaseDate': '2025-04-11'},
    {   'cycle': '26.1',
        'eol': '2025-04-11',
        'latest': '26.1.5',
        'latestReleaseDate': '2025-04-11',
        'lts': False,
        'releaseDate': '2025-01-15'},
    {   'cycle': '26.0',
        'eol': '2025-01-15',
        'latest': '26.0.8',
        'latestReleaseDate': '2025-01-13',
        'lts': False,
        'releaseDate': '2024-10-04'},
    {   'cycle': '25.0',
        'eol': '2024-10-04',
        'latest': '25.0.6',
        'latestReleaseDate': '2024-09-19',
        'lts': False,
        'releaseDate': '2024-06-10'},
    {   'cycle': '24.0',
        'eol': '2024-06-10',
        'latest': '24.0.5',
        'latestReleaseDate': '2024-06-04',
        'lts': False,
        'releaseDate': '2024-03-04'},
    {   'cycle': '23.0',
        'eol': '2024-03-04',
        'latest': '23.0.7',
        'latestReleaseDate': '2024-02-22',
        'lts': False,
        'releaseDate': '2023-11-23'},
    {   'cycle': '22.0',
        'eol': '2023-11-23',
        'latest': '22.0.5',
        'latestReleaseDate': '2023-10-24',
        'lts': False,
        'releaseDate': '2023-07-11'},
    {   'cycle': '21.1',
        'eol': '2023-07-11',
        'latest': '21.1.2',
        'latestReleaseDate': '2023-06-28',
        'lts': False,
        'releaseDate': '2023-04-19'},
    {   'cycle': '21.0',
        'eol': '2023-04-19',
        'latest': '21.0.2',
        'latestReleaseDate': '2023-03-30',
        'lts': False,
        'releaseDate': '2023-02-23'},
    {   'cycle': '20.0',
        'eol': '2023-02-23',
        'latest': '20.0.5',
        'latestReleaseDate': '2023-02-21',
        'lts': False,
        'releaseDate': '2022-11-01'},
    {   'cycle': '19.0',
        'eol': '2022-11-01',
        'latest': '19.0.3',
        'latestReleaseDate': '2022-10-06',
        'lts': False,
        'releaseDate': '2022-07-27'},
    {   'cycle': '18.0',
        'eol': '2022-07-27',
        'latest': '18.0.2',
        'latestReleaseDate': '2022-06-24',
        'lts': False,
        'releaseDate': '2022-04-20'},
    {   'cycle': '17.0',
        'eol': '2022-04-20',
        'latest': '17.0.1',
        'latestReleaseDate': '2022-03-23',
        'lts': False,
        'releaseDate': '2022-02-11'},
    {   'cycle': '16.1',
        'eol': '2022-03-11',
        'latest': '16.1.1',
        'latestReleaseDate': '2022-01-25',
        'lts': False,
        'releaseDate': '2021-12-20'},
    {   'cycle': '16.0',
        'eol': '2021-12-20',
        'latest': '16.0.0',
        'latestReleaseDate': '2021-12-17',
        'lts': False,
        'releaseDate': '2021-12-17'},
    {   'cycle': '15.1',
        'eol': '2021-12-17',
        'latest': '15.1.1',
        'latestReleaseDate': '2021-12-17',
        'lts': False,
        'releaseDate': '2021-12-10'},
    {   'cycle': '15.0',
        'eol': '2021-12-10',
        'latest': '15.0.2',
        'latestReleaseDate': '2021-08-20',
        'lts': False,
        'releaseDate': '2021-07-30'},
    {   'cycle': '14.0',
        'eol': '2021-07-15',
        'latest': '14.0.0',
        'latestReleaseDate': '2021-06-18',
        'lts': False,
        'releaseDate': '2021-06-18'},
    {   'cycle': '13.0',
        'eol': '2021-06-18',
        'latest': '13.0.1',
        'latestReleaseDate': '2021-05-25',
        'lts': False,
        'releaseDate': '2021-05-06'},
    {   'cycle': '12.0',
        'eol': '2021-05-06',
        'latest': '12.0.4',
        'latestReleaseDate': '2021-03-01',
        'lts': False,
        'releaseDate': '2020-12-16'},
    {   'cycle': '11.0',
        'eol': '2020-12-16',
        'latest': '11.0.3',
        'latestReleaseDate': '2020-11-05',
        'lts': False,
        'releaseDate': '2020-07-22'},
    {   'cycle': '10.0',
        'eol': '2020-07-22',
        'latest': '10.0.2',
        'latestReleaseDate': '2020-06-02',
        'lts': False,
        'releaseDate': '2020-04-29'},
    ],


    'https://endoflife.date/api/mariadb.json': [
    {   'cycle': '12.0',
        'eol': '2025-11-07',
        'extendedSupport': False,
        'latest': '12.0.2',
        'latestReleaseDate': '2025-08-07',
        'link': 'https://mariadb.com/docs/release-notes/community-server/release-notes-mariadb-__RELEASE_CYCLE__-rolling-releases/mariadb-__LATEST__-release-notes',
        'lts': False,
        'releaseDate': '2025-06-05'},
    {   'cycle': '11.8',
        'eol': '2028-06-04',
        'extendedSupport': '2033-10-15',
        'latest': '11.8.3',
        'latestReleaseDate': '2025-08-06',
        'lts': True,
        'releaseDate': '2025-06-04'},
    {   'cycle': '11.7',
        'eol': '2025-05-12',
        'extendedSupport': False,
        'latest': '11.7.2',
        'latestReleaseDate': '2025-02-12',
        'link': 'https://mariadb.com/docs/release-notes/community-server/old-releases/mariadb-11-7-rolling-releases/mariadb-11-7-2-release-notes',
        'lts': False,
        'releaseDate': '2025-02-12'},
    {   'cycle': '11.6',
        'eol': '2025-02-13',
        'extendedSupport': False,
        'latest': '11.6.2',
        'latestReleaseDate': '2024-11-13',
        'link': 'https://mariadb.com/docs/release-notes/community-server/old-releases/release-notes-mariadb-11-6-rolling-releases/mariadb-11-6-2-release-notes',
        'lts': False,
        'releaseDate': '2024-11-13'},
    {   'cycle': '11.5',
        'eol': '2024-11-21',
        'extendedSupport': False,
        'latest': '11.5.2',
        'latestReleaseDate': '2024-08-14',
        'link': 'https://mariadb.com/docs/release-notes/community-server/old-releases/release-notes-mariadb-11-5-rolling-releases/mariadb-11-5-2-release-notes',
        'lts': False,
        'releaseDate': '2024-08-14'},
    {   'cycle': '11.4',
        'eol': '2029-05-29',
        'extendedSupport': '2033-01-16',
        'latest': '11.4.8',
        'latestReleaseDate': '2025-08-06',
        'lts': True,
        'releaseDate': '2024-05-29'},
    {   'cycle': '11.3',
        'eol': '2024-05-29',
        'extendedSupport': False,
        'latest': '11.3.2',
        'latestReleaseDate': '2024-02-16',
        'link': 'https://mariadb.com/docs/release-notes/community-server/old-releases/release-notes-mariadb-11-3-rolling-releases/mariadb-11-3-2-release-notes',
        'lts': False,
        'releaseDate': '2024-02-16'},
    {   'cycle': '11.2',
        'eol': '2024-11-21',
        'extendedSupport': False,
        'latest': '11.2.6',
        'latestReleaseDate': '2024-11-01',
        'link': 'https://mariadb.com/docs/release-notes/community-server/old-releases/release-notes-mariadb-11-2-series/mariadb-11-2-6-release-notes',
        'lts': False,
        'releaseDate': '2023-11-21'},
    {   'cycle': '11.1',
        'eol': '2024-08-21',
        'extendedSupport': False,
        'latest': '11.1.6',
        'latestReleaseDate': '2024-08-08',
        'link': 'https://mariadb.com/docs/release-notes/community-server/old-releases/release-notes-mariadb-11-1-series/mariadb-11-1-6-release-notes',
        'lts': False,
        'releaseDate': '2023-08-21'},
    {   'cycle': '11.0',
        'eol': '2024-06-06',
        'extendedSupport': False,
        'latest': '11.0.6',
        'latestReleaseDate': '2024-05-15',
        'link': 'https://mariadb.com/docs/release-notes/community-server/old-releases/release-notes-mariadb-11-0-series/mariadb-11-0-6-release-notes',
        'lts': False,
        'releaseDate': '2023-06-06'},
    {   'cycle': '10.11',
        'eol': '2028-02-16',
        'extendedSupport': '2028-02-16',
        'latest': '10.11.14',
        'latestReleaseDate': '2025-08-06',
        'lts': True,
        'releaseDate': '2023-02-16'},
    {   'cycle': '10.10',
        'eol': '2023-11-17',
        'extendedSupport': False,
        'latest': '10.10.7',
        'latestReleaseDate': '2023-11-13',
        'link': 'https://mariadb.com/docs/release-notes/community-server/old-releases/release-notes-mariadb-10-10-series/mariadb-10-10-7-release-notes',
        'lts': False,
        'releaseDate': '2022-11-07'},
    {   'cycle': '10.9',
        'eol': '2023-08-22',
        'extendedSupport': False,
        'latest': '10.9.8',
        'latestReleaseDate': '2023-08-14',
        'link': 'https://mariadb.com/docs/release-notes/community-server/old-releases/release-notes-mariadb-10-9-series/mariadb-10-9-8-release-notes',
        'lts': False,
        'releaseDate': '2022-08-15'},
    {   'cycle': '10.8',
        'eol': '2023-05-20',
        'extendedSupport': False,
        'latest': '10.8.8',
        'latestReleaseDate': '2023-05-10',
        'link': 'https://mariadb.com/docs/release-notes/community-server/old-releases/release-notes-mariadb-10-8-series/mariadb-10-8-8-release-notes',
        'lts': False,
        'releaseDate': '2022-05-20'},
    {   'cycle': '10.7',
        'eol': '2023-02-09',
        'extendedSupport': False,
        'latest': '10.7.8',
        'latestReleaseDate': '2023-02-06',
        'link': 'https://mariadb.com/docs/release-notes/community-server/old-releases/release-notes-mariadb-10-7-series/mariadb-10-7-8-release-notes',
        'lts': False,
        'releaseDate': '2022-02-08'},
    {   'cycle': '10.6',
        'eol': '2026-07-06',
        'extendedSupport': '2029-08-23',
        'latest': '10.6.23',
        'latestReleaseDate': '2025-08-06',
        'lts': True,
        'releaseDate': '2021-07-06'},
    {   'cycle': '10.5',
        'eol': '2025-06-24',
        'extendedSupport': '2025-07-16',
        'latest': '10.5.29',
        'latestReleaseDate': '2025-05-06',
        'link': 'https://mariadb.com/docs/release-notes/community-server/old-releases/mariadb-10-5-series/mariadb-10-5-29-release-notes',
        'lts': True,
        'releaseDate': '2020-06-24'},
    {   'cycle': '10.4',
        'eol': '2024-06-18',
        'extendedSupport': '2024-06-18',
        'latest': '10.4.34',
        'latestReleaseDate': '2024-05-15',
        'link': 'https://mariadb.com/docs/release-notes/community-server/old-releases/release-notes-mariadb-10-4-series/mariadb-10-4-34-release-notes',
        'lts': True,
        'releaseDate': '2019-06-18'},
    {   'cycle': '10.3',
        'eol': '2023-05-25',
        'extendedSupport': '2023-05-25',
        'latest': '10.3.39',
        'latestReleaseDate': '2023-05-10',
        'link': 'https://mariadb.com/docs/release-notes/community-server/old-releases/release-notes-mariadb-10-3-series/mariadb-10-3-39-release-notes',
        'lts': False,
        'releaseDate': '2018-05-25'},
    {   'cycle': '10.2',
        'eol': '2022-05-23',
        'extendedSupport': '2022-05-23',
        'latest': '10.2.44',
        'latestReleaseDate': '2022-05-20',
        'link': 'https://mariadb.com/kb/en/mariadb-10244-release-notes/',
        'lts': False,
        'releaseDate': '2017-05-23'},
    {   'cycle': '10.1',
        'eol': '2020-10-17',
        'extendedSupport': '2020-10-17',
        'latest': '10.1.48',
        'latestReleaseDate': '2020-10-30',
        'link': 'https://mariadb.com/kb/en/mariadb-10148-release-notes/',
        'lts': False,
        'releaseDate': '2015-10-17'},
    {   'cycle': '10.0',
        'eol': '2019-03-31',
        'extendedSupport': '2019-03-31',
        'latest': '10.0.38',
        'latestReleaseDate': '2019-01-29',
        'link': 'https://mariadb.com/kb/en/mariadb-10038-release-notes/',
        'lts': False,
        'releaseDate': '2014-03-31'},
    {   'cycle': '5.5',
        'eol': '2020-04-11',
        'extendedSupport': '2020-04-11',
        'latest': '5.5.68',
        'latestReleaseDate': '2020-05-06',
        'link': 'https://mariadb.com/kb/en/mariadb-5568-release-notes/',
        'lts': True,
        'releaseDate': '2012-04-11'},
    {   'cycle': '5.3',
        'eol': '2017-03-01',
        'extendedSupport': '2017-03-01',
        'latest': '5.3.12',
        'latestReleaseDate': '2013-01-28',
        'link': 'https://mariadb.com/kb/en/mariadb-5312-release-notes/',
        'lts': False,
        'releaseDate': '2012-02-29'},
    {   'cycle': '5.2',
        'eol': '2015-11-10',
        'extendedSupport': '2015-11-10',
        'latest': '5.2.14',
        'latestReleaseDate': '2013-01-28',
        'link': 'https://mariadb.com/kb/en/mariadb-5214-release-notes/',
        'lts': False,
        'releaseDate': '2010-11-10'},
    {   'cycle': '5.1',
        'eol': '2015-02-01',
        'extendedSupport': '2015-02-01',
        'latest': '5.1.67',
        'latestReleaseDate': '2013-01-25',
        'link': 'https://mariadb.com/kb/en/mariadb-5167-release-notes/',
        'lts': False,
        'releaseDate': '2010-02-01'},
    ],


    'https://endoflife.date/api/mastodon.json': [
    {   'cycle': '4.4',
        'eol': False,
        'latest': '4.4.3',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2025-07-08'},
    {   'cycle': '4.3',
        'eol': False,
        'latest': '4.3.11',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2024-10-08'},
    {   'cycle': '4.2',
        'eol': '2026-01-08',
        'latest': '4.2.24',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2023-09-21'},
    {   'cycle': '4.1',
        'eol': '2025-04-08',
        'latest': '4.1.25',
        'latestReleaseDate': '2025-04-02',
        'lts': False,
        'releaseDate': '2023-02-10'},
    {   'cycle': '4.0',
        'eol': '2023-10-31',
        'latest': '4.0.15',
        'latestReleaseDate': '2024-02-16',
        'lts': False,
        'releaseDate': '2022-11-14'},
    {   'cycle': '3.5',
        'eol': '2023-12-31',
        'latest': '3.5.19',
        'latestReleaseDate': '2024-02-16',
        'lts': False,
        'releaseDate': '2022-03-30'},
    {   'cycle': '3.4',
        'eol': '2022-11-06',
        'latest': '3.4.10',
        'latestReleaseDate': '2022-11-14',
        'lts': False,
        'releaseDate': '2021-05-16'},
    {   'cycle': '3.3',
        'eol': '2022-05-26',
        'latest': '3.3.3',
        'latestReleaseDate': '2022-03-30',
        'lts': False,
        'releaseDate': '2020-12-27'},
    {   'cycle': '3.2',
        'eol': True,
        'latest': '3.2.2',
        'latestReleaseDate': '2020-12-19',
        'lts': False,
        'releaseDate': '2020-07-27'},
    {   'cycle': '3.1',
        'eol': True,
        'latest': '3.1.5',
        'latestReleaseDate': '2020-07-07',
        'lts': False,
        'releaseDate': '2020-02-09'},
    {   'cycle': '3.0',
        'eol': True,
        'latest': '3.0.2',
        'latestReleaseDate': '2020-02-27',
        'lts': False,
        'releaseDate': '2019-10-03'},
    {   'cycle': '2',
        'eol': True,
        'latest': '2.9.4',
        'latestReleaseDate': '2020-02-27',
        'lts': False,
        'releaseDate': '2017-10-18'},
    {   'cycle': '1',
        'eol': True,
        'latest': '1.6.1',
        'latestReleaseDate': '2017-09-17',
        'lts': False,
        'releaseDate': '2017-02-05'},
    ],


    'https://endoflife.date/api/matomo.json': [
    {   'cycle': '5',
        'eol': False,
        'latest': '5.4.0',
        'latestReleaseDate': '2025-08-26',
        'lts': False,
        'releaseDate': '2023-12-18',
        'support': True},
    {   'cycle': '4',
        'eol': '2024-12-19',
        'latest': '4.16.1',
        'latestReleaseDate': '2024-02-05',
        'lts': False,
        'releaseDate': '2020-11-24',
        'support': '2023-12-18'},
    {   'cycle': '3',
        'eol': '2021-12-01',
        'latest': '3.14.1',
        'latestReleaseDate': '2020-09-11',
        'lts': False,
        'releaseDate': '2016-12-19',
        'support': '2020-11-24'},
    {   'cycle': '2',
        'eol': '2017-12-18',
        'latest': '2.18.1',
        'latestReleaseDate': '2020-07-01',
        'lts': False,
        'releaseDate': '2013-12-17',
        'support': '2016-12-19'},
    {   'cycle': '1',
        'eol': '2013-12-17',
        'latest': '1.12',
        'latestReleaseDate': '2013-05-30',
        'lts': False,
        'releaseDate': '2010-08-28',
        'support': '2013-12-17'},
    ],


    'https://endoflife.date/api/mediawiki.json': [
    {   'cycle': '1.44',
        'eol': '2026-06-30',
        'latest': '1.44.0',
        'latestReleaseDate': '2025-07-02',
        'lts': False,
        'releaseDate': '2025-07-02'},
    {   'cycle': '1.43',
        'eol': '2027-12-31',
        'latest': '1.43.3',
        'latestReleaseDate': '2025-07-01',
        'lts': True,
        'releaseDate': '2024-12-21'},
    {   'cycle': '1.42',
        'eol': '2025-06-30',
        'latest': '1.42.7',
        'latestReleaseDate': '2025-06-30',
        'lts': False,
        'releaseDate': '2024-06-27'},
    {   'cycle': '1.41',
        'eol': '2024-12-31',
        'latest': '1.41.5',
        'latestReleaseDate': '2024-12-20',
        'lts': False,
        'releaseDate': '2023-12-21'},
    {   'cycle': '1.40',
        'eol': '2024-06-28',
        'latest': '1.40.4',
        'latestReleaseDate': '2024-06-27',
        'lts': False,
        'releaseDate': '2023-06-30'},
    {   'cycle': '1.39',
        'eol': '2025-12-31',
        'latest': '1.39.13',
        'latestReleaseDate': '2025-06-30',
        'lts': True,
        'releaseDate': '2022-11-30'},
    {   'cycle': '1.38',
        'eol': '2023-06-30',
        'latest': '1.38.7',
        'latestReleaseDate': '2023-06-30',
        'lts': False,
        'releaseDate': '2022-06-02'},
    {   'cycle': '1.37',
        'eol': '2022-11-30',
        'latest': '1.37.6',
        'latestReleaseDate': '2022-09-29',
        'lts': False,
        'releaseDate': '2021-11-18'},
    {   'cycle': '1.36',
        'eol': '2022-06-03',
        'latest': '1.36.4',
        'latestReleaseDate': '2022-03-31',
        'lts': False,
        'releaseDate': '2021-05-28'},
    {   'cycle': '1.35',
        'eol': '2023-12-21',
        'latest': '1.35.14',
        'latestReleaseDate': '2023-12-21',
        'lts': True,
        'releaseDate': '2020-09-25'},
    {   'cycle': '1.34',
        'eol': '2020-11-30',
        'latest': '1.34.4',
        'latestReleaseDate': '2020-09-24',
        'lts': False,
        'releaseDate': '2019-12-19'},
    {   'cycle': '1.33',
        'eol': '2020-06-30',
        'latest': '1.33.4',
        'latestReleaseDate': '2020-06-24',
        'lts': False,
        'releaseDate': '2019-07-02'},
    {   'cycle': '1.32',
        'eol': '2020-01-24',
        'latest': '1.32.6',
        'latestReleaseDate': '2019-12-19',
        'lts': False,
        'releaseDate': '2019-01-10'},
    {   'cycle': '1.31',
        'eol': '2021-09-30',
        'latest': '1.31.16',
        'latestReleaseDate': '2021-09-30',
        'lts': True,
        'releaseDate': '2018-06-13'},
    ],


    'https://endoflife.date/api/moodle.json': [
    {   'cycle': '5.0',
        'eol': '2026-10-05',
        'latest': '5.0.2',
        'latestReleaseDate': '2025-08-08',
        'lts': False,
        'releaseDate': '2025-04-14',
        'support': '2026-04-20',
        'supportedPhpVersions': '8.1 - 8.4'},
    {   'cycle': '4.5',
        'eol': '2027-10-06',
        'latest': '4.5.6',
        'latestReleaseDate': '2025-08-08',
        'lts': True,
        'releaseDate': '2024-10-07',
        'support': '2025-10-06',
        'supportedPhpVersions': '8.1 - 8.3'},
    {   'cycle': '4.4',
        'eol': '2025-12-08',
        'latest': '4.4.10',
        'latestReleaseDate': '2025-08-08',
        'lts': False,
        'releaseDate': '2024-04-22',
        'support': '2025-04-21',
        'supportedPhpVersions': '8.1 - 8.3'},
    {   'cycle': '4.3',
        'eol': '2025-04-21',
        'latest': '4.3.12',
        'latestReleaseDate': '2025-04-13',
        'lts': False,
        'releaseDate': '2023-10-07',
        'support': '2024-10-07',
        'supportedPhpVersions': '8.0 - 8.2'},
    {   'cycle': '4.2',
        'eol': '2024-10-07',
        'latest': '4.2.11',
        'latestReleaseDate': '2024-10-05',
        'lts': False,
        'releaseDate': '2023-04-22',
        'support': '2024-04-22',
        'supportedPhpVersions': '8.0 - 8.2'},
    {   'cycle': '4.1',
        'eol': '2025-12-08',
        'latest': '4.1.20',
        'latestReleaseDate': '2025-08-08',
        'lts': True,
        'releaseDate': '2022-11-28',
        'support': '2023-12-11',
        'supportedPhpVersions': '7.4 - 8.1'},
    {   'cycle': '4.0',
        'eol': '2023-11-13',
        'latest': '4.0.12',
        'latestReleaseDate': '2023-12-08',
        'lts': False,
        'releaseDate': '2022-04-17',
        'support': '2023-05-08',
        'supportedPhpVersions': '7.3 - 8.0'},
    {   'cycle': '3.11',
        'eol': '2023-11-13',
        'latest': '3.11.18',
        'latestReleaseDate': '2023-12-08',
        'lts': False,
        'releaseDate': '2021-05-15',
        'support': '2022-11-14',
        'supportedPhpVersions': '7.3 - 8.0'},
    {   'cycle': '3.10',
        'eol': '2022-05-09',
        'latest': '3.10.11',
        'latestReleaseDate': '2022-05-07',
        'lts': False,
        'releaseDate': '2020-11-07',
        'support': '2021-11-08',
        'supportedPhpVersions': '7.2 - 7.4'},
    {   'cycle': '3.9',
        'eol': '2023-11-13',
        'latest': '3.9.25',
        'latestReleaseDate': '2023-12-08',
        'lts': True,
        'releaseDate': '2020-06-13',
        'support': '2021-05-10',
        'supportedPhpVersions': '7.2 - 7.4'},
    {   'cycle': '3.8',
        'eol': '2021-05-10',
        'latest': '3.8.9',
        'latestReleaseDate': '2021-05-08',
        'lts': False,
        'releaseDate': '2019-11-16',
        'support': '2020-11-09',
        'supportedPhpVersions': '7.1 - 7.4'},
    ],


    'https://endoflife.date/api/mysql.json': [
    {   'cycle': '9.4',
        'eol': False,
        'latest': '9.4.0',
        'latestReleaseDate': '2025-07-09',
        'lts': False,
        'releaseDate': '2025-07-09',
        'support': True},
    {   'cycle': '9.3',
        'eol': '2025-07-22',
        'latest': '9.3.0',
        'latestReleaseDate': '2025-03-31',
        'lts': False,
        'releaseDate': '2025-03-31',
        'support': '2025-07-22'},
    {   'cycle': '9.2',
        'eol': '2025-04-15',
        'latest': '9.2.0',
        'latestReleaseDate': '2024-12-15',
        'lts': False,
        'releaseDate': '2024-12-15',
        'support': '2025-04-15'},
    {   'cycle': '9.1',
        'eol': '2025-01-21',
        'latest': '9.1.0',
        'latestReleaseDate': '2024-09-24',
        'lts': False,
        'releaseDate': '2024-09-24',
        'support': '2025-01-21'},
    {   'cycle': '9.0',
        'eol': '2024-10-15',
        'latest': '9.0.1',
        'latestReleaseDate': '2024-07-12',
        'lts': False,
        'releaseDate': '2024-06-07',
        'support': '2024-10-15'},
    {   'cycle': '8.4',
        'eol': '2032-04-30',
        'latest': '8.4.6',
        'latestReleaseDate': '2025-07-09',
        'lts': True,
        'releaseDate': '2024-04-10',
        'support': '2029-04-30'},
    {   'cycle': '8.3',
        'eol': '2024-04-10',
        'latest': '8.3.0',
        'latestReleaseDate': '2023-12-14',
        'lts': False,
        'releaseDate': '2023-12-14',
        'support': '2024-04-10'},
    {   'cycle': '8.2',
        'eol': '2023-12-14',
        'latest': '8.2.0',
        'latestReleaseDate': '2023-10-12',
        'lts': False,
        'releaseDate': '2023-10-12',
        'support': '2023-12-14'},
    {   'cycle': '8.1',
        'eol': '2023-10-25',
        'latest': '8.1.0',
        'latestReleaseDate': '2023-06-21',
        'lts': False,
        'releaseDate': '2023-06-21',
        'support': '2023-10-25'},
    {   'cycle': '8.0',
        'eol': '2026-04-30',
        'latest': '8.0.43',
        'latestReleaseDate': '2025-07-09',
        'lts': '2023-07-18',
        'releaseDate': '2018-04-08',
        'support': '2025-04-30'},
    {   'cycle': '5.7',
        'eol': '2023-10-31',
        'latest': '5.7.44',
        'latestReleaseDate': '2023-09-20',
        'lts': False,
        'releaseDate': '2015-10-09',
        'support': '2020-10-31'},
    {   'cycle': '5.6',
        'eol': '2021-02-28',
        'latest': '5.6.51',
        'latestReleaseDate': '2021-01-05',
        'link': 'https://web.archive.org/web/20211229071247/https://dev.mysql.com/doc/relnotes/mysql/5.6/en/news-5-6-51.html',
        'lts': False,
        'releaseDate': '2013-02-01',
        'support': '2018-02-28'},
    {   'cycle': '5.5',
        'eol': '2018-12-31',
        'latest': '5.5.63',
        'latestReleaseDate': '2018-12-21',
        'link': None,
        'lts': False,
        'releaseDate': '2010-12-03',
        'support': '2015-12-31'},
    ],


    'https://endoflife.date/api/nextcloud.json': [
    {   'cycle': '31',
        'eol': '2026-02-28',
        'latest': '31.0.9',
        'latestReleaseDate': '2025-09-11',
        'lts': False,
        'releaseDate': '2025-02-25'},
    {   'cycle': '30',
        'eol': '2025-09-30',
        'latest': '30.0.15',
        'latestReleaseDate': '2025-09-11',
        'lts': False,
        'releaseDate': '2024-09-14'},
    {   'cycle': '29',
        'eol': '2025-04-30',
        'latest': '29.0.16',
        'latestReleaseDate': '2025-04-17',
        'lts': False,
        'releaseDate': '2024-04-24'},
    {   'cycle': '28',
        'eol': '2024-12-31',
        'latest': '28.0.14',
        'latestReleaseDate': '2024-12-12',
        'lts': False,
        'releaseDate': '2023-12-12'},
    {   'cycle': '27',
        'eol': '2024-06-30',
        'latest': '27.1.11',
        'latestReleaseDate': '2024-06-25',
        'lts': False,
        'releaseDate': '2023-06-13'},
    {   'cycle': '26',
        'eol': '2024-03-31',
        'latest': '26.0.13',
        'latestReleaseDate': '2024-03-28',
        'lts': False,
        'releaseDate': '2023-03-21'},
    {   'cycle': '25',
        'eol': '2023-10-31',
        'latest': '25.0.13',
        'latestReleaseDate': '2023-10-26',
        'lts': False,
        'releaseDate': '2022-10-19'},
    {   'cycle': '24',
        'eol': '2023-04-30',
        'latest': '24.0.12',
        'latestReleaseDate': '2023-04-19',
        'lts': False,
        'releaseDate': '2022-05-03'},
    {   'cycle': '23',
        'eol': '2022-12-31',
        'latest': '23.0.12',
        'latestReleaseDate': '2022-12-08',
        'lts': False,
        'releaseDate': '2021-11-30'},
    {   'cycle': '22',
        'eol': '2022-07-31',
        'latest': '22.2.10',
        'latestReleaseDate': '2022-07-18',
        'lts': False,
        'releaseDate': '2021-07-06'},
    {   'cycle': '21',
        'eol': '2022-02-28',
        'latest': '21.0.9',
        'latestReleaseDate': '2022-02-15',
        'lts': False,
        'releaseDate': '2021-02-22'},
    {   'cycle': '20',
        'eol': '2021-11-30',
        'latest': '20.0.14',
        'latestReleaseDate': '2021-11-11',
        'lts': False,
        'releaseDate': '2020-10-03'},
    {   'cycle': '19',
        'eol': '2021-06-30',
        'latest': '19.0.13',
        'latestReleaseDate': '2021-07-01',
        'lts': False,
        'releaseDate': '2020-06-03'},
    {   'cycle': '18',
        'eol': '2021-01-31',
        'latest': '18.0.14',
        'latestReleaseDate': '2021-01-25',
        'lts': False,
        'releaseDate': '2020-01-16'},
    {   'cycle': '17',
        'eol': '2020-10-31',
        'latest': '17.0.10',
        'latestReleaseDate': '2020-10-08',
        'lts': False,
        'releaseDate': '2019-09-30'},
    {   'cycle': '16',
        'eol': '2020-06-30',
        'latest': '16.0.11',
        'latestReleaseDate': '2020-06-04',
        'lts': False,
        'releaseDate': '2019-04-25'},
    {   'cycle': '15',
        'eol': '2019-12-31',
        'latest': '15.0.14',
        'latestReleaseDate': '2019-12-19',
        'lts': False,
        'releaseDate': '2018-12-10'},
    {   'cycle': '14',
        'eol': '2019-09-30',
        'latest': '14.0.14',
        'latestReleaseDate': '2019-08-14',
        'lts': False,
        'releaseDate': '2018-09-10'},
    {   'cycle': '13',
        'eol': '2019-02-28',
        'latest': '13.0.12',
        'latestReleaseDate': '2019-02-27',
        'lts': False,
        'releaseDate': '2018-02-06'},
    {   'cycle': '12',
        'eol': '2018-11-30',
        'latest': '12.0.13',
        'latestReleaseDate': '2018-11-22',
        'lts': False,
        'releaseDate': '2017-05-22'},
    {   'cycle': '11',
        'eol': '2018-03-31',
        'latest': '11.0.8',
        'latestReleaseDate': '2018-03-13',
        'lts': False,
        'releaseDate': '2016-12-13'},
    {   'cycle': '10',
        'eol': '2017-08-31',
        'latest': '10.0.6',
        'latestReleaseDate': '2017-08-06',
        'lts': False,
        'releaseDate': '2016-08-25'},
    {   'cycle': '9',
        'eol': '2017-08-31',
        'latest': '9.1.3',
        'latestReleaseDate': '2016-12-12',
        'lts': False,
        'releaseDate': '2016-08-03'},
    ],


    'https://endoflife.date/api/openvpn.json': [
    {   'cycle': '2.6',
        'eol': False,
        'latest': '2.6.14',
        'latestReleaseDate': '2025-04-02',
        'lts': False,
        'releaseDate': '2023-01-25',
        'support': True},
    {   'cycle': '2.5',
        'eol': False,
        'latest': '2.5.11',
        'latestReleaseDate': '2024-07-18',
        'lts': False,
        'releaseDate': '2020-10-27',
        'support': '2024-07-18'},
    {   'cycle': '2.4',
        'eol': '2023-03-31',
        'latest': '2.4.12',
        'latestReleaseDate': '2022-03-17',
        'lts': False,
        'releaseDate': '2016-12-16',
        'support': '2022-03-17'},
    {   'cycle': '2.3',
        'eol': '2021-06-30',
        'latest': '2.3.18',
        'latestReleaseDate': '2017-09-25',
        'lts': False,
        'releaseDate': '2013-01-02',
        'support': '2017-09-25'},
    {   'cycle': '2.2',
        'eol': '2015-11-30',
        'latest': '2.2.3',
        'latestReleaseDate': '2014-11-30',
        'lts': False,
        'releaseDate': '2011-04-21',
        'support': '2014-11-30'},
    {   'cycle': '2.1',
        'eol': '2011-11-30',
        'latest': '2.1.4',
        'latestReleaseDate': '2010-11-06',
        'lts': False,
        'releaseDate': '2009-12-11',
        'support': '2010-11-06'},
    ],


    'https://endoflife.date/api/php.json': [
    {   'cycle': '8.4',
        'eol': '2028-12-31',
        'latest': '8.4.12',
        'latestReleaseDate': '2025-08-28',
        'lts': False,
        'releaseDate': '2024-11-21',
        'support': '2026-12-31'},
    {   'cycle': '8.3',
        'eol': '2027-12-31',
        'latest': '8.3.25',
        'latestReleaseDate': '2025-08-28',
        'lts': False,
        'releaseDate': '2023-11-23',
        'support': '2025-12-31'},
    {   'cycle': '8.2',
        'eol': '2026-12-31',
        'latest': '8.2.29',
        'latestReleaseDate': '2025-07-03',
        'lts': False,
        'releaseDate': '2022-12-08',
        'support': '2024-12-31'},
    {   'cycle': '8.1',
        'eol': '2025-12-31',
        'latest': '8.1.33',
        'latestReleaseDate': '2025-07-03',
        'lts': False,
        'releaseDate': '2021-11-25',
        'support': '2023-11-25'},
    {   'cycle': '8.0',
        'eol': '2023-11-26',
        'latest': '8.0.30',
        'latestReleaseDate': '2023-08-03',
        'lts': False,
        'releaseDate': '2020-11-26',
        'support': '2022-11-26'},
    {   'cycle': '7.4',
        'eol': '2022-11-28',
        'latest': '7.4.33',
        'latestReleaseDate': '2022-11-03',
        'lts': False,
        'releaseDate': '2019-11-28',
        'support': '2021-11-28'},
    {   'cycle': '7.3',
        'eol': '2021-12-06',
        'latest': '7.3.33',
        'latestReleaseDate': '2021-11-18',
        'lts': False,
        'releaseDate': '2018-12-06',
        'support': '2020-12-06'},
    {   'cycle': '7.2',
        'eol': '2020-11-30',
        'latest': '7.2.34',
        'latestReleaseDate': '2020-10-01',
        'lts': False,
        'releaseDate': '2017-11-30',
        'support': '2019-11-30'},
    {   'cycle': '7.1',
        'eol': '2019-12-01',
        'latest': '7.1.33',
        'latestReleaseDate': '2019-10-24',
        'lts': False,
        'releaseDate': '2016-12-01',
        'support': '2018-12-01'},
    {   'cycle': '7.0',
        'eol': '2019-01-10',
        'latest': '7.0.33',
        'latestReleaseDate': '2019-01-10',
        'lts': False,
        'releaseDate': '2015-12-03',
        'support': '2018-01-04'},
    {   'cycle': '5.6',
        'eol': '2018-12-31',
        'latest': '5.6.40',
        'latestReleaseDate': '2019-01-10',
        'lts': False,
        'releaseDate': '2014-08-28',
        'support': '2017-01-19'},
    {   'cycle': '5.5',
        'eol': '2016-07-21',
        'latest': '5.5.38',
        'latestReleaseDate': '2016-07-21',
        'lts': False,
        'releaseDate': '2013-06-20',
        'support': '2015-07-10'},
    {   'cycle': '5.4',
        'eol': '2015-09-14',
        'latest': '5.4.45',
        'latestReleaseDate': '2015-09-03',
        'lts': False,
        'releaseDate': '2012-03-01',
        'support': '2014-09-14'},
    {   'cycle': '5.3',
        'eol': '2014-08-14',
        'latest': '5.3.29',
        'latestReleaseDate': '2014-08-14',
        'lts': False,
        'releaseDate': '2009-06-30',
        'support': '2011-06-30'},
    {   'cycle': '5.2',
        'eol': '2011-01-06',
        'latest': '5.2.17',
        'latestReleaseDate': '2011-01-06',
        'lts': False,
        'releaseDate': '2006-11-02',
        'support': '2008-11-02'},
    {   'cycle': '5.1',
        'eol': '2006-08-24',
        'latest': '5.1.6',
        'latestReleaseDate': '2006-08-24',
        'lts': False,
        'releaseDate': '2005-11-24',
        'support': '2006-08-24'},
    {   'cycle': '5.0',
        'eol': '2005-09-05',
        'latest': '5.0.5',
        'latestReleaseDate': '2005-09-05',
        'lts': False,
        'releaseDate': '2004-07-13',
        'support': '2005-09-05'},
    ],


    'https://endoflife.date/api/postfix.json': [
    {   'cycle': '3.10',
        'eol': False,
        'latest': '3.10.4',
        'latestReleaseDate': '2025-08-20',
        'link': 'https://www.postfix.org/announcements/postfix-3.10.0.html',
        'lts': False,
        'releaseDate': '2025-02-16'},
    {   'cycle': '3.9',
        'eol': False,
        'latest': '3.9.5',
        'latestReleaseDate': '2025-08-20',
        'link': 'https://www.postfix.org/announcements/postfix-3.9.2.html',
        'lts': False,
        'releaseDate': '2024-03-06'},
    {   'cycle': '3.8',
        'eol': False,
        'latest': '3.8.11',
        'latestReleaseDate': '2025-08-20',
        'link': 'https://www.postfix.org/announcements/postfix-3.9.2.html',
        'lts': False,
        'releaseDate': '2023-04-17'},
    {   'cycle': '3.7',
        'eol': False,
        'latest': '3.7.16',
        'latestReleaseDate': '2025-08-20',
        'link': 'https://www.postfix.org/announcements/postfix-3.9.2.html',
        'lts': False,
        'releaseDate': '2022-02-06'},
    {   'cycle': '3.6',
        'eol': '2025-02-16',
        'latest': '3.6.18',
        'latestReleaseDate': '2025-02-25',
        'link': 'https://www.postfix.org/announcements/postfix-3.9.2.html',
        'lts': False,
        'releaseDate': '2021-04-29'},
    {   'cycle': '3.5',
        'eol': '2024-03-06',
        'latest': '3.5.25',
        'latestReleaseDate': '2024-03-05',
        'link': 'https://www.postfix.org/announcements/postfix-3.8.6.html',
        'lts': False,
        'releaseDate': '2020-03-15'},
    {   'cycle': '3.4',
        'eol': '2023-04-17',
        'latest': '3.4.29',
        'latestReleaseDate': '2023-04-19',
        'link': 'https://www.postfix.org/announcements/postfix-3.7.5.html',
        'lts': False,
        'releaseDate': '2019-02-27'},
    {   'cycle': '3.3',
        'eol': '2022-02-05',
        'latest': '3.3.22',
        'latestReleaseDate': '2022-02-06',
        'link': 'https://www.postfix.org/announcements/postfix-3.6.5.html',
        'lts': False,
        'releaseDate': '2018-02-22'},
    {   'cycle': '3.2',
        'eol': '2021-04-29',
        'latest': '3.2.22',
        'latestReleaseDate': '2021-04-12',
        'link': 'https://www.postfix.org/announcements/postfix-3.5.10.html',
        'lts': False,
        'releaseDate': '2017-02-28'},
    {   'cycle': '3.1',
        'eol': '2020-03-15',
        'latest': '3.1.15',
        'latestReleaseDate': '2020-02-03',
        'link': 'https://www.postfix.org/announcements/postfix-3.4.9.html',
        'lts': False,
        'releaseDate': '2016-02-24'},
    {   'cycle': '3.0',
        'eol': '2019-02-27',
        'latest': '3.0.15',
        'latestReleaseDate': '2019-02-26',
        'link': 'https://www.postfix.org/announcements/postfix-3.3.3.html',
        'lts': False,
        'releaseDate': '2015-02-08'},
    {   'cycle': '2.11',
        'eol': '2018-02-21',
        'latest': '2.11.11',
        'latestReleaseDate': '2018-01-28',
        'link': 'https://www.postfix.org/announcements/postfix-3.2.5.html',
        'lts': False,
        'releaseDate': '2014-01-15'},
    {   'cycle': '2.10',
        'eol': '2017-02-28',
        'latest': '2.10.10',
        'latestReleaseDate': '2016-05-15',
        'link': 'https://www.postfix.org/announcements/postfix-3.1.1.html',
        'lts': False,
        'releaseDate': '2013-02-11'},
    {   'cycle': '2.9',
        'eol': '2016-02-24',
        'latest': '2.9.15',
        'latestReleaseDate': '2015-10-10',
        'link': 'https://www.postfix.org/announcements/postfix-3.0.3.html',
        'lts': False,
        'releaseDate': '2012-02-01'},
    {   'cycle': '2.8',
        'eol': '2015-02-08',
        'latest': '2.8.20',
        'latestReleaseDate': '2015-02-08',
        'link': 'https://www.postfix.org/announcements/postfix-2.11.4.html',
        'lts': False,
        'releaseDate': '2011-01-20'},
    {   'cycle': '2.6',
        'eol': '2013-02-11',
        'latest': '2.6.19',
        'latestReleaseDate': '2013-02-04',
        'link': 'https://www.postfix.org/announcements/postfix-2.9.6.html',
        'lts': False,
        'releaseDate': '2009-05-12'},
    {   'cycle': '2.5',
        'eol': '2012-02-06',
        'latest': '2.5.17',
        'latestReleaseDate': '2012-02-06',
        'link': 'https://www.postfix.org/announcements/postfix-2.7.8.html',
        'lts': False,
        'releaseDate': '2008-01-24'},
    ],


    'https://endoflife.date/api/postgresql.json': [
    {   'cycle': '17',
        'eol': '2029-11-08',
        'latest': '17.6',
        'latestReleaseDate': '2025-08-11',
        'lts': False,
        'releaseDate': '2024-09-26'},
    {   'cycle': '16',
        'eol': '2028-11-09',
        'latest': '16.10',
        'latestReleaseDate': '2025-08-11',
        'lts': False,
        'releaseDate': '2023-09-14'},
    {   'cycle': '15',
        'eol': '2027-11-11',
        'latest': '15.14',
        'latestReleaseDate': '2025-08-11',
        'lts': False,
        'releaseDate': '2022-10-13'},
    {   'cycle': '14',
        'eol': '2026-11-12',
        'latest': '14.19',
        'latestReleaseDate': '2025-08-11',
        'lts': False,
        'releaseDate': '2021-09-30'},
    {   'cycle': '13',
        'eol': '2025-11-13',
        'latest': '13.22',
        'latestReleaseDate': '2025-08-11',
        'lts': False,
        'releaseDate': '2020-09-24'},
    {   'cycle': '12',
        'eol': '2024-11-21',
        'latest': '12.22',
        'latestReleaseDate': '2024-11-18',
        'lts': False,
        'releaseDate': '2019-10-03'},
    {   'cycle': '11',
        'eol': '2023-11-09',
        'latest': '11.22',
        'latestReleaseDate': '2023-11-06',
        'lts': False,
        'releaseDate': '2018-10-18'},
    {   'cycle': '10',
        'eol': '2022-11-10',
        'latest': '10.23',
        'latestReleaseDate': '2022-11-07',
        'lts': False,
        'releaseDate': '2017-10-05'},
    {   'cycle': '9.6',
        'eol': '2021-11-11',
        'latest': '9.6.24',
        'latestReleaseDate': '2021-11-08',
        'lts': False,
        'releaseDate': '2016-09-29'},
    {   'cycle': '9.5',
        'eol': '2021-02-11',
        'latest': '9.5.25',
        'latestReleaseDate': '2021-02-08',
        'lts': False,
        'releaseDate': '2016-01-07'},
    {   'cycle': '9.4',
        'eol': '2020-02-13',
        'latest': '9.4.26',
        'latestReleaseDate': '2020-02-10',
        'lts': False,
        'releaseDate': '2014-12-18'},
    {   'cycle': '9.3',
        'eol': '2018-11-08',
        'latest': '9.3.25',
        'latestReleaseDate': '2018-11-05',
        'lts': False,
        'releaseDate': '2013-09-09'},
    {   'cycle': '9.2',
        'eol': '2017-11-09',
        'latest': '9.2.24',
        'latestReleaseDate': '2017-11-06',
        'lts': False,
        'releaseDate': '2012-09-10'},
    {   'cycle': '9.1',
        'eol': '2016-10-27',
        'latest': '9.1.24',
        'latestReleaseDate': '2016-10-24',
        'lts': False,
        'releaseDate': '2011-09-12'},
    {   'cycle': '9.0',
        'eol': '2015-10-08',
        'latest': '9.0.23',
        'latestReleaseDate': '2015-10-05',
        'lts': False,
        'releaseDate': '2010-09-20'},
    {   'cycle': '8.4',
        'eol': '2014-07-24',
        'latest': '8.4.22',
        'latestReleaseDate': '2014-07-21',
        'lts': False,
        'releaseDate': '2009-07-01'},
    {   'cycle': '8.3',
        'eol': '2013-02-07',
        'latest': '8.3.23',
        'latestReleaseDate': '2013-02-04',
        'lts': False,
        'releaseDate': '2008-02-04'},
    {   'cycle': '8.2',
        'eol': '2011-12-05',
        'latest': '8.2.23',
        'latestReleaseDate': '2011-12-01',
        'lts': False,
        'releaseDate': '2006-12-05'},
    {   'cycle': '8.1',
        'eol': '2010-11-08',
        'latest': '8.1.23',
        'latestReleaseDate': '2010-12-13',
        'lts': False,
        'releaseDate': '2005-11-08'},
    {   'cycle': '8.0',
        'eol': '2010-10-01',
        'latest': '8.0.26',
        'latestReleaseDate': '2010-10-01',
        'lts': False,
        'releaseDate': '2005-01-19'},
    {   'cycle': '7.4',
        'eol': '2010-10-01',
        'latest': '7.4.30',
        'latestReleaseDate': '2010-10-01',
        'lts': False,
        'releaseDate': '2003-11-17'},
    {   'cycle': '7.3',
        'eol': '2007-11-27',
        'latest': '7.3.21',
        'latestReleaseDate': '2008-01-03',
        'lts': False,
        'releaseDate': '2002-11-27'},
    {   'cycle': '7.2',
        'eol': '2007-02-04',
        'latest': '7.2.8',
        'latestReleaseDate': '2005-05-09',
        'lts': False,
        'releaseDate': '2002-02-04'},
    {   'cycle': '7.1',
        'eol': '2006-04-13',
        'latest': '7.1.3',
        'latestReleaseDate': '2001-08-17',
        'lts': False,
        'releaseDate': '2001-04-13'},
    {   'cycle': '7.0',
        'eol': '2005-05-08',
        'latest': '7.0.3',
        'latestReleaseDate': '2000-11-12',
        'lts': False,
        'releaseDate': '2000-05-08'},
    {   'cycle': '6.5',
        'eol': '2004-06-09',
        'latest': '6.5.3',
        'latestReleaseDate': '1999-11-04',
        'lts': False,
        'releaseDate': '1999-06-09'},
    {   'cycle': '6.4',
        'eol': '2003-10-30',
        'latest': '6.4.2',
        'latestReleaseDate': '1999-01-03',
        'lts': False,
        'releaseDate': '1998-10-30'},
    {   'cycle': '6.3',
        'eol': '2003-03-01',
        'latest': '6.3.2',
        'latestReleaseDate': '1998-04-18',
        'lts': False,
        'releaseDate': '1998-03-01'},
    ],


    'https://endoflife.date/api/python.json': [
    {   'cycle': '3.13',
        'eol': '2029-10-31',
        'latest': '3.13.7',
        'latestReleaseDate': '2025-08-14',
        'lts': False,
        'releaseDate': '2024-10-07',
        'support': '2026-10-01'},
    {   'cycle': '3.12',
        'eol': '2028-10-31',
        'latest': '3.12.11',
        'latestReleaseDate': '2025-06-03',
        'lts': False,
        'releaseDate': '2023-10-02',
        'support': '2025-04-02'},
    {   'cycle': '3.11',
        'eol': '2027-10-31',
        'latest': '3.11.13',
        'latestReleaseDate': '2025-06-03',
        'lts': False,
        'releaseDate': '2022-10-24',
        'support': '2024-04-01'},
    {   'cycle': '3.10',
        'eol': '2026-10-31',
        'latest': '3.10.18',
        'latestReleaseDate': '2025-06-03',
        'lts': False,
        'releaseDate': '2021-10-04',
        'support': '2023-04-05'},
    {   'cycle': '3.9',
        'eol': '2025-10-31',
        'latest': '3.9.23',
        'latestReleaseDate': '2025-06-03',
        'lts': False,
        'releaseDate': '2020-10-05',
        'support': '2022-05-17'},
    {   'cycle': '3.8',
        'eol': '2024-10-07',
        'latest': '3.8.20',
        'latestReleaseDate': '2024-09-06',
        'lts': False,
        'releaseDate': '2019-10-14',
        'support': '2021-05-03'},
    {   'cycle': '3.7',
        'eol': '2023-06-27',
        'latest': '3.7.17',
        'latestReleaseDate': '2023-06-05',
        'lts': False,
        'releaseDate': '2018-06-27',
        'support': '2020-06-27'},
    {   'cycle': '3.6',
        'eol': '2021-12-23',
        'latest': '3.6.15',
        'latestReleaseDate': '2021-09-03',
        'lts': False,
        'releaseDate': '2016-12-23',
        'support': '2018-12-24'},
    {   'cycle': '3.5',
        'eol': '2020-09-30',
        'latest': '3.5.10',
        'latestReleaseDate': '2020-09-05',
        'lts': False,
        'releaseDate': '2015-09-13',
        'support': False},
    {   'cycle': '3.4',
        'eol': '2019-03-18',
        'latest': '3.4.10',
        'latestReleaseDate': '2019-03-18',
        'lts': False,
        'releaseDate': '2014-03-16',
        'support': False},
    {   'cycle': '3.3',
        'eol': '2017-09-29',
        'latest': '3.3.7',
        'latestReleaseDate': '2017-09-19',
        'lts': False,
        'releaseDate': '2012-09-29',
        'support': False},
    {   'cycle': '3.2',
        'eol': '2016-02-20',
        'latest': '3.2.6',
        'latestReleaseDate': '2014-10-12',
        'lts': False,
        'releaseDate': '2011-02-20',
        'support': False},
    {   'cycle': '2.7',
        'eol': '2020-01-01',
        'latest': '2.7.18',
        'latestReleaseDate': '2020-04-19',
        'lts': False,
        'releaseDate': '2010-07-03',
        'support': False},
    {   'cycle': '3.1',
        'eol': '2012-04-09',
        'latest': '3.1.5',
        'latestReleaseDate': '2012-04-06',
        'lts': False,
        'releaseDate': '2009-06-27',
        'support': False},
    {   'cycle': '3.0',
        'eol': '2009-06-27',
        'latest': '3.0.1',
        'latestReleaseDate': '2009-02-12',
        'lts': False,
        'releaseDate': '2008-12-03',
        'support': False},
    {   'cycle': '2.6',
        'eol': '2013-10-29',
        'latest': '2.6.9',
        'latestReleaseDate': '2013-10-29',
        'lts': False,
        'releaseDate': '2008-10-01',
        'support': False},
    ],


    'https://endoflife.date/api/redhat-build-of-openjdk.json': [
    {   'cycle': '21',
        'eol': '2029-12-31',
        'latest': '21.0.6.0.7-3',
        'latestReleaseDate': '2025-02-18',
        'lts': False,
        'releaseDate': '2023-11-14'},
    {   'cycle': '17',
        'eol': '2027-10-31',
        'latest': '17.0.14.0.7-3',
        'latestReleaseDate': '2025-01-15',
        'lts': False,
        'releaseDate': '2021-11-11'},
    {   'cycle': '11',
        'eol': '2024-10-31',
        'latest': '11.0.25.0.9-3',
        'latestReleaseDate': '2025-01-14',
        'lts': False,
        'releaseDate': '2018-10-01'},
    {   'cycle': '8',
        'eol': '2026-11-30',
        'latest': '1.8.0.442.b06-2',
        'latestReleaseDate': '2025-01-17',
        'lts': False,
        'releaseDate': '2014-10-01',
        'releaseLabel': 'OpenJDK 8 (1.8)'},
    {   'cycle': '7',
        'eol': '2020-06-30',
        'latest': '1.7.0.261-2.6.22.2',
        'latestReleaseDate': '2020-04-15',
        'link': None,
        'lts': False,
        'releaseDate': '2007-03-15',
        'releaseLabel': 'OpenJDK 7 (1.7)'},
    {   'cycle': '6',
        'eol': '2016-12-31',
        'latest': '1.6.0.41-1.13.13.1',
        'latestReleaseDate': '2017-01-04',
        'link': None,
        'lts': False,
        'releaseDate': '2007-03-15',
        'releaseLabel': 'OpenJDK 6 (1.6)'},
    ],


    'https://endoflife.date/api/redis.json': [
    {   'cycle': '8.2',
        'eol': False,
        'latest': '8.2.1',
        'latestReleaseDate': '2025-08-18',
        'lts': False,
        'releaseDate': '2025-08-04',
        'support': True},
    {   'cycle': '8.0',
        'eol': False,
        'latest': '8.0.3',
        'latestReleaseDate': '2025-07-06',
        'lts': False,
        'releaseDate': '2025-05-02',
        'support': True},
    {   'cycle': '7.4',
        'eol': '2026-11-30',
        'latest': '7.4.5',
        'latestReleaseDate': '2025-07-06',
        'lts': False,
        'releaseDate': '2024-07-29',
        'support': True},
    {   'cycle': '7.2',
        'eol': '2026-02-28',
        'latest': '7.2.10',
        'latestReleaseDate': '2025-07-06',
        'lts': False,
        'releaseDate': '2023-08-15',
        'support': '2024-07-29'},
    {   'cycle': '7.0',
        'eol': '2024-07-29',
        'latest': '7.0.15',
        'latestReleaseDate': '2024-01-09',
        'lts': False,
        'releaseDate': '2022-04-27',
        'support': '2023-08-15'},
    {   'cycle': '6.2',
        'eol': '2025-02-28',
        'latest': '6.2.19',
        'latestReleaseDate': '2025-07-06',
        'lts': False,
        'releaseDate': '2021-02-22',
        'support': '2022-04-27'},
    {   'cycle': '6.0',
        'eol': '2022-05-31',
        'latest': '6.0.20',
        'latestReleaseDate': '2023-07-10',
        'lts': False,
        'releaseDate': '2020-04-30',
        'support': '2021-02-22'},
    {   'cycle': '5.0',
        'eol': '2022-04-27',
        'latest': '5.0.14',
        'latestReleaseDate': '2021-10-04',
        'lts': False,
        'releaseDate': '2018-10-17',
        'support': '2020-04-30'},
    ],


    'https://endoflife.date/api/rhel.json': [
    {   'cycle': '10',
        'eol': '2035-05-31',
        'extendedSupport': '2038-05-31',
        'latest': '10.0',
        'latestReleaseDate': '2025-05-20',
        'lts': '2035-05-31',
        'releaseDate': '2025-05-20',
        'support': '2030-05-31'},
    {   'cycle': '9',
        'eol': '2032-05-31',
        'extendedSupport': '2035-05-31',
        'latest': '9.6',
        'latestReleaseDate': '2025-05-20',
        'lts': '2032-05-31',
        'releaseDate': '2022-05-18',
        'support': '2027-05-31'},
    {   'cycle': '8',
        'eol': '2029-05-31',
        'extendedSupport': '2032-05-31',
        'latest': '8.10',
        'latestReleaseDate': '2024-05-22',
        'lts': '2029-05-31',
        'releaseDate': '2019-05-07',
        'support': '2024-05-31'},
    {   'cycle': '7',
        'eol': '2024-06-30',
        'extendedSupport': '2029-05-31',
        'latest': '7.9',
        'latestReleaseDate': '2020-09-29',
        'lts': '2024-06-30',
        'releaseDate': '2014-06-10',
        'support': '2019-08-06'},
    {   'cycle': '6',
        'eol': '2020-11-30',
        'extendedSupport': '2024-06-30',
        'latest': '6.10',
        'latestReleaseDate': '2018-06-19',
        'lts': '2020-11-30',
        'releaseDate': '2010-11-10',
        'support': '2016-05-10'},
    {   'cycle': '5',
        'eol': '2017-03-31',
        'extendedSupport': '2020-11-30',
        'latest': '5.11',
        'latestReleaseDate': '2014-09-16',
        'lts': '2017-03-31',
        'releaseDate': '2007-03-15',
        'support': '2013-01-08'},
    {   'cycle': '4',
        'eol': '2012-02-29',
        'extendedSupport': '2017-03-31',
        'latest': '4.9',
        'latestReleaseDate': '2011-02-16',
        'lts': False,
        'releaseDate': '2005-02-15',
        'support': '2009-03-31'},
    ],


    'https://endoflife.date/api/rocketchat.json': [
    {   'cycle': '7.10',
        'eol': '2026-06-30',
        'latest': '7.10.0',
        'latestReleaseDate': '2025-09-04',
        'lts': False,
        'releaseDate': '2025-09-04',
        'support': '2025-09-04'},
    {   'cycle': '7.9',
        'eol': '2026-01-31',
        'latest': '7.9.3',
        'latestReleaseDate': '2025-08-11',
        'lts': False,
        'releaseDate': '2025-07-29',
        'support': '2025-07-29'},
    {   'cycle': '7.8',
        'eol': '2026-01-31',
        'latest': '7.8.4',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2025-07-08',
        'support': '2025-07-08'},
    {   'cycle': '7.7',
        'eol': '2025-11-30',
        'latest': '7.7.8',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2025-05-31',
        'support': '2025-05-31'},
    {   'cycle': '7.6',
        'eol': '2025-11-30',
        'latest': '7.6.5',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2025-05-13',
        'support': '2025-05-13'},
    {   'cycle': '7.5',
        'eol': '2025-10-31',
        'latest': '7.5.4',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2025-04-07',
        'support': '2025-04-07'},
    {   'cycle': '7.4',
        'eol': '2025-08-31',
        'latest': '7.4.5',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2025-03-05',
        'support': '2025-03-05'},
    {   'cycle': '7.3',
        'eol': '2025-07-31',
        'latest': '7.3.6',
        'latestReleaseDate': '2025-07-07',
        'lts': False,
        'releaseDate': '2025-01-31',
        'support': '2025-01-31'},
    {   'cycle': '7.2',
        'eol': '2025-07-31',
        'latest': '7.2.6',
        'latestReleaseDate': '2025-06-06',
        'lts': False,
        'releaseDate': '2025-01-07',
        'support': '2025-01-07'},
    {   'cycle': '7.1',
        'eol': '2025-06-30',
        'latest': '7.1.6',
        'latestReleaseDate': '2025-06-06',
        'lts': False,
        'releaseDate': '2024-12-04',
        'support': '2024-12-04'},
    {   'cycle': '7.0',
        'eol': '2025-04-30',
        'latest': '7.0.9',
        'latestReleaseDate': '2025-03-01',
        'lts': False,
        'releaseDate': '2024-10-31',
        'support': '2024-10-31'},
    {   'cycle': '6.13',
        'eol': '2025-04-30',
        'latest': '6.13.1',
        'latestReleaseDate': '2024-12-04',
        'lts': False,
        'releaseDate': '2024-10-10',
        'support': '2024-10-10'},
    {   'cycle': '6.12',
        'eol': '2025-03-31',
        'latest': '6.12.3',
        'latestReleaseDate': '2024-12-04',
        'lts': False,
        'releaseDate': '2024-09-05',
        'support': '2024-09-05'},
    {   'cycle': '6.11',
        'eol': '2025-02-28',
        'latest': '6.11.3',
        'latestReleaseDate': '2024-09-13',
        'lts': False,
        'releaseDate': '2024-08-09',
        'support': '2024-08-09'},
    {   'cycle': '6.10',
        'eol': '2025-01-31',
        'latest': '6.10.10',
        'latestReleaseDate': '2025-01-08',
        'lts': False,
        'releaseDate': '2024-07-10',
        'support': '2024-07-10'},
    {   'cycle': '6.9',
        'eol': '2024-12-31',
        'latest': '6.9.7',
        'latestReleaseDate': '2024-09-13',
        'lts': False,
        'releaseDate': '2024-06-02',
        'support': '2024-06-02'},
    {   'cycle': '6.8',
        'eol': '2024-11-30',
        'latest': '6.8.7',
        'latestReleaseDate': '2024-09-13',
        'lts': False,
        'releaseDate': '2024-05-12',
        'support': '2024-06-12'},
    {   'cycle': '6.7',
        'eol': '2024-10-31',
        'latest': '6.7.9',
        'latestReleaseDate': '2024-09-13',
        'lts': False,
        'releaseDate': '2024-04-08',
        'support': '2024-05-12'},
    {   'cycle': '6.6',
        'eol': '2024-08-31',
        'latest': '6.6.13',
        'latestReleaseDate': '2024-11-22',
        'lts': False,
        'releaseDate': '2024-02-07',
        'support': '2024-04-08'},
    {   'cycle': '6.5',
        'eol': '2024-06-30',
        'latest': '6.5.9',
        'latestReleaseDate': '2024-11-22',
        'lts': False,
        'releaseDate': '2023-12-01',
        'support': '2024-02-07'},
    {   'cycle': '6.4',
        'eol': '2024-03-31',
        'latest': '6.4.9',
        'latestReleaseDate': '2024-01-03',
        'lts': False,
        'releaseDate': '2023-09-27',
        'support': '2023-12-01'},
    {   'cycle': '6.3',
        'eol': '2024-02-29',
        'latest': '6.3.13',
        'latestReleaseDate': '2024-11-23',
        'lts': False,
        'releaseDate': '2023-08-02',
        'support': '2023-09-27'},
    {   'cycle': '6.2',
        'eol': '2023-11-30',
        'latest': '6.2.12',
        'latestReleaseDate': '2023-08-11',
        'lts': False,
        'releaseDate': '2023-05-15',
        'support': '2023-08-02'},
    {   'cycle': '6.1',
        'eol': '2023-09-30',
        'latest': '6.1.8',
        'latestReleaseDate': '2023-05-17',
        'lts': False,
        'releaseDate': '2023-03-29',
        'support': '2023-05-15'},
    {   'cycle': '6.0',
        'eol': '2023-09-30',
        'latest': '6.0.8',
        'latestReleaseDate': '2023-05-17',
        'lts': False,
        'releaseDate': '2023-03-09',
        'support': '2023-03-29'},
    {   'cycle': '5.4',
        'eol': '2023-06-30',
        'latest': '5.4.10',
        'latestReleaseDate': '2023-05-17',
        'lts': True,
        'releaseDate': '2022-12-05',
        'support': '2023-03-09'},
    {   'cycle': '5.3',
        'eol': '2023-05-31',
        'latest': '5.3.7',
        'latestReleaseDate': '2023-04-17',
        'lts': False,
        'releaseDate': '2022-11-01',
        'support': '2022-12-05'},
    {   'cycle': '5.2',
        'eol': '2023-04-30',
        'latest': '5.2.2',
        'latestReleaseDate': '2023-01-24',
        'lts': False,
        'releaseDate': '2022-10-13',
        'support': '2022-11-01'},
    {   'cycle': '5.1',
        'eol': '2023-03-31',
        'latest': '5.1.5',
        'latestReleaseDate': '2022-11-24',
        'lts': False,
        'releaseDate': '2022-09-02',
        'support': '2022-10-13'},
    {   'cycle': '5.0',
        'eol': '2023-01-31',
        'latest': '5.0.8',
        'latestReleaseDate': '2022-11-24',
        'lts': False,
        'releaseDate': '2022-07-21',
        'support': '2022-09-02'},
    {   'cycle': '4.8',
        'eol': '2022-12-31',
        'latest': '4.8.7',
        'latestReleaseDate': '2022-11-24',
        'lts': True,
        'releaseDate': '2022-05-31',
        'support': '2022-07-21'},
    {   'cycle': '4.7',
        'eol': '2022-11-30',
        'latest': '4.7.5',
        'latestReleaseDate': '2022-07-20',
        'lts': False,
        'releaseDate': '2022-05-04',
        'support': '2022-05-31'},
    {   'cycle': '4.6',
        'eol': '2022-10-31',
        'latest': '4.6.4',
        'latestReleaseDate': '2022-06-02',
        'lts': False,
        'releaseDate': '2022-04-01',
        'support': '2022-05-04'},
    {   'cycle': '4.5',
        'eol': '2022-09-30',
        'latest': '4.5.7',
        'latestReleaseDate': '2022-06-02',
        'lts': False,
        'releaseDate': '2022-02-28',
        'support': '2022-04-01'},
    {   'cycle': '4.4',
        'eol': '2022-07-31',
        'latest': '4.4.5',
        'latestReleaseDate': '2022-05-30',
        'lts': False,
        'releaseDate': '2022-01-28',
        'support': '2022-02-28'},
    {   'cycle': '4.3',
        'eol': '2022-06-30',
        'latest': '4.3.3',
        'latestReleaseDate': '2022-01-28',
        'lts': False,
        'releaseDate': '2021-12-28',
        'support': '2022-01-28'},
    {   'cycle': '4.2',
        'eol': '2022-05-31',
        'latest': '4.2.4',
        'latestReleaseDate': '2022-01-28',
        'lts': False,
        'releaseDate': '2021-11-30',
        'support': '2021-12-28'},
    {   'cycle': '4.1',
        'eol': '2022-04-30',
        'latest': '4.1.6',
        'latestReleaseDate': '2022-06-02',
        'lts': False,
        'releaseDate': '2021-10-28',
        'support': '2021-11-30'},
    {   'cycle': '4.0',
        'eol': '2022-04-30',
        'latest': '4.0.6',
        'latestReleaseDate': '2021-11-05',
        'lts': False,
        'releaseDate': '2021-10-01',
        'support': '2021-10-28'},
    {   'cycle': '3.18',
        'eol': '2022-02-28',
        'latest': '3.18.7',
        'latestReleaseDate': '2022-05-30',
        'lts': True,
        'releaseDate': '2021-08-31',
        'support': '2021-10-01'},
    {   'cycle': '3.17',
        'eol': '2022-01-31',
        'latest': '3.17.3',
        'latestReleaseDate': '2021-10-01',
        'lts': False,
        'releaseDate': '2021-07-30',
        'support': '2021-08-31'},
    {   'cycle': '3.16',
        'eol': '2021-12-31',
        'latest': '3.16.5',
        'latestReleaseDate': '2021-10-01',
        'lts': False,
        'releaseDate': '2021-06-28',
        'support': '2021-07-30'},
    {   'cycle': '3.15',
        'eol': '2021-11-30',
        'latest': '3.15.4',
        'latestReleaseDate': '2021-07-13',
        'lts': False,
        'releaseDate': '2021-05-28',
        'support': '2021-06-28'},
    {   'cycle': '3.14',
        'eol': '2021-10-31',
        'latest': '3.14.6',
        'latestReleaseDate': '2021-07-13',
        'lts': False,
        'releaseDate': '2021-04-28',
        'support': '2021-05-28'},
    {   'cycle': '3.13',
        'eol': '2021-10-31',
        'latest': '3.13.5',
        'latestReleaseDate': '2021-05-27',
        'lts': False,
        'releaseDate': '2021-04-04',
        'support': '2021-04-28'},
    {   'cycle': '3.12',
        'eol': '2021-08-31',
        'latest': '3.12.7',
        'latestReleaseDate': '2021-05-27',
        'lts': False,
        'releaseDate': '2021-02-28',
        'support': '2021-04-04'},
    {   'cycle': '3.11',
        'eol': '2021-08-31',
        'latest': '3.11.6',
        'latestReleaseDate': '2022-08-22',
        'lts': False,
        'releaseDate': '2021-01-31',
        'support': '2021-02-28'},
    {   'cycle': '3.10',
        'eol': '2021-06-30',
        'latest': '3.10.7',
        'latestReleaseDate': '2021-03-26',
        'lts': False,
        'releaseDate': '2020-12-29',
        'support': '2021-01-31'},
    {   'cycle': '3.9',
        'eol': '2021-05-31',
        'latest': '3.9.7',
        'latestReleaseDate': '2021-01-27',
        'lts': False,
        'releaseDate': '2020-11-28',
        'support': '2020-12-29'},
    {   'cycle': '3.8',
        'eol': '2021-05-31',
        'latest': '3.8.9',
        'latestReleaseDate': '2021-03-26',
        'lts': False,
        'releaseDate': '2020-11-14',
        'support': '2020-11-28'},
    {   'cycle': '3.7',
        'eol': '2021-03-31',
        'latest': '3.7.4',
        'latestReleaseDate': '2020-12-18',
        'lts': False,
        'releaseDate': '2020-09-28',
        'support': '2020-11-14'},
    {   'cycle': '3.6',
        'eol': '2021-02-28',
        'latest': '3.6.3',
        'latestReleaseDate': '2020-09-25',
        'lts': False,
        'releaseDate': '2020-08-29',
        'support': '2020-09-28'},
    {   'cycle': '3.5',
        'eol': '2021-01-31',
        'latest': '3.5.4',
        'latestReleaseDate': '2020-08-24',
        'lts': False,
        'releaseDate': '2020-07-27',
        'support': '2020-08-29'},
    {   'cycle': '3.4',
        'eol': '2020-12-31',
        'latest': '3.4.3',
        'latestReleaseDate': '2020-07-31',
        'lts': False,
        'releaseDate': '2020-06-30',
        'support': '2020-07-27'},
    {   'cycle': '3.3',
        'eol': '2020-11-30',
        'latest': '3.3.3',
        'latestReleaseDate': '2020-06-11',
        'lts': False,
        'releaseDate': '2020-05-27',
        'support': '2020-06-30'},
    {   'cycle': '3.2',
        'eol': '2020-10-31',
        'latest': '3.2.2',
        'latestReleaseDate': '2020-05-11',
        'lts': False,
        'releaseDate': '2020-04-27',
        'support': '2020-05-27'},
    {   'cycle': '3.1',
        'eol': '2020-10-31',
        'latest': '3.1.3',
        'latestReleaseDate': '2020-05-11',
        'lts': False,
        'releaseDate': '2020-04-09',
        'support': '2020-04-27'},
    {   'cycle': '3.0',
        'eol': '2020-08-31',
        'latest': '3.0.13',
        'latestReleaseDate': '2020-05-11',
        'lts': False,
        'releaseDate': '2020-02-14',
        'support': '2020-04-09'},
    {   'cycle': '2.4',
        'eol': '2020-06-30',
        'latest': '2.4.14',
        'latestReleaseDate': '2020-12-18',
        'lts': True,
        'releaseDate': '2019-12-27',
        'support': '2020-02-14'},
    {   'cycle': '2.3',
        'eol': '2020-05-31',
        'latest': '2.3.3',
        'latestReleaseDate': '2020-01-10',
        'lts': False,
        'releaseDate': '2019-11-27',
        'support': '2019-12-27'},
    {   'cycle': '2.2',
        'eol': '2020-04-30',
        'latest': '2.2.1',
        'latestReleaseDate': '2019-11-19',
        'lts': False,
        'releaseDate': '2019-10-27',
        'support': '2019-11-27'},
    {   'cycle': '2.1',
        'eol': '2020-03-31',
        'latest': '2.1.3',
        'latestReleaseDate': '2019-11-19',
        'lts': False,
        'releaseDate': '2019-09-27',
        'support': '2019-10-27'},
    {   'cycle': '2.0',
        'eol': '2020-03-31',
        'latest': '2.0.1',
        'latestReleaseDate': '2019-11-19',
        'lts': False,
        'releaseDate': '2019-09-12',
        'support': '2019-09-27'},
    {   'cycle': '1.3',
        'eol': '2020-02-29',
        'latest': '1.3.5',
        'latestReleaseDate': '2020-12-18',
        'lts': True,
        'releaseDate': '2019-08-02',
        'support': '2019-09-12'},
    {   'cycle': '1.2',
        'eol': '2019-12-31',
        'latest': '1.2.4',
        'latestReleaseDate': '2019-08-08',
        'lts': False,
        'releaseDate': '2019-06-27',
        'support': '2019-08-02'},
    {   'cycle': '1.1',
        'eol': '2019-11-30',
        'latest': '1.1.5',
        'latestReleaseDate': '2019-08-08',
        'lts': False,
        'releaseDate': '2019-05-27',
        'support': '2019-06-27'},
    {   'cycle': '1.0',
        'eol': '2019-10-31',
        'latest': '1.0.5',
        'latestReleaseDate': '2019-08-08',
        'lts': False,
        'releaseDate': '2019-04-28',
        'support': '2019-05-27'},
    ],


    'https://endoflife.date/api/solr.json': [
    {   'cycle': '9',
        'eol': False,
        'latest': '9.9.0',
        'latestReleaseDate': '2025-07-24',
        'lts': False,
        'releaseDate': '2022-05-11'},
    {   'cycle': '8',
        'eol': '2024-10-25',
        'latest': '8.11.4',
        'latestReleaseDate': '2024-09-24',
        'lts': False,
        'releaseDate': '2019-03-13'},
    {   'cycle': '7',
        'eol': '2022-05-11',
        'latest': '7.7.3',
        'latestReleaseDate': '2020-04-24',
        'lts': False,
        'releaseDate': '2017-09-18'},
    {   'cycle': '6',
        'eol': '2019-03-13',
        'latest': '6.6.6',
        'latestReleaseDate': '2019-04-01',
        'lts': False,
        'releaseDate': '2016-04-07'},
    {   'cycle': '5',
        'eol': '2017-10-24',
        'latest': '5.5.5',
        'latestReleaseDate': '2017-10-23',
        'lts': False,
        'releaseDate': '2015-02-19'},
    {   'cycle': '4',
        'eol': True,
        'latest': '4.10.4',
        'latestReleaseDate': '2015-03-03',
        'lts': False,
        'releaseDate': '2012-10-11'},
    {   'cycle': '3',
        'eol': True,
        'latest': '3.6.2',
        'latestReleaseDate': '2012-12-24',
        'link': 'https://cwiki.apache.org/confluence/display/solr/ReleaseNote362',
        'lts': False,
        'releaseDate': '2011-03-30'},
    {   'cycle': '1',
        'eol': True,
        'latest': '1.4.1',
        'latestReleaseDate': '2010-06-25',
        'link': 'https://svn.apache.org/repos/asf/lucene/solr/tags/release-1.4.1/CHANGES.txt',
        'lts': False,
        'releaseDate': '2006-12-22'},
    ],


    'https://endoflife.date/api/valkey.json': [
    {   'cycle': '8.1',
        'eol': False,
        'latest': '8.1.3',
        'latestReleaseDate': '2025-07-07',
        'lts': False,
        'releaseDate': '2025-03-31',
        'support': True},
    {   'cycle': '8.0',
        'eol': False,
        'latest': '8.0.5',
        'latestReleaseDate': '2025-08-22',
        'lts': False,
        'releaseDate': '2024-09-15',
        'support': '2027-09-15'},
    {   'cycle': '7.2',
        'eol': '2029-04-16',
        'latest': '7.2.10',
        'latestReleaseDate': '2025-07-07',
        'lts': False,
        'releaseDate': '2023-08-15',
        'support': '2027-04-16'},
    ],


    'https://endoflife.date/api/wordpress.json': [
    {   'cycle': '6.8',
        'eol': False,
        'latest': '6.8.2',
        'latestReleaseDate': '2025-07-15',
        'lts': False,
        'releaseDate': '2025-04-15',
        'supportedPHPVersions': '7.2 - 8.4'},
    {   'cycle': '6.7',
        'eol': '2025-04-15',
        'latest': '6.7.3',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2024-11-12',
        'supportedPHPVersions': '7.2 - 8.4'},
    {   'cycle': '6.6',
        'eol': '2024-11-12',
        'latest': '6.6.3',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2024-07-16',
        'supportedPHPVersions': '7.2 - 8.3'},
    {   'cycle': '6.5',
        'eol': '2024-07-16',
        'latest': '6.5.6',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2024-04-02',
        'supportedPHPVersions': '7.0 - 8.3'},
    {   'cycle': '6.4',
        'eol': '2024-04-02',
        'latest': '6.4.6',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2023-11-07',
        'supportedPHPVersions': '7.0 - 8.3'},
    {   'cycle': '6.3',
        'eol': '2023-11-07',
        'latest': '6.3.6',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2023-08-08',
        'supportedPHPVersions': '7.0 - 8.2'},
    {   'cycle': '6.2',
        'eol': '2023-08-08',
        'latest': '6.2.7',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2023-03-29',
        'supportedPHPVersions': '5.6 - 8.2'},
    {   'cycle': '6.1',
        'eol': '2023-03-29',
        'latest': '6.1.8',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2022-11-02',
        'supportedPHPVersions': '5.6 - 8.2'},
    {   'cycle': '6.0',
        'eol': '2022-11-01',
        'latest': '6.0.10',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2022-05-24',
        'supportedPHPVersions': '5.6 - 8.1'},
    {   'cycle': '5.9',
        'eol': '2022-05-24',
        'latest': '5.9.11',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2022-01-25',
        'supportedPHPVersions': '5.6 - 8.1'},
    {   'cycle': '5.8',
        'eol': '2022-01-25',
        'latest': '5.8.11',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2021-07-20',
        'supportedPHPVersions': '5.6 - 8.0'},
    {   'cycle': '5.7',
        'eol': '2021-07-20',
        'latest': '5.7.13',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2021-03-09',
        'supportedPHPVersions': '5.6 - 8.0'},
    {   'cycle': '5.6',
        'eol': '2021-03-09',
        'latest': '5.6.15',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2020-12-08',
        'supportedPHPVersions': '5.6 - 8.0'},
    {   'cycle': '5.5',
        'eol': '2020-12-08',
        'latest': '5.5.16',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2020-08-11',
        'supportedPHPVersions': '5.6 - 7.4'},
    {   'cycle': '5.4',
        'eol': '2020-08-11',
        'latest': '5.4.17',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2020-03-31',
        'supportedPHPVersions': '5.6 - 7.4'},
    {   'cycle': '5.3',
        'eol': '2020-03-31',
        'latest': '5.3.19',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2019-11-12',
        'supportedPHPVersions': '5.6 - 7.4'},
    {   'cycle': '5.2',
        'eol': '2019-11-12',
        'latest': '5.2.22',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2019-05-07',
        'supportedPHPVersions': '5.6 - 7.3'},
    {   'cycle': '5.1',
        'eol': '2019-05-07',
        'latest': '5.1.20',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2019-02-21',
        'supportedPHPVersions': '5.2 - 7.3'},
    {   'cycle': '5.0',
        'eol': '2019-02-21',
        'latest': '5.0.23',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2018-12-06',
        'supportedPHPVersions': '5.2 - 7.3'},
    {   'cycle': '4.9',
        'eol': '2018-12-06',
        'latest': '4.9.27',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2017-11-16',
        'supportedPHPVersions': '5.2 - 7.2'},
    {   'cycle': '4.8',
        'eol': '2017-11-16',
        'latest': '4.8.26',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2017-06-08',
        'supportedPHPVersions': '5.2 - 7.1'},
    {   'cycle': '4.7',
        'eol': '2017-06-08',
        'latest': '4.7.30',
        'latestReleaseDate': '2025-08-05',
        'lts': False,
        'releaseDate': '2016-12-06',
        'supportedPHPVersions': '5.2 - 7.1'},
    {   'cycle': '4.6',
        'eol': '2016-12-06',
        'latest': '4.6.30',
        'latestReleaseDate': '2025-07-15',
        'link': 'https://wordpress.org/news/2025/07/wordpress-6-8-2-maintenance-release/',
        'lts': False,
        'releaseDate': '2016-08-16',
        'supportedPHPVersions': '5.2 - 7.0'},
    {   'cycle': '4.5',
        'eol': '2016-08-16',
        'latest': '4.5.33',
        'latestReleaseDate': '2025-07-15',
        'lts': False,
        'releaseDate': '2016-04-12',
        'supportedPHPVersions': '5.2 - 7.0'},
    {   'cycle': '4.4',
        'eol': '2016-04-12',
        'latest': '4.4.34',
        'latestReleaseDate': '2025-07-15',
        'lts': False,
        'releaseDate': '2015-12-09',
        'supportedPHPVersions': '5.2 - 7.0'},
    {   'cycle': '4.3',
        'eol': '2015-12-08',
        'latest': '4.3.35',
        'latestReleaseDate': '2025-07-15',
        'lts': False,
        'releaseDate': '2015-08-18',
        'supportedPHPVersions': '5.2 - 5.6'},
    {   'cycle': '4.2',
        'eol': '2015-08-18',
        'latest': '4.2.39',
        'latestReleaseDate': '2025-07-15',
        'lts': False,
        'releaseDate': '2015-04-23',
        'supportedPHPVersions': '5.2 - 5.6'},
    {   'cycle': '4.1',
        'eol': '2015-04-23',
        'latest': '4.1.42',
        'latestReleaseDate': '2025-07-15',
        'lts': False,
        'releaseDate': '2014-12-18',
        'supportedPHPVersions': '5.2 - 5.6'},
    {   'cycle': '4.0',
        'eol': '2014-12-18',
        'latest': '4.0.38',
        'latestReleaseDate': '2022-11-30',
        'lts': False,
        'releaseDate': '2014-09-04',
        'supportedPHPVersions': '5.2 - 5.5'},
    {   'cycle': '3.9',
        'eol': '2014-09-04',
        'latest': '3.9.40',
        'latestReleaseDate': '2022-11-30',
        'lts': False,
        'releaseDate': '2014-04-16',
        'supportedPHPVersions': '5.2 - 5.5'},
    {   'cycle': '3.8',
        'eol': '2014-04-16',
        'latest': '3.8.41',
        'latestReleaseDate': '2022-11-30',
        'lts': False,
        'releaseDate': '2013-12-12',
        'supportedPHPVersions': '5.2 - 5.5'},
    {   'cycle': '3.7',
        'eol': '2013-12-12',
        'latest': '3.7.41',
        'latestReleaseDate': '2022-11-30',
        'lts': False,
        'releaseDate': '2013-10-24',
        'supportedPHPVersions': '5.2 - 5.5'},
    {   'cycle': '3.6',
        'eol': '2013-10-24',
        'latest': '3.6.1',
        'latestReleaseDate': '2013-09-11',
        'lts': False,
        'releaseDate': '2013-08-01'},
    ],


}
