"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from enum import Enum
from openrouter import errors, models, utils
from openrouter._hooks import HookContext
from openrouter.types import OptionalNullable, UNSET
from openrouter.utils import eventstreaming, get_security_from_env
from openrouter.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Dict, List, Literal, Mapping, Optional, Union, overload


class SendAcceptEnum(str, Enum):
    APPLICATION_JSON = "application/json"
    TEXT_EVENT_STREAM = "text/event-stream"


class Chat(BaseSDK):
    @overload
    def send(
        self,
        *,
        messages: Union[List[models.Message], List[models.MessageTypedDict]],
        model: Optional[str] = None,
        models: Optional[List[str]] = None,
        frequency_penalty: OptionalNullable[float] = UNSET,
        logit_bias: OptionalNullable[Dict[str, float]] = UNSET,
        logprobs: OptionalNullable[bool] = UNSET,
        top_logprobs: OptionalNullable[float] = UNSET,
        max_completion_tokens: OptionalNullable[float] = UNSET,
        max_tokens: OptionalNullable[float] = UNSET,
        metadata: Optional[Dict[str, str]] = None,
        presence_penalty: OptionalNullable[float] = UNSET,
        reasoning: Optional[Union[models.Reasoning, models.ReasoningTypedDict]] = None,
        response_format: Optional[
            Union[
                models.ChatGenerationParamsResponseFormatUnion,
                models.ChatGenerationParamsResponseFormatUnionTypedDict,
            ]
        ] = None,
        seed: OptionalNullable[int] = UNSET,
        stop: OptionalNullable[
            Union[
                models.ChatGenerationParamsStop,
                models.ChatGenerationParamsStopTypedDict,
            ]
        ] = UNSET,
        stream: Union[Literal[False], None] = None,
        stream_options: OptionalNullable[
            Union[models.ChatStreamOptions, models.ChatStreamOptionsTypedDict]
        ] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        tool_choice: Optional[Any] = None,
        tools: Optional[
            Union[
                List[models.ToolDefinitionJSON],
                List[models.ToolDefinitionJSONTypedDict],
            ]
        ] = None,
        top_p: OptionalNullable[float] = UNSET,
        user: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ChatResponse:
        r"""Create a chat completion

        Sends a request for a model response for the given chat conversation. Supports both streaming and non-streaming modes.

        :param messages:
        :param model:
        :param models:
        :param frequency_penalty:
        :param logit_bias:
        :param logprobs:
        :param top_logprobs:
        :param max_completion_tokens:
        :param max_tokens:
        :param metadata:
        :param presence_penalty:
        :param reasoning:
        :param response_format:
        :param seed:
        :param stop:
        :param stream:
        :param stream_options:
        :param temperature:
        :param tool_choice:
        :param tools:
        :param top_p:
        :param user:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """

    @overload
    def send(
        self,
        *,
        messages: Union[List[models.Message], List[models.MessageTypedDict]],
        model: Optional[str] = None,
        models: Optional[List[str]] = None,
        frequency_penalty: OptionalNullable[float] = UNSET,
        logit_bias: OptionalNullable[Dict[str, float]] = UNSET,
        logprobs: OptionalNullable[bool] = UNSET,
        top_logprobs: OptionalNullable[float] = UNSET,
        max_completion_tokens: OptionalNullable[float] = UNSET,
        max_tokens: OptionalNullable[float] = UNSET,
        metadata: Optional[Dict[str, str]] = None,
        presence_penalty: OptionalNullable[float] = UNSET,
        reasoning: Optional[Union[models.Reasoning, models.ReasoningTypedDict]] = None,
        response_format: Optional[
            Union[
                models.ChatGenerationParamsResponseFormatUnion,
                models.ChatGenerationParamsResponseFormatUnionTypedDict,
            ]
        ] = None,
        seed: OptionalNullable[int] = UNSET,
        stop: OptionalNullable[
            Union[
                models.ChatGenerationParamsStop,
                models.ChatGenerationParamsStopTypedDict,
            ]
        ] = UNSET,
        stream: Literal[True],
        stream_options: OptionalNullable[
            Union[models.ChatStreamOptions, models.ChatStreamOptionsTypedDict]
        ] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        tool_choice: Optional[Any] = None,
        tools: Optional[
            Union[
                List[models.ToolDefinitionJSON],
                List[models.ToolDefinitionJSONTypedDict],
            ]
        ] = None,
        top_p: OptionalNullable[float] = UNSET,
        user: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> eventstreaming.EventStream[models.ChatStreamingResponseChunkData]:
        r"""Create a chat completion

        Sends a request for a model response for the given chat conversation. Supports both streaming and non-streaming modes.

        :param messages:
        :param model:
        :param models:
        :param frequency_penalty:
        :param logit_bias:
        :param logprobs:
        :param top_logprobs:
        :param max_completion_tokens:
        :param max_tokens:
        :param metadata:
        :param presence_penalty:
        :param reasoning:
        :param response_format:
        :param seed:
        :param stop:
        :param stream:
        :param stream_options:
        :param temperature:
        :param tool_choice:
        :param tools:
        :param top_p:
        :param user:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """

    def send(
        self,
        *,
        messages: Union[List[models.Message], List[models.MessageTypedDict]],
        model: Optional[str] = None,
        models: Optional[List[str]] = None,
        frequency_penalty: OptionalNullable[float] = UNSET,
        logit_bias: OptionalNullable[Dict[str, float]] = UNSET,
        logprobs: OptionalNullable[bool] = UNSET,
        top_logprobs: OptionalNullable[float] = UNSET,
        max_completion_tokens: OptionalNullable[float] = UNSET,
        max_tokens: OptionalNullable[float] = UNSET,
        metadata: Optional[Dict[str, str]] = None,
        presence_penalty: OptionalNullable[float] = UNSET,
        reasoning: Optional[Union[models.Reasoning, models.ReasoningTypedDict]] = None,
        response_format: Optional[
            Union[
                models.ChatGenerationParamsResponseFormatUnion,
                models.ChatGenerationParamsResponseFormatUnionTypedDict,
            ]
        ] = None,
        seed: OptionalNullable[int] = UNSET,
        stop: OptionalNullable[
            Union[
                models.ChatGenerationParamsStop,
                models.ChatGenerationParamsStopTypedDict,
            ]
        ] = UNSET,
        stream: Optional[bool] = False,
        stream_options: OptionalNullable[
            Union[models.ChatStreamOptions, models.ChatStreamOptionsTypedDict]
        ] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        tool_choice: Optional[Any] = None,
        tools: Optional[
            Union[
                List[models.ToolDefinitionJSON],
                List[models.ToolDefinitionJSONTypedDict],
            ]
        ] = None,
        top_p: OptionalNullable[float] = UNSET,
        user: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SendChatCompletionRequestResponse:
        r"""Create a chat completion

        Sends a request for a model response for the given chat conversation. Supports both streaming and non-streaming modes.

        :param messages:
        :param model:
        :param models:
        :param frequency_penalty:
        :param logit_bias:
        :param logprobs:
        :param top_logprobs:
        :param max_completion_tokens:
        :param max_tokens:
        :param metadata:
        :param presence_penalty:
        :param reasoning:
        :param response_format:
        :param seed:
        :param stop:
        :param stream:
        :param stream_options:
        :param temperature:
        :param tool_choice:
        :param tools:
        :param top_p:
        :param user:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ChatGenerationParams(
            messages=utils.get_pydantic_model(messages, List[models.Message]),
            model=model,
            models=models,
            frequency_penalty=frequency_penalty,
            logit_bias=logit_bias,
            logprobs=logprobs,
            top_logprobs=top_logprobs,
            max_completion_tokens=max_completion_tokens,
            max_tokens=max_tokens,
            metadata=metadata,
            presence_penalty=presence_penalty,
            reasoning=utils.get_pydantic_model(reasoning, Optional[models.Reasoning]),
            response_format=utils.get_pydantic_model(
                response_format,
                Optional[models.ChatGenerationParamsResponseFormatUnion],
            ),
            seed=seed,
            stop=stop,
            stream=stream,
            stream_options=utils.get_pydantic_model(
                stream_options, OptionalNullable[models.ChatStreamOptions]
            ),
            temperature=temperature,
            tool_choice=tool_choice,
            tools=utils.get_pydantic_model(
                tools, Optional[List[models.ToolDefinitionJSON]]
            ),
            top_p=top_p,
            user=user,
        )

        req = self._build_request(
            method="POST",
            path="/chat/completions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="text/event-stream" if stream else "application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.ChatGenerationParams
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="sendChatCompletionRequest",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "429", "4XX", "500", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            return unmarshal_json_response(models.ChatResponse, http_res, http_res_text)
        if utils.match_response(http_res, "200", "text/event-stream"):
            return eventstreaming.EventStream(
                http_res,
                lambda raw: utils.unmarshal_json(
                    raw, models.ChatStreamingResponseChunk
                ).data,
                sentinel="[DONE]",
                client_ref=self,
            )
        if utils.match_response(http_res, ["400", "401", "429"], "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            response_data = unmarshal_json_response(
                errors.ChatErrorData, http_res, http_res_text
            )
            raise errors.ChatError(response_data, http_res, http_res_text)
        if utils.match_response(http_res, "500", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            response_data = unmarshal_json_response(
                errors.ChatErrorData, http_res, http_res_text
            )
            raise errors.ChatError(response_data, http_res, http_res_text)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.OpenRouterDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.OpenRouterDefaultError(
                "API error occurred", http_res, http_res_text
            )

        http_res_text = utils.stream_to_text(http_res)
        raise errors.OpenRouterDefaultError(
            "Unexpected response received", http_res, http_res_text
        )

    @overload
    async def send_async(
        self,
        *,
        messages: Union[List[models.Message], List[models.MessageTypedDict]],
        model: Optional[str] = None,
        models: Optional[List[str]] = None,
        frequency_penalty: OptionalNullable[float] = UNSET,
        logit_bias: OptionalNullable[Dict[str, float]] = UNSET,
        logprobs: OptionalNullable[bool] = UNSET,
        top_logprobs: OptionalNullable[float] = UNSET,
        max_completion_tokens: OptionalNullable[float] = UNSET,
        max_tokens: OptionalNullable[float] = UNSET,
        metadata: Optional[Dict[str, str]] = None,
        presence_penalty: OptionalNullable[float] = UNSET,
        reasoning: Optional[Union[models.Reasoning, models.ReasoningTypedDict]] = None,
        response_format: Optional[
            Union[
                models.ChatGenerationParamsResponseFormatUnion,
                models.ChatGenerationParamsResponseFormatUnionTypedDict,
            ]
        ] = None,
        seed: OptionalNullable[int] = UNSET,
        stop: OptionalNullable[
            Union[
                models.ChatGenerationParamsStop,
                models.ChatGenerationParamsStopTypedDict,
            ]
        ] = UNSET,
        stream: Union[Literal[False], None] = None,
        stream_options: OptionalNullable[
            Union[models.ChatStreamOptions, models.ChatStreamOptionsTypedDict]
        ] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        tool_choice: Optional[Any] = None,
        tools: Optional[
            Union[
                List[models.ToolDefinitionJSON],
                List[models.ToolDefinitionJSONTypedDict],
            ]
        ] = None,
        top_p: OptionalNullable[float] = UNSET,
        user: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ChatResponse:
        r"""Create a chat completion

        Sends a request for a model response for the given chat conversation. Supports both streaming and non-streaming modes.

        :param messages:
        :param model:
        :param models:
        :param frequency_penalty:
        :param logit_bias:
        :param logprobs:
        :param top_logprobs:
        :param max_completion_tokens:
        :param max_tokens:
        :param metadata:
        :param presence_penalty:
        :param reasoning:
        :param response_format:
        :param seed:
        :param stop:
        :param stream:
        :param stream_options:
        :param temperature:
        :param tool_choice:
        :param tools:
        :param top_p:
        :param user:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """

    @overload
    async def send_async(
        self,
        *,
        messages: Union[List[models.Message], List[models.MessageTypedDict]],
        model: Optional[str] = None,
        models: Optional[List[str]] = None,
        frequency_penalty: OptionalNullable[float] = UNSET,
        logit_bias: OptionalNullable[Dict[str, float]] = UNSET,
        logprobs: OptionalNullable[bool] = UNSET,
        top_logprobs: OptionalNullable[float] = UNSET,
        max_completion_tokens: OptionalNullable[float] = UNSET,
        max_tokens: OptionalNullable[float] = UNSET,
        metadata: Optional[Dict[str, str]] = None,
        presence_penalty: OptionalNullable[float] = UNSET,
        reasoning: Optional[Union[models.Reasoning, models.ReasoningTypedDict]] = None,
        response_format: Optional[
            Union[
                models.ChatGenerationParamsResponseFormatUnion,
                models.ChatGenerationParamsResponseFormatUnionTypedDict,
            ]
        ] = None,
        seed: OptionalNullable[int] = UNSET,
        stop: OptionalNullable[
            Union[
                models.ChatGenerationParamsStop,
                models.ChatGenerationParamsStopTypedDict,
            ]
        ] = UNSET,
        stream: Literal[True],
        stream_options: OptionalNullable[
            Union[models.ChatStreamOptions, models.ChatStreamOptionsTypedDict]
        ] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        tool_choice: Optional[Any] = None,
        tools: Optional[
            Union[
                List[models.ToolDefinitionJSON],
                List[models.ToolDefinitionJSONTypedDict],
            ]
        ] = None,
        top_p: OptionalNullable[float] = UNSET,
        user: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> eventstreaming.EventStreamAsync[models.ChatStreamingResponseChunkData]:
        r"""Create a chat completion

        Sends a request for a model response for the given chat conversation. Supports both streaming and non-streaming modes.

        :param messages:
        :param model:
        :param models:
        :param frequency_penalty:
        :param logit_bias:
        :param logprobs:
        :param top_logprobs:
        :param max_completion_tokens:
        :param max_tokens:
        :param metadata:
        :param presence_penalty:
        :param reasoning:
        :param response_format:
        :param seed:
        :param stop:
        :param stream:
        :param stream_options:
        :param temperature:
        :param tool_choice:
        :param tools:
        :param top_p:
        :param user:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """

    async def send_async(
        self,
        *,
        messages: Union[List[models.Message], List[models.MessageTypedDict]],
        model: Optional[str] = None,
        models: Optional[List[str]] = None,
        frequency_penalty: OptionalNullable[float] = UNSET,
        logit_bias: OptionalNullable[Dict[str, float]] = UNSET,
        logprobs: OptionalNullable[bool] = UNSET,
        top_logprobs: OptionalNullable[float] = UNSET,
        max_completion_tokens: OptionalNullable[float] = UNSET,
        max_tokens: OptionalNullable[float] = UNSET,
        metadata: Optional[Dict[str, str]] = None,
        presence_penalty: OptionalNullable[float] = UNSET,
        reasoning: Optional[Union[models.Reasoning, models.ReasoningTypedDict]] = None,
        response_format: Optional[
            Union[
                models.ChatGenerationParamsResponseFormatUnion,
                models.ChatGenerationParamsResponseFormatUnionTypedDict,
            ]
        ] = None,
        seed: OptionalNullable[int] = UNSET,
        stop: OptionalNullable[
            Union[
                models.ChatGenerationParamsStop,
                models.ChatGenerationParamsStopTypedDict,
            ]
        ] = UNSET,
        stream: Optional[bool] = False,
        stream_options: OptionalNullable[
            Union[models.ChatStreamOptions, models.ChatStreamOptionsTypedDict]
        ] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        tool_choice: Optional[Any] = None,
        tools: Optional[
            Union[
                List[models.ToolDefinitionJSON],
                List[models.ToolDefinitionJSONTypedDict],
            ]
        ] = None,
        top_p: OptionalNullable[float] = UNSET,
        user: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SendChatCompletionRequestResponse:
        r"""Create a chat completion

        Sends a request for a model response for the given chat conversation. Supports both streaming and non-streaming modes.

        :param messages:
        :param model:
        :param models:
        :param frequency_penalty:
        :param logit_bias:
        :param logprobs:
        :param top_logprobs:
        :param max_completion_tokens:
        :param max_tokens:
        :param metadata:
        :param presence_penalty:
        :param reasoning:
        :param response_format:
        :param seed:
        :param stop:
        :param stream:
        :param stream_options:
        :param temperature:
        :param tool_choice:
        :param tools:
        :param top_p:
        :param user:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ChatGenerationParams(
            messages=utils.get_pydantic_model(messages, List[models.Message]),
            model=model,
            models=models,
            frequency_penalty=frequency_penalty,
            logit_bias=logit_bias,
            logprobs=logprobs,
            top_logprobs=top_logprobs,
            max_completion_tokens=max_completion_tokens,
            max_tokens=max_tokens,
            metadata=metadata,
            presence_penalty=presence_penalty,
            reasoning=utils.get_pydantic_model(reasoning, Optional[models.Reasoning]),
            response_format=utils.get_pydantic_model(
                response_format,
                Optional[models.ChatGenerationParamsResponseFormatUnion],
            ),
            seed=seed,
            stop=stop,
            stream=stream,
            stream_options=utils.get_pydantic_model(
                stream_options, OptionalNullable[models.ChatStreamOptions]
            ),
            temperature=temperature,
            tool_choice=tool_choice,
            tools=utils.get_pydantic_model(
                tools, Optional[List[models.ToolDefinitionJSON]]
            ),
            top_p=top_p,
            user=user,
        )

        req = self._build_request_async(
            method="POST",
            path="/chat/completions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="text/event-stream" if stream else "application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.ChatGenerationParams
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="sendChatCompletionRequest",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "429", "4XX", "500", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return unmarshal_json_response(models.ChatResponse, http_res, http_res_text)
        if utils.match_response(http_res, "200", "text/event-stream"):
            return eventstreaming.EventStreamAsync(
                http_res,
                lambda raw: utils.unmarshal_json(
                    raw, models.ChatStreamingResponseChunk
                ).data,
                sentinel="[DONE]",
                client_ref=self,
            )
        if utils.match_response(http_res, ["400", "401", "429"], "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            response_data = unmarshal_json_response(
                errors.ChatErrorData, http_res, http_res_text
            )
            raise errors.ChatError(response_data, http_res, http_res_text)
        if utils.match_response(http_res, "500", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            response_data = unmarshal_json_response(
                errors.ChatErrorData, http_res, http_res_text
            )
            raise errors.ChatError(response_data, http_res, http_res_text)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.OpenRouterDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.OpenRouterDefaultError(
                "API error occurred", http_res, http_res_text
            )

        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.OpenRouterDefaultError(
            "Unexpected response received", http_res, http_res_text
        )
