"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from openrouter import errors, models, utils
from openrouter._hooks import HookContext
from openrouter.types import OptionalNullable, UNSET
from openrouter.utils import get_security_from_env
from openrouter.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Dict, List, Mapping, Optional, Union


class Completions(BaseSDK):
    def generate(
        self,
        *,
        prompt: Union[models.Prompt, models.PromptTypedDict],
        model: Optional[str] = None,
        models: Optional[List[str]] = None,
        best_of: OptionalNullable[int] = UNSET,
        echo: OptionalNullable[bool] = UNSET,
        frequency_penalty: OptionalNullable[float] = UNSET,
        logit_bias: OptionalNullable[Dict[str, float]] = UNSET,
        logprobs: OptionalNullable[int] = UNSET,
        max_tokens: OptionalNullable[int] = UNSET,
        n: OptionalNullable[int] = UNSET,
        presence_penalty: OptionalNullable[float] = UNSET,
        seed: OptionalNullable[int] = UNSET,
        stop: OptionalNullable[
            Union[
                models.CompletionCreateParamsStop,
                models.CompletionCreateParamsStopTypedDict,
            ]
        ] = UNSET,
        stream: Optional[bool] = False,
        stream_options: OptionalNullable[
            Union[models.StreamOptions, models.StreamOptionsTypedDict]
        ] = UNSET,
        suffix: OptionalNullable[str] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        top_p: OptionalNullable[float] = UNSET,
        user: Optional[str] = None,
        metadata: OptionalNullable[Dict[str, str]] = UNSET,
        response_format: OptionalNullable[
            Union[
                models.CompletionCreateParamsResponseFormatUnion,
                models.CompletionCreateParamsResponseFormatUnionTypedDict,
            ]
        ] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CompletionResponse:
        r"""Create a completion

        Creates a completion for the provided prompt and parameters. Supports both streaming and non-streaming modes.

        :param prompt:
        :param model:
        :param models:
        :param best_of:
        :param echo:
        :param frequency_penalty:
        :param logit_bias:
        :param logprobs:
        :param max_tokens:
        :param n:
        :param presence_penalty:
        :param seed:
        :param stop:
        :param stream:
        :param stream_options:
        :param suffix:
        :param temperature:
        :param top_p:
        :param user:
        :param metadata:
        :param response_format:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CompletionCreateParams(
            model=model,
            models=models,
            prompt=prompt,
            best_of=best_of,
            echo=echo,
            frequency_penalty=frequency_penalty,
            logit_bias=logit_bias,
            logprobs=logprobs,
            max_tokens=max_tokens,
            n=n,
            presence_penalty=presence_penalty,
            seed=seed,
            stop=stop,
            stream=stream,
            stream_options=utils.get_pydantic_model(
                stream_options, OptionalNullable[models.StreamOptions]
            ),
            suffix=suffix,
            temperature=temperature,
            top_p=top_p,
            user=user,
            metadata=metadata,
            response_format=utils.get_pydantic_model(
                response_format,
                OptionalNullable[models.CompletionCreateParamsResponseFormatUnion],
            ),
        )

        req = self._build_request(
            method="POST",
            path="/completions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.CompletionCreateParams
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="createCompletions",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "429", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.CompletionResponse, http_res)
        if utils.match_response(http_res, ["400", "401", "429"], "application/json"):
            response_data = unmarshal_json_response(errors.ChatErrorData, http_res)
            raise errors.ChatError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.ChatErrorData, http_res)
            raise errors.ChatError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.OpenRouterDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.OpenRouterDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.OpenRouterDefaultError("Unexpected response received", http_res)

    async def generate_async(
        self,
        *,
        prompt: Union[models.Prompt, models.PromptTypedDict],
        model: Optional[str] = None,
        models: Optional[List[str]] = None,
        best_of: OptionalNullable[int] = UNSET,
        echo: OptionalNullable[bool] = UNSET,
        frequency_penalty: OptionalNullable[float] = UNSET,
        logit_bias: OptionalNullable[Dict[str, float]] = UNSET,
        logprobs: OptionalNullable[int] = UNSET,
        max_tokens: OptionalNullable[int] = UNSET,
        n: OptionalNullable[int] = UNSET,
        presence_penalty: OptionalNullable[float] = UNSET,
        seed: OptionalNullable[int] = UNSET,
        stop: OptionalNullable[
            Union[
                models.CompletionCreateParamsStop,
                models.CompletionCreateParamsStopTypedDict,
            ]
        ] = UNSET,
        stream: Optional[bool] = False,
        stream_options: OptionalNullable[
            Union[models.StreamOptions, models.StreamOptionsTypedDict]
        ] = UNSET,
        suffix: OptionalNullable[str] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        top_p: OptionalNullable[float] = UNSET,
        user: Optional[str] = None,
        metadata: OptionalNullable[Dict[str, str]] = UNSET,
        response_format: OptionalNullable[
            Union[
                models.CompletionCreateParamsResponseFormatUnion,
                models.CompletionCreateParamsResponseFormatUnionTypedDict,
            ]
        ] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CompletionResponse:
        r"""Create a completion

        Creates a completion for the provided prompt and parameters. Supports both streaming and non-streaming modes.

        :param prompt:
        :param model:
        :param models:
        :param best_of:
        :param echo:
        :param frequency_penalty:
        :param logit_bias:
        :param logprobs:
        :param max_tokens:
        :param n:
        :param presence_penalty:
        :param seed:
        :param stop:
        :param stream:
        :param stream_options:
        :param suffix:
        :param temperature:
        :param top_p:
        :param user:
        :param metadata:
        :param response_format:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CompletionCreateParams(
            model=model,
            models=models,
            prompt=prompt,
            best_of=best_of,
            echo=echo,
            frequency_penalty=frequency_penalty,
            logit_bias=logit_bias,
            logprobs=logprobs,
            max_tokens=max_tokens,
            n=n,
            presence_penalty=presence_penalty,
            seed=seed,
            stop=stop,
            stream=stream,
            stream_options=utils.get_pydantic_model(
                stream_options, OptionalNullable[models.StreamOptions]
            ),
            suffix=suffix,
            temperature=temperature,
            top_p=top_p,
            user=user,
            metadata=metadata,
            response_format=utils.get_pydantic_model(
                response_format,
                OptionalNullable[models.CompletionCreateParamsResponseFormatUnion],
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/completions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.CompletionCreateParams
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="createCompletions",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "429", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.CompletionResponse, http_res)
        if utils.match_response(http_res, ["400", "401", "429"], "application/json"):
            response_data = unmarshal_json_response(errors.ChatErrorData, http_res)
            raise errors.ChatError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.ChatErrorData, http_res)
            raise errors.ChatError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.OpenRouterDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.OpenRouterDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.OpenRouterDefaultError("Unexpected response received", http_res)
