"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from openrouter.errors import OpenRouterError
from openrouter.models import (
    badgatewayresponseerrordata as models_badgatewayresponseerrordata,
)
from openrouter.types import BaseModel, OptionalNullable, UNSET
from typing import Optional


class BadGatewayResponseErrorData(BaseModel):
    error: models_badgatewayresponseerrordata.BadGatewayResponseErrorData
    r"""Error data for BadGatewayResponse"""

    user_id: OptionalNullable[str] = UNSET


@dataclass(unsafe_hash=True)
class BadGatewayResponseError(OpenRouterError):
    r"""Bad Gateway - Provider/upstream API failure"""

    data: BadGatewayResponseErrorData = field(hash=False)

    def __init__(
        self,
        data: BadGatewayResponseErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
