"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from openrouter.errors import OpenRouterError
from openrouter.models import (
    badrequestresponseerrordata as models_badrequestresponseerrordata,
)
from openrouter.types import BaseModel, OptionalNullable, UNSET
from typing import Optional


class BadRequestResponseErrorData(BaseModel):
    error: models_badrequestresponseerrordata.BadRequestResponseErrorData
    r"""Error data for BadRequestResponse"""

    user_id: OptionalNullable[str] = UNSET


@dataclass(unsafe_hash=True)
class BadRequestResponseError(OpenRouterError):
    r"""Bad Request - Invalid request parameters or malformed input"""

    data: BadRequestResponseErrorData = field(hash=False)

    def __init__(
        self,
        data: BadRequestResponseErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
