"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from openrouter.errors import OpenRouterError
from openrouter.models import chaterror as models_chaterror
from openrouter.types import BaseModel
from typing import Optional


class ChatErrorData(BaseModel):
    error: models_chaterror.ChatErrorError


@dataclass(unsafe_hash=True)
class ChatError(OpenRouterError):
    data: ChatErrorData = field(hash=False)

    def __init__(
        self,
        data: ChatErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
