"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from openrouter.errors import OpenRouterError
from openrouter.models import (
    edgenetworktimeoutresponseerrordata as models_edgenetworktimeoutresponseerrordata,
)
from openrouter.types import BaseModel, OptionalNullable, UNSET
from typing import Optional


class EdgeNetworkTimeoutResponseErrorData(BaseModel):
    error: (
        models_edgenetworktimeoutresponseerrordata.EdgeNetworkTimeoutResponseErrorData
    )
    r"""Error data for EdgeNetworkTimeoutResponse"""

    user_id: OptionalNullable[str] = UNSET


@dataclass(unsafe_hash=True)
class EdgeNetworkTimeoutResponseError(OpenRouterError):
    r"""Infrastructure Timeout - Provider request timed out at edge network"""

    data: EdgeNetworkTimeoutResponseErrorData = field(hash=False)

    def __init__(
        self,
        data: EdgeNetworkTimeoutResponseErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
