"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from openrouter.errors import OpenRouterError
from openrouter.models import (
    forbiddenresponseerrordata as models_forbiddenresponseerrordata,
)
from openrouter.types import BaseModel, OptionalNullable, UNSET
from typing import Optional


class ForbiddenResponseErrorData(BaseModel):
    error: models_forbiddenresponseerrordata.ForbiddenResponseErrorData
    r"""Error data for ForbiddenResponse"""

    user_id: OptionalNullable[str] = UNSET


@dataclass(unsafe_hash=True)
class ForbiddenResponseError(OpenRouterError):
    r"""Forbidden - Authentication successful but insufficient permissions"""

    data: ForbiddenResponseErrorData = field(hash=False)

    def __init__(
        self,
        data: ForbiddenResponseErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
