"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from openrouter.errors import OpenRouterError
from openrouter.models import (
    internalserverresponseerrordata as models_internalserverresponseerrordata,
)
from openrouter.types import BaseModel, OptionalNullable, UNSET
from typing import Optional


class InternalServerResponseErrorData(BaseModel):
    error: models_internalserverresponseerrordata.InternalServerResponseErrorData
    r"""Error data for InternalServerResponse"""

    user_id: OptionalNullable[str] = UNSET


@dataclass(unsafe_hash=True)
class InternalServerResponseError(OpenRouterError):
    r"""Internal Server Error - Unexpected server error"""

    data: InternalServerResponseErrorData = field(hash=False)

    def __init__(
        self,
        data: InternalServerResponseErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
