"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from openrouter.errors import OpenRouterError
from openrouter.models import (
    notfoundresponseerrordata as models_notfoundresponseerrordata,
)
from openrouter.types import BaseModel, OptionalNullable, UNSET
from typing import Optional


class NotFoundResponseErrorData(BaseModel):
    error: models_notfoundresponseerrordata.NotFoundResponseErrorData
    r"""Error data for NotFoundResponse"""

    user_id: OptionalNullable[str] = UNSET


@dataclass(unsafe_hash=True)
class NotFoundResponseError(OpenRouterError):
    r"""Not Found - Resource does not exist"""

    data: NotFoundResponseErrorData = field(hash=False)

    def __init__(
        self,
        data: NotFoundResponseErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
