"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from openrouter.errors import OpenRouterError
from openrouter.models import (
    payloadtoolargeresponseerrordata as models_payloadtoolargeresponseerrordata,
)
from openrouter.types import BaseModel, OptionalNullable, UNSET
from typing import Optional


class PayloadTooLargeResponseErrorData(BaseModel):
    error: models_payloadtoolargeresponseerrordata.PayloadTooLargeResponseErrorData
    r"""Error data for PayloadTooLargeResponse"""

    user_id: OptionalNullable[str] = UNSET


@dataclass(unsafe_hash=True)
class PayloadTooLargeResponseError(OpenRouterError):
    r"""Payload Too Large - Request payload exceeds size limits"""

    data: PayloadTooLargeResponseErrorData = field(hash=False)

    def __init__(
        self,
        data: PayloadTooLargeResponseErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
