"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from openrouter.errors import OpenRouterError
from openrouter.models import (
    paymentrequiredresponseerrordata as models_paymentrequiredresponseerrordata,
)
from openrouter.types import BaseModel, OptionalNullable, UNSET
from typing import Optional


class PaymentRequiredResponseErrorData(BaseModel):
    error: models_paymentrequiredresponseerrordata.PaymentRequiredResponseErrorData
    r"""Error data for PaymentRequiredResponse"""

    user_id: OptionalNullable[str] = UNSET


@dataclass(unsafe_hash=True)
class PaymentRequiredResponseError(OpenRouterError):
    r"""Payment Required - Insufficient credits or quota to complete request"""

    data: PaymentRequiredResponseErrorData = field(hash=False)

    def __init__(
        self,
        data: PaymentRequiredResponseErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
