"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from openrouter.errors import OpenRouterError
from openrouter.models import (
    provideroverloadedresponseerrordata as models_provideroverloadedresponseerrordata,
)
from openrouter.types import BaseModel, OptionalNullable, UNSET
from typing import Optional


class ProviderOverloadedResponseErrorData(BaseModel):
    error: (
        models_provideroverloadedresponseerrordata.ProviderOverloadedResponseErrorData
    )
    r"""Error data for ProviderOverloadedResponse"""

    user_id: OptionalNullable[str] = UNSET


@dataclass(unsafe_hash=True)
class ProviderOverloadedResponseError(OpenRouterError):
    r"""Provider Overloaded - Provider is temporarily overloaded"""

    data: ProviderOverloadedResponseErrorData = field(hash=False)

    def __init__(
        self,
        data: ProviderOverloadedResponseErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
