"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from openrouter.errors import OpenRouterError
from openrouter.models import (
    requesttimeoutresponseerrordata as models_requesttimeoutresponseerrordata,
)
from openrouter.types import BaseModel, OptionalNullable, UNSET
from typing import Optional


class RequestTimeoutResponseErrorData(BaseModel):
    error: models_requesttimeoutresponseerrordata.RequestTimeoutResponseErrorData
    r"""Error data for RequestTimeoutResponse"""

    user_id: OptionalNullable[str] = UNSET


@dataclass(unsafe_hash=True)
class RequestTimeoutResponseError(OpenRouterError):
    r"""Request Timeout - Operation exceeded time limit"""

    data: RequestTimeoutResponseErrorData = field(hash=False)

    def __init__(
        self,
        data: RequestTimeoutResponseErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
