"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from openrouter.errors import OpenRouterError
from openrouter.models import (
    toomanyrequestsresponseerrordata as models_toomanyrequestsresponseerrordata,
)
from openrouter.types import BaseModel, OptionalNullable, UNSET
from typing import Optional


class TooManyRequestsResponseErrorData(BaseModel):
    error: models_toomanyrequestsresponseerrordata.TooManyRequestsResponseErrorData
    r"""Error data for TooManyRequestsResponse"""

    user_id: OptionalNullable[str] = UNSET


@dataclass(unsafe_hash=True)
class TooManyRequestsResponseError(OpenRouterError):
    r"""Too Many Requests - Rate limit exceeded"""

    data: TooManyRequestsResponseErrorData = field(hash=False)

    def __init__(
        self,
        data: TooManyRequestsResponseErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
