"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from openrouter.errors import OpenRouterError
from openrouter.models import (
    unauthorizedresponseerrordata as models_unauthorizedresponseerrordata,
)
from openrouter.types import BaseModel, OptionalNullable, UNSET
from typing import Optional


class UnauthorizedResponseErrorData(BaseModel):
    error: models_unauthorizedresponseerrordata.UnauthorizedResponseErrorData
    r"""Error data for UnauthorizedResponse"""

    user_id: OptionalNullable[str] = UNSET


@dataclass(unsafe_hash=True)
class UnauthorizedResponseError(OpenRouterError):
    r"""Unauthorized - Authentication required or invalid credentials"""

    data: UnauthorizedResponseErrorData = field(hash=False)

    def __init__(
        self,
        data: UnauthorizedResponseErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
