"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from openrouter.errors import OpenRouterError
from openrouter.models import (
    unprocessableentityresponseerrordata as models_unprocessableentityresponseerrordata,
)
from openrouter.types import BaseModel, OptionalNullable, UNSET
from typing import Optional


class UnprocessableEntityResponseErrorData(BaseModel):
    error: (
        models_unprocessableentityresponseerrordata.UnprocessableEntityResponseErrorData
    )
    r"""Error data for UnprocessableEntityResponse"""

    user_id: OptionalNullable[str] = UNSET


@dataclass(unsafe_hash=True)
class UnprocessableEntityResponseError(OpenRouterError):
    r"""Unprocessable Entity - Semantic validation failure"""

    data: UnprocessableEntityResponseErrorData = field(hash=False)

    def __init__(
        self,
        data: UnprocessableEntityResponseErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
