"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from openrouter.types import BaseModel
import pydantic
from typing_extensions import Annotated, TypedDict


class ActivityItemTypedDict(TypedDict):
    date_: str
    r"""Date of the activity (YYYY-MM-DD format)"""
    model: str
    r"""Model slug (e.g., \"openai/gpt-4.1\")"""
    model_permaslug: str
    r"""Model permaslug (e.g., \"openai/gpt-4.1-2025-04-14\")"""
    endpoint_id: str
    r"""Unique identifier for the endpoint"""
    provider_name: str
    r"""Name of the provider serving this endpoint"""
    usage: float
    r"""Total cost in USD (OpenRouter credits spent)"""
    byok_usage_inference: float
    r"""BYOK inference cost in USD (external credits spent)"""
    requests: float
    r"""Number of requests made"""
    prompt_tokens: float
    r"""Total prompt tokens used"""
    completion_tokens: float
    r"""Total completion tokens generated"""
    reasoning_tokens: float
    r"""Total reasoning tokens used"""


class ActivityItem(BaseModel):
    date_: Annotated[str, pydantic.Field(alias="date")]
    r"""Date of the activity (YYYY-MM-DD format)"""

    model: str
    r"""Model slug (e.g., \"openai/gpt-4.1\")"""

    model_permaslug: str
    r"""Model permaslug (e.g., \"openai/gpt-4.1-2025-04-14\")"""

    endpoint_id: str
    r"""Unique identifier for the endpoint"""

    provider_name: str
    r"""Name of the provider serving this endpoint"""

    usage: float
    r"""Total cost in USD (OpenRouter credits spent)"""

    byok_usage_inference: float
    r"""BYOK inference cost in USD (external credits spent)"""

    requests: float
    r"""Number of requests made"""

    prompt_tokens: float
    r"""Total prompt tokens used"""

    completion_tokens: float
    r"""Total completion tokens generated"""

    reasoning_tokens: float
    r"""Total reasoning tokens used"""
