"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .chatmessagecontentitem import (
    ChatMessageContentItem,
    ChatMessageContentItemTypedDict,
)
from .chatmessagetoolcall import ChatMessageToolCall, ChatMessageToolCallTypedDict
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from openrouter.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


AssistantMessageContentTypedDict = TypeAliasType(
    "AssistantMessageContentTypedDict",
    Union[str, List[ChatMessageContentItemTypedDict]],
)


AssistantMessageContent = TypeAliasType(
    "AssistantMessageContent", Union[str, List[ChatMessageContentItem]]
)


class AssistantMessageTypedDict(TypedDict):
    role: Literal["assistant"]
    content: NotRequired[Nullable[AssistantMessageContentTypedDict]]
    name: NotRequired[str]
    tool_calls: NotRequired[List[ChatMessageToolCallTypedDict]]
    refusal: NotRequired[Nullable[str]]
    reasoning: NotRequired[Nullable[str]]


class AssistantMessage(BaseModel):
    ROLE: Annotated[
        Annotated[Literal["assistant"], AfterValidator(validate_const("assistant"))],
        pydantic.Field(alias="role"),
    ] = "assistant"

    content: OptionalNullable[AssistantMessageContent] = UNSET

    name: Optional[str] = None

    tool_calls: Optional[List[ChatMessageToolCall]] = None

    refusal: OptionalNullable[str] = UNSET

    reasoning: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["content", "name", "tool_calls", "refusal", "reasoning"]
        nullable_fields = ["content", "refusal", "reasoning"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
