"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from openrouter.types import BaseModel, UnrecognizedStr
from openrouter.utils import validate_const, validate_open_enum
import pydantic
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


ChatMessageContentItemImageDetail = Union[
    Literal[
        "auto",
        "low",
        "high",
    ],
    UnrecognizedStr,
]


class ImageURLTypedDict(TypedDict):
    url: str
    detail: NotRequired[ChatMessageContentItemImageDetail]


class ImageURL(BaseModel):
    url: str

    detail: Annotated[
        Optional[ChatMessageContentItemImageDetail],
        PlainValidator(validate_open_enum(False)),
    ] = None


class ChatMessageContentItemImageTypedDict(TypedDict):
    image_url: ImageURLTypedDict
    type: Literal["image_url"]


class ChatMessageContentItemImage(BaseModel):
    image_url: ImageURL

    TYPE: Annotated[
        Annotated[Literal["image_url"], AfterValidator(validate_const("image_url"))],
        pydantic.Field(alias="type"),
    ] = "image_url"
