"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .assistantmessage import AssistantMessage, AssistantMessageTypedDict
from .chatcompletionfinishreason import ChatCompletionFinishReason
from .chatmessagetokenlogprobs import (
    ChatMessageTokenLogprobs,
    ChatMessageTokenLogprobsTypedDict,
)
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from openrouter.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing_extensions import Annotated, NotRequired, TypedDict


class ChatResponseChoiceTypedDict(TypedDict):
    finish_reason: Nullable[ChatCompletionFinishReason]
    index: float
    message: AssistantMessageTypedDict
    logprobs: NotRequired[Nullable[ChatMessageTokenLogprobsTypedDict]]


class ChatResponseChoice(BaseModel):
    finish_reason: Annotated[
        Nullable[ChatCompletionFinishReason], PlainValidator(validate_open_enum(False))
    ]

    index: float

    message: AssistantMessage

    logprobs: OptionalNullable[ChatMessageTokenLogprobs] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["logprobs"]
        nullable_fields = ["finish_reason", "logprobs"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
