"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .chatgenerationtokenusage import (
    ChatGenerationTokenUsage,
    ChatGenerationTokenUsageTypedDict,
)
from .chatstreamingchoice import ChatStreamingChoice, ChatStreamingChoiceTypedDict
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from openrouter.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ChatStreamingResponseChunkErrorTypedDict(TypedDict):
    message: str
    code: float


class ChatStreamingResponseChunkError(BaseModel):
    message: str

    code: float


class ChatStreamingResponseChunkDataTypedDict(TypedDict):
    id: str
    choices: List[ChatStreamingChoiceTypedDict]
    created: float
    model: str
    object: Literal["chat.completion.chunk"]
    system_fingerprint: NotRequired[Nullable[str]]
    error: NotRequired[ChatStreamingResponseChunkErrorTypedDict]
    usage: NotRequired[ChatGenerationTokenUsageTypedDict]


class ChatStreamingResponseChunkData(BaseModel):
    id: str

    choices: List[ChatStreamingChoice]

    created: float

    model: str

    OBJECT: Annotated[
        Annotated[
            Literal["chat.completion.chunk"],
            AfterValidator(validate_const("chat.completion.chunk")),
        ],
        pydantic.Field(alias="object"),
    ] = "chat.completion.chunk"

    system_fingerprint: OptionalNullable[str] = UNSET

    error: Optional[ChatStreamingResponseChunkError] = None

    usage: Optional[ChatGenerationTokenUsage] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["system_fingerprint", "error", "usage"]
        nullable_fields = ["system_fingerprint"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ChatStreamingResponseChunkTypedDict(TypedDict):
    data: ChatStreamingResponseChunkDataTypedDict


class ChatStreamingResponseChunk(BaseModel):
    data: ChatStreamingResponseChunkData
