"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .completionchoice import CompletionChoice, CompletionChoiceTypedDict
from .completionusage import CompletionUsage, CompletionUsageTypedDict
from openrouter.types import BaseModel
from openrouter.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CompletionResponseTypedDict(TypedDict):
    id: str
    created: float
    model: str
    choices: List[CompletionChoiceTypedDict]
    object: Literal["text_completion"]
    system_fingerprint: NotRequired[str]
    usage: NotRequired[CompletionUsageTypedDict]


class CompletionResponse(BaseModel):
    id: str

    created: float

    model: str

    choices: List[CompletionChoice]

    OBJECT: Annotated[
        Annotated[
            Literal["text_completion"],
            AfterValidator(validate_const("text_completion")),
        ],
        pydantic.Field(alias="object"),
    ] = "text_completion"

    system_fingerprint: Optional[str] = None

    usage: Optional[CompletionUsage] = None
