"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
    UnrecognizedStr,
)
from openrouter.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


CreateAuthKeysCodeCodeChallengeMethod = Union[
    Literal[
        "S256",
        "plain",
    ],
    UnrecognizedStr,
]
r"""The method used to generate the code challenge"""


class CreateAuthKeysCodeRequestTypedDict(TypedDict):
    callback_url: str
    r"""The callback URL to redirect to after authorization. Note, only https URLs on ports 443 and 3000 are allowed."""
    code_challenge: NotRequired[str]
    r"""PKCE code challenge for enhanced security"""
    code_challenge_method: NotRequired[CreateAuthKeysCodeCodeChallengeMethod]
    r"""The method used to generate the code challenge"""
    limit: NotRequired[float]
    r"""Credit limit for the API key to be created"""
    expires_at: NotRequired[Nullable[datetime]]
    r"""Optional expiration time for the API key to be created"""


class CreateAuthKeysCodeRequest(BaseModel):
    callback_url: str
    r"""The callback URL to redirect to after authorization. Note, only https URLs on ports 443 and 3000 are allowed."""

    code_challenge: Optional[str] = None
    r"""PKCE code challenge for enhanced security"""

    code_challenge_method: Annotated[
        Optional[CreateAuthKeysCodeCodeChallengeMethod],
        PlainValidator(validate_open_enum(False)),
    ] = None
    r"""The method used to generate the code challenge"""

    limit: Optional[float] = None
    r"""Credit limit for the API key to be created"""

    expires_at: OptionalNullable[datetime] = UNSET
    r"""Optional expiration time for the API key to be created"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "code_challenge",
            "code_challenge_method",
            "limit",
            "expires_at",
        ]
        nullable_fields = ["expires_at"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateAuthKeysCodeDataTypedDict(TypedDict):
    r"""Auth code data"""

    id: str
    r"""The authorization code ID to use in the exchange request"""
    app_id: float
    r"""The application ID associated with this auth code"""
    created_at: str
    r"""ISO 8601 timestamp of when the auth code was created"""


class CreateAuthKeysCodeData(BaseModel):
    r"""Auth code data"""

    id: str
    r"""The authorization code ID to use in the exchange request"""

    app_id: float
    r"""The application ID associated with this auth code"""

    created_at: str
    r"""ISO 8601 timestamp of when the auth code was created"""


class CreateAuthKeysCodeResponseTypedDict(TypedDict):
    r"""Successfully created authorization code"""

    data: CreateAuthKeysCodeDataTypedDict
    r"""Auth code data"""


class CreateAuthKeysCodeResponse(BaseModel):
    r"""Successfully created authorization code"""

    data: CreateAuthKeysCodeData
    r"""Auth code data"""
