"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from openrouter.types import BaseModel
from openrouter.utils import FieldMetadata, SecurityMetadata
from typing_extensions import Annotated, TypedDict


class CreateCoinbaseChargeSecurityTypedDict(TypedDict):
    bearer: str


class CreateCoinbaseChargeSecurity(BaseModel):
    bearer: Annotated[
        str,
        FieldMetadata(
            security=SecurityMetadata(
                scheme=True,
                scheme_type="http",
                sub_type="bearer",
                field_name="Authorization",
            )
        ),
    ]


class CallDataTypedDict(TypedDict):
    deadline: str
    fee_amount: str
    id: str
    operator: str
    prefix: str
    recipient: str
    recipient_amount: str
    recipient_currency: str
    refund_destination: str
    signature: str


class CallData(BaseModel):
    deadline: str

    fee_amount: str

    id: str

    operator: str

    prefix: str

    recipient: str

    recipient_amount: str

    recipient_currency: str

    refund_destination: str

    signature: str


class MetadataTypedDict(TypedDict):
    chain_id: float
    contract_address: str
    sender: str


class Metadata(BaseModel):
    chain_id: float

    contract_address: str

    sender: str


class TransferIntentTypedDict(TypedDict):
    call_data: CallDataTypedDict
    metadata: MetadataTypedDict


class TransferIntent(BaseModel):
    call_data: CallData

    metadata: Metadata


class Web3DataTypedDict(TypedDict):
    transfer_intent: TransferIntentTypedDict


class Web3Data(BaseModel):
    transfer_intent: TransferIntent


class CreateCoinbaseChargeDataTypedDict(TypedDict):
    id: str
    created_at: str
    expires_at: str
    web3_data: Web3DataTypedDict


class CreateCoinbaseChargeData(BaseModel):
    id: str

    created_at: str

    expires_at: str

    web3_data: Web3Data


class CreateCoinbaseChargeResponseTypedDict(TypedDict):
    r"""Returns the calldata to fulfill the transaction"""

    data: CreateCoinbaseChargeDataTypedDict


class CreateCoinbaseChargeResponse(BaseModel):
    r"""Returns the calldata to fulfill the transaction"""

    data: CreateCoinbaseChargeData
