"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .providername import ProviderName
from .quantization import Quantization
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
    UnrecognizedStr,
)
from openrouter.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Any, List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


InputTypedDict = TypeAliasType(
    "InputTypedDict", Union[str, List[str], List[float], List[List[float]]]
)


Input = TypeAliasType("Input", Union[str, List[str], List[float], List[List[float]]])


CreateEmbeddingsDataCollection = Union[
    Literal[
        "deny",
        "allow",
    ],
    UnrecognizedStr,
]
r"""Data collection setting. If no available model provider meets the requirement, your request will return an error.
- allow: (default) allow providers which store user data non-transiently and may train on it
- deny: use only providers which do not collect user data.

"""


CreateEmbeddingsOrderTypedDict = TypeAliasType(
    "CreateEmbeddingsOrderTypedDict", Union[ProviderName, str]
)


CreateEmbeddingsOrder = TypeAliasType(
    "CreateEmbeddingsOrder",
    Union[Annotated[ProviderName, PlainValidator(validate_open_enum(False))], str],
)


CreateEmbeddingsOnlyTypedDict = TypeAliasType(
    "CreateEmbeddingsOnlyTypedDict", Union[ProviderName, str]
)


CreateEmbeddingsOnly = TypeAliasType(
    "CreateEmbeddingsOnly",
    Union[Annotated[ProviderName, PlainValidator(validate_open_enum(False))], str],
)


CreateEmbeddingsIgnoreTypedDict = TypeAliasType(
    "CreateEmbeddingsIgnoreTypedDict", Union[ProviderName, str]
)


CreateEmbeddingsIgnore = TypeAliasType(
    "CreateEmbeddingsIgnore",
    Union[Annotated[ProviderName, PlainValidator(validate_open_enum(False))], str],
)


CreateEmbeddingsSort = Union[
    Literal[
        "price",
        "throughput",
        "latency",
    ],
    UnrecognizedStr,
]
r"""The sorting strategy to use for this request, if \"order\" is not specified. When set, no load balancing is performed."""


class CreateEmbeddingsMaxPriceTypedDict(TypedDict):
    r"""The object specifying the maximum price you want to pay for this request. USD price per million tokens, for prompt and completion."""

    prompt: NotRequired[Any]
    r"""A value in string or number format that is a large number"""
    completion: NotRequired[Any]
    r"""A value in string or number format that is a large number"""
    image: NotRequired[Any]
    r"""A value in string or number format that is a large number"""
    audio: NotRequired[Any]
    r"""A value in string or number format that is a large number"""
    request: NotRequired[Any]
    r"""A value in string or number format that is a large number"""


class CreateEmbeddingsMaxPrice(BaseModel):
    r"""The object specifying the maximum price you want to pay for this request. USD price per million tokens, for prompt and completion."""

    prompt: Optional[Any] = None
    r"""A value in string or number format that is a large number"""

    completion: Optional[Any] = None
    r"""A value in string or number format that is a large number"""

    image: Optional[Any] = None
    r"""A value in string or number format that is a large number"""

    audio: Optional[Any] = None
    r"""A value in string or number format that is a large number"""

    request: Optional[Any] = None
    r"""A value in string or number format that is a large number"""


class CreateEmbeddingsProviderTypedDict(TypedDict):
    allow_fallbacks: NotRequired[Nullable[bool]]
    r"""Whether to allow backup providers to serve requests
    - true: (default) when the primary provider (or your custom providers in \"order\") is unavailable, use the next best provider.
    - false: use only the primary/custom provider, and return the upstream error if it's unavailable.

    """
    require_parameters: NotRequired[Nullable[bool]]
    r"""Whether to filter providers to only those that support the parameters you've provided. If this setting is omitted or set to false, then providers will receive only the parameters they support, and ignore the rest."""
    data_collection: NotRequired[Nullable[CreateEmbeddingsDataCollection]]
    r"""Data collection setting. If no available model provider meets the requirement, your request will return an error.
    - allow: (default) allow providers which store user data non-transiently and may train on it
    - deny: use only providers which do not collect user data.

    """
    zdr: NotRequired[Nullable[bool]]
    r"""Whether to restrict routing to only ZDR (Zero Data Retention) endpoints. When true, only endpoints that do not retain prompts will be used."""
    enforce_distillable_text: NotRequired[Nullable[bool]]
    r"""Whether to restrict routing to only models that allow text distillation. When true, only models where the author has allowed distillation will be used."""
    order: NotRequired[Nullable[List[CreateEmbeddingsOrderTypedDict]]]
    r"""An ordered list of provider slugs. The router will attempt to use the first provider in the subset of this list that supports your requested model, and fall back to the next if it is unavailable. If no providers are available, the request will fail with an error message."""
    only: NotRequired[Nullable[List[CreateEmbeddingsOnlyTypedDict]]]
    r"""List of provider slugs to allow. If provided, this list is merged with your account-wide allowed provider settings for this request."""
    ignore: NotRequired[Nullable[List[CreateEmbeddingsIgnoreTypedDict]]]
    r"""List of provider slugs to ignore. If provided, this list is merged with your account-wide ignored provider settings for this request."""
    quantizations: NotRequired[Nullable[List[Quantization]]]
    r"""A list of quantization levels to filter the provider by."""
    sort: NotRequired[Nullable[CreateEmbeddingsSort]]
    r"""The sorting strategy to use for this request, if \"order\" is not specified. When set, no load balancing is performed."""
    max_price: NotRequired[CreateEmbeddingsMaxPriceTypedDict]
    r"""The object specifying the maximum price you want to pay for this request. USD price per million tokens, for prompt and completion."""


class CreateEmbeddingsProvider(BaseModel):
    allow_fallbacks: OptionalNullable[bool] = UNSET
    r"""Whether to allow backup providers to serve requests
    - true: (default) when the primary provider (or your custom providers in \"order\") is unavailable, use the next best provider.
    - false: use only the primary/custom provider, and return the upstream error if it's unavailable.

    """

    require_parameters: OptionalNullable[bool] = UNSET
    r"""Whether to filter providers to only those that support the parameters you've provided. If this setting is omitted or set to false, then providers will receive only the parameters they support, and ignore the rest."""

    data_collection: Annotated[
        OptionalNullable[CreateEmbeddingsDataCollection],
        PlainValidator(validate_open_enum(False)),
    ] = UNSET
    r"""Data collection setting. If no available model provider meets the requirement, your request will return an error.
    - allow: (default) allow providers which store user data non-transiently and may train on it
    - deny: use only providers which do not collect user data.

    """

    zdr: OptionalNullable[bool] = UNSET
    r"""Whether to restrict routing to only ZDR (Zero Data Retention) endpoints. When true, only endpoints that do not retain prompts will be used."""

    enforce_distillable_text: OptionalNullable[bool] = UNSET
    r"""Whether to restrict routing to only models that allow text distillation. When true, only models where the author has allowed distillation will be used."""

    order: OptionalNullable[List[CreateEmbeddingsOrder]] = UNSET
    r"""An ordered list of provider slugs. The router will attempt to use the first provider in the subset of this list that supports your requested model, and fall back to the next if it is unavailable. If no providers are available, the request will fail with an error message."""

    only: OptionalNullable[List[CreateEmbeddingsOnly]] = UNSET
    r"""List of provider slugs to allow. If provided, this list is merged with your account-wide allowed provider settings for this request."""

    ignore: OptionalNullable[List[CreateEmbeddingsIgnore]] = UNSET
    r"""List of provider slugs to ignore. If provided, this list is merged with your account-wide ignored provider settings for this request."""

    quantizations: OptionalNullable[
        List[Annotated[Quantization, PlainValidator(validate_open_enum(False))]]
    ] = UNSET
    r"""A list of quantization levels to filter the provider by."""

    sort: Annotated[
        OptionalNullable[CreateEmbeddingsSort],
        PlainValidator(validate_open_enum(False)),
    ] = UNSET
    r"""The sorting strategy to use for this request, if \"order\" is not specified. When set, no load balancing is performed."""

    max_price: Optional[CreateEmbeddingsMaxPrice] = None
    r"""The object specifying the maximum price you want to pay for this request. USD price per million tokens, for prompt and completion."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "allow_fallbacks",
            "require_parameters",
            "data_collection",
            "zdr",
            "enforce_distillable_text",
            "order",
            "only",
            "ignore",
            "quantizations",
            "sort",
            "max_price",
        ]
        nullable_fields = [
            "allow_fallbacks",
            "require_parameters",
            "data_collection",
            "zdr",
            "enforce_distillable_text",
            "order",
            "only",
            "ignore",
            "quantizations",
            "sort",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


EncodingFormatBase64 = Literal["base64",]


EncodingFormatFloat = Literal["float",]


EncodingFormatTypedDict = TypeAliasType(
    "EncodingFormatTypedDict", Union[EncodingFormatFloat, EncodingFormatBase64]
)


EncodingFormat = TypeAliasType(
    "EncodingFormat", Union[EncodingFormatFloat, EncodingFormatBase64]
)


class CreateEmbeddingsRequestTypedDict(TypedDict):
    input: InputTypedDict
    model: str
    provider: NotRequired[CreateEmbeddingsProviderTypedDict]
    encoding_format: NotRequired[EncodingFormatTypedDict]
    user: NotRequired[str]


class CreateEmbeddingsRequest(BaseModel):
    input: Input

    model: str

    provider: Optional[CreateEmbeddingsProvider] = None

    encoding_format: Optional[EncodingFormat] = None

    user: Optional[str] = None


CreateEmbeddingsObject = Literal["list",]


ObjectEmbedding = Literal["embedding",]


EmbeddingTypedDict = TypeAliasType("EmbeddingTypedDict", Union[List[float], str])


Embedding = TypeAliasType("Embedding", Union[List[float], str])


class CreateEmbeddingsDataTypedDict(TypedDict):
    object: ObjectEmbedding
    embedding: EmbeddingTypedDict
    index: NotRequired[float]


class CreateEmbeddingsData(BaseModel):
    object: ObjectEmbedding

    embedding: Embedding

    index: Optional[float] = None


class UsageTypedDict(TypedDict):
    prompt_tokens: float
    total_tokens: float
    cost: NotRequired[float]


class Usage(BaseModel):
    prompt_tokens: float

    total_tokens: float

    cost: Optional[float] = None


class CreateEmbeddingsResponseBodyTypedDict(TypedDict):
    r"""Embedding response"""

    object: CreateEmbeddingsObject
    data: List[CreateEmbeddingsDataTypedDict]
    model: str
    id: NotRequired[str]
    usage: NotRequired[UsageTypedDict]


class CreateEmbeddingsResponseBody(BaseModel):
    r"""Embedding response"""

    object: CreateEmbeddingsObject

    data: List[CreateEmbeddingsData]

    model: str

    id: Optional[str] = None

    usage: Optional[Usage] = None


CreateEmbeddingsResponseTypedDict = TypeAliasType(
    "CreateEmbeddingsResponseTypedDict",
    Union[CreateEmbeddingsResponseBodyTypedDict, str],
)


CreateEmbeddingsResponse = TypeAliasType(
    "CreateEmbeddingsResponse", Union[CreateEmbeddingsResponseBody, str]
)
