"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
    UnrecognizedStr,
)
from openrouter.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


ExchangeAuthCodeForAPIKeyCodeChallengeMethod = Union[
    Literal[
        "S256",
        "plain",
    ],
    UnrecognizedStr,
]
r"""The method used to generate the code challenge"""


class ExchangeAuthCodeForAPIKeyRequestTypedDict(TypedDict):
    code: str
    r"""The authorization code received from the OAuth redirect"""
    code_verifier: NotRequired[str]
    r"""The code verifier if code_challenge was used in the authorization request"""
    code_challenge_method: NotRequired[
        Nullable[ExchangeAuthCodeForAPIKeyCodeChallengeMethod]
    ]
    r"""The method used to generate the code challenge"""


class ExchangeAuthCodeForAPIKeyRequest(BaseModel):
    code: str
    r"""The authorization code received from the OAuth redirect"""

    code_verifier: Optional[str] = None
    r"""The code verifier if code_challenge was used in the authorization request"""

    code_challenge_method: Annotated[
        OptionalNullable[ExchangeAuthCodeForAPIKeyCodeChallengeMethod],
        PlainValidator(validate_open_enum(False)),
    ] = UNSET
    r"""The method used to generate the code challenge"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["code_verifier", "code_challenge_method"]
        nullable_fields = ["code_challenge_method"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ExchangeAuthCodeForAPIKeyResponseTypedDict(TypedDict):
    r"""Successfully exchanged code for an API key"""

    key: str
    r"""The API key to use for OpenRouter requests"""
    user_id: Nullable[str]
    r"""User ID associated with the API key"""


class ExchangeAuthCodeForAPIKeyResponse(BaseModel):
    r"""Successfully exchanged code for an API key"""

    key: str
    r"""The API key to use for OpenRouter requests"""

    user_id: Nullable[str]
    r"""User ID associated with the API key"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["user_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
