"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict, deprecated


@deprecated(
    "warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
)
class RateLimitTypedDict(TypedDict):
    r"""Legacy rate limit information about a key. Will always return -1."""

    requests: float
    r"""Number of requests allowed per interval"""
    interval: str
    r"""Rate limit interval"""
    note: str
    r"""Note about the rate limit"""


@deprecated(
    "warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
)
class RateLimit(BaseModel):
    r"""Legacy rate limit information about a key. Will always return -1."""

    requests: float
    r"""Number of requests allowed per interval"""

    interval: str
    r"""Rate limit interval"""

    note: str
    r"""Note about the rate limit"""


class GetCurrentKeyDataTypedDict(TypedDict):
    r"""Current API key information"""

    label: str
    r"""Human-readable label for the API key"""
    limit: Nullable[float]
    r"""Spending limit for the API key in USD"""
    usage: float
    r"""Total OpenRouter credit usage (in USD) for the API key"""
    usage_daily: float
    r"""OpenRouter credit usage (in USD) for the current UTC day"""
    usage_weekly: float
    r"""OpenRouter credit usage (in USD) for the current UTC week (Monday-Sunday)"""
    usage_monthly: float
    r"""OpenRouter credit usage (in USD) for the current UTC month"""
    byok_usage: float
    r"""Total external BYOK usage (in USD) for the API key"""
    byok_usage_daily: float
    r"""External BYOK usage (in USD) for the current UTC day"""
    byok_usage_weekly: float
    r"""External BYOK usage (in USD) for the current UTC week (Monday-Sunday)"""
    byok_usage_monthly: float
    r"""External BYOK usage (in USD) for current UTC month"""
    is_free_tier: bool
    r"""Whether this is a free tier API key"""
    is_provisioning_key: bool
    r"""Whether this is a provisioning key"""
    limit_remaining: Nullable[float]
    r"""Remaining spending limit in USD"""
    limit_reset: Nullable[str]
    r"""Type of limit reset for the API key"""
    include_byok_in_limit: bool
    r"""Whether to include external BYOK usage in the credit limit"""
    rate_limit: RateLimitTypedDict
    r"""Legacy rate limit information about a key. Will always return -1."""
    expires_at: NotRequired[Nullable[datetime]]
    r"""ISO 8601 UTC timestamp when the API key expires, or null if no expiration"""


class GetCurrentKeyData(BaseModel):
    r"""Current API key information"""

    label: str
    r"""Human-readable label for the API key"""

    limit: Nullable[float]
    r"""Spending limit for the API key in USD"""

    usage: float
    r"""Total OpenRouter credit usage (in USD) for the API key"""

    usage_daily: float
    r"""OpenRouter credit usage (in USD) for the current UTC day"""

    usage_weekly: float
    r"""OpenRouter credit usage (in USD) for the current UTC week (Monday-Sunday)"""

    usage_monthly: float
    r"""OpenRouter credit usage (in USD) for the current UTC month"""

    byok_usage: float
    r"""Total external BYOK usage (in USD) for the API key"""

    byok_usage_daily: float
    r"""External BYOK usage (in USD) for the current UTC day"""

    byok_usage_weekly: float
    r"""External BYOK usage (in USD) for the current UTC week (Monday-Sunday)"""

    byok_usage_monthly: float
    r"""External BYOK usage (in USD) for current UTC month"""

    is_free_tier: bool
    r"""Whether this is a free tier API key"""

    is_provisioning_key: bool
    r"""Whether this is a provisioning key"""

    limit_remaining: Nullable[float]
    r"""Remaining spending limit in USD"""

    limit_reset: Nullable[str]
    r"""Type of limit reset for the API key"""

    include_byok_in_limit: bool
    r"""Whether to include external BYOK usage in the credit limit"""

    rate_limit: Annotated[
        RateLimit,
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ]
    r"""Legacy rate limit information about a key. Will always return -1."""

    expires_at: OptionalNullable[datetime] = UNSET
    r"""ISO 8601 UTC timestamp when the API key expires, or null if no expiration"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["expires_at"]
        nullable_fields = ["limit", "limit_remaining", "limit_reset", "expires_at"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetCurrentKeyResponseTypedDict(TypedDict):
    r"""API key details"""

    data: GetCurrentKeyDataTypedDict
    r"""Current API key information"""


class GetCurrentKeyResponse(BaseModel):
    r"""API key details"""

    data: GetCurrentKeyData
    r"""Current API key information"""
