"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from openrouter.types import BaseModel, Nullable, UNSET_SENTINEL, UnrecognizedStr
from openrouter.utils import FieldMetadata, QueryParamMetadata, validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Literal, Union
from typing_extensions import Annotated, TypedDict


class GetGenerationRequestTypedDict(TypedDict):
    id: str


class GetGenerationRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]


APIType = Union[
    Literal[
        "completions",
        "embeddings",
    ],
    UnrecognizedStr,
]
r"""Type of API used for the generation"""


class GetGenerationDataTypedDict(TypedDict):
    r"""Generation data"""

    id: str
    r"""Unique identifier for the generation"""
    upstream_id: Nullable[str]
    r"""Upstream provider's identifier for this generation"""
    total_cost: float
    r"""Total cost of the generation in USD"""
    cache_discount: Nullable[float]
    r"""Discount applied due to caching"""
    upstream_inference_cost: Nullable[float]
    r"""Cost charged by the upstream provider"""
    created_at: str
    r"""ISO 8601 timestamp of when the generation was created"""
    model: str
    r"""Model used for the generation"""
    app_id: Nullable[float]
    r"""ID of the app that made the request"""
    streamed: Nullable[bool]
    r"""Whether the response was streamed"""
    cancelled: Nullable[bool]
    r"""Whether the generation was cancelled"""
    provider_name: Nullable[str]
    r"""Name of the provider that served the request"""
    latency: Nullable[float]
    r"""Total latency in milliseconds"""
    moderation_latency: Nullable[float]
    r"""Moderation latency in milliseconds"""
    generation_time: Nullable[float]
    r"""Time taken for generation in milliseconds"""
    finish_reason: Nullable[str]
    r"""Reason the generation finished"""
    tokens_prompt: Nullable[float]
    r"""Number of tokens in the prompt"""
    tokens_completion: Nullable[float]
    r"""Number of tokens in the completion"""
    native_tokens_prompt: Nullable[float]
    r"""Native prompt tokens as reported by provider"""
    native_tokens_completion: Nullable[float]
    r"""Native completion tokens as reported by provider"""
    native_tokens_completion_images: Nullable[float]
    r"""Native completion image tokens as reported by provider"""
    native_tokens_reasoning: Nullable[float]
    r"""Native reasoning tokens as reported by provider"""
    native_tokens_cached: Nullable[float]
    r"""Native cached tokens as reported by provider"""
    num_media_prompt: Nullable[float]
    r"""Number of media items in the prompt"""
    num_input_audio_prompt: Nullable[float]
    r"""Number of audio inputs in the prompt"""
    num_media_completion: Nullable[float]
    r"""Number of media items in the completion"""
    num_search_results: Nullable[float]
    r"""Number of search results included"""
    origin: str
    r"""Origin URL of the request"""
    usage: float
    r"""Usage amount in USD"""
    is_byok: bool
    r"""Whether this used bring-your-own-key"""
    native_finish_reason: Nullable[str]
    r"""Native finish reason as reported by provider"""
    external_user: Nullable[str]
    r"""External user identifier"""
    api_type: Nullable[APIType]
    r"""Type of API used for the generation"""


class GetGenerationData(BaseModel):
    r"""Generation data"""

    id: str
    r"""Unique identifier for the generation"""

    upstream_id: Nullable[str]
    r"""Upstream provider's identifier for this generation"""

    total_cost: float
    r"""Total cost of the generation in USD"""

    cache_discount: Nullable[float]
    r"""Discount applied due to caching"""

    upstream_inference_cost: Nullable[float]
    r"""Cost charged by the upstream provider"""

    created_at: str
    r"""ISO 8601 timestamp of when the generation was created"""

    model: str
    r"""Model used for the generation"""

    app_id: Nullable[float]
    r"""ID of the app that made the request"""

    streamed: Nullable[bool]
    r"""Whether the response was streamed"""

    cancelled: Nullable[bool]
    r"""Whether the generation was cancelled"""

    provider_name: Nullable[str]
    r"""Name of the provider that served the request"""

    latency: Nullable[float]
    r"""Total latency in milliseconds"""

    moderation_latency: Nullable[float]
    r"""Moderation latency in milliseconds"""

    generation_time: Nullable[float]
    r"""Time taken for generation in milliseconds"""

    finish_reason: Nullable[str]
    r"""Reason the generation finished"""

    tokens_prompt: Nullable[float]
    r"""Number of tokens in the prompt"""

    tokens_completion: Nullable[float]
    r"""Number of tokens in the completion"""

    native_tokens_prompt: Nullable[float]
    r"""Native prompt tokens as reported by provider"""

    native_tokens_completion: Nullable[float]
    r"""Native completion tokens as reported by provider"""

    native_tokens_completion_images: Nullable[float]
    r"""Native completion image tokens as reported by provider"""

    native_tokens_reasoning: Nullable[float]
    r"""Native reasoning tokens as reported by provider"""

    native_tokens_cached: Nullable[float]
    r"""Native cached tokens as reported by provider"""

    num_media_prompt: Nullable[float]
    r"""Number of media items in the prompt"""

    num_input_audio_prompt: Nullable[float]
    r"""Number of audio inputs in the prompt"""

    num_media_completion: Nullable[float]
    r"""Number of media items in the completion"""

    num_search_results: Nullable[float]
    r"""Number of search results included"""

    origin: str
    r"""Origin URL of the request"""

    usage: float
    r"""Usage amount in USD"""

    is_byok: bool
    r"""Whether this used bring-your-own-key"""

    native_finish_reason: Nullable[str]
    r"""Native finish reason as reported by provider"""

    external_user: Nullable[str]
    r"""External user identifier"""

    api_type: Annotated[Nullable[APIType], PlainValidator(validate_open_enum(False))]
    r"""Type of API used for the generation"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = [
            "upstream_id",
            "cache_discount",
            "upstream_inference_cost",
            "app_id",
            "streamed",
            "cancelled",
            "provider_name",
            "latency",
            "moderation_latency",
            "generation_time",
            "finish_reason",
            "tokens_prompt",
            "tokens_completion",
            "native_tokens_prompt",
            "native_tokens_completion",
            "native_tokens_completion_images",
            "native_tokens_reasoning",
            "native_tokens_cached",
            "num_media_prompt",
            "num_input_audio_prompt",
            "num_media_completion",
            "num_search_results",
            "native_finish_reason",
            "external_user",
            "api_type",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetGenerationResponseTypedDict(TypedDict):
    r"""Generation response"""

    data: GetGenerationDataTypedDict
    r"""Generation data"""


class GetGenerationResponse(BaseModel):
    r"""Generation response"""

    data: GetGenerationData
    r"""Generation data"""
