"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from openrouter.types import BaseModel, UnrecognizedStr
from openrouter.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    SecurityMetadata,
    validate_open_enum,
)
from pydantic.functional_validators import PlainValidator
from typing import List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class GetParametersSecurityTypedDict(TypedDict):
    bearer: str


class GetParametersSecurity(BaseModel):
    bearer: Annotated[
        str,
        FieldMetadata(
            security=SecurityMetadata(
                scheme=True,
                scheme_type="http",
                sub_type="bearer",
                field_name="Authorization",
            )
        ),
    ]


GetParametersProvider = Union[
    Literal[
        "AI21",
        "AionLabs",
        "Alibaba",
        "Amazon Bedrock",
        "Anthropic",
        "AtlasCloud",
        "Atoma",
        "Avian",
        "Azure",
        "BaseTen",
        "Cerebras",
        "Chutes",
        "Cirrascale",
        "Clarifai",
        "Cloudflare",
        "Cohere",
        "CrofAI",
        "Crusoe",
        "DeepInfra",
        "DeepSeek",
        "Enfer",
        "Featherless",
        "Fireworks",
        "Friendli",
        "GMICloud",
        "Google",
        "Google AI Studio",
        "Groq",
        "Hyperbolic",
        "Inception",
        "InferenceNet",
        "Infermatic",
        "Inflection",
        "Kluster",
        "Lambda",
        "Liquid",
        "Mancer 2",
        "Meta",
        "Minimax",
        "ModelRun",
        "Mistral",
        "Modular",
        "Moonshot AI",
        "Morph",
        "NCompass",
        "Nebius",
        "NextBit",
        "Nineteen",
        "Novita",
        "Nvidia",
        "OpenAI",
        "OpenInference",
        "Parasail",
        "Perplexity",
        "Phala",
        "Relace",
        "SambaNova",
        "SiliconFlow",
        "Stealth",
        "Switchpoint",
        "Targon",
        "Together",
        "Ubicloud",
        "Venice",
        "WandB",
        "xAI",
        "Z.AI",
        "FakeProvider",
    ],
    UnrecognizedStr,
]


class GetParametersRequestTypedDict(TypedDict):
    author: str
    slug: str
    provider: NotRequired[GetParametersProvider]


class GetParametersRequest(BaseModel):
    author: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]

    slug: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]

    provider: Annotated[
        Annotated[
            Optional[GetParametersProvider], PlainValidator(validate_open_enum(False))
        ],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None


SupportedParameter = Union[
    Literal[
        "temperature",
        "top_p",
        "top_k",
        "min_p",
        "top_a",
        "frequency_penalty",
        "presence_penalty",
        "repetition_penalty",
        "max_tokens",
        "logit_bias",
        "logprobs",
        "top_logprobs",
        "seed",
        "response_format",
        "structured_outputs",
        "stop",
        "tools",
        "tool_choice",
        "parallel_tool_calls",
        "include_reasoning",
        "reasoning",
        "web_search_options",
        "verbosity",
    ],
    UnrecognizedStr,
]


class GetParametersDataTypedDict(TypedDict):
    r"""Parameter analytics data"""

    model: str
    r"""Model identifier"""
    supported_parameters: List[SupportedParameter]
    r"""List of parameters supported by this model"""


class GetParametersData(BaseModel):
    r"""Parameter analytics data"""

    model: str
    r"""Model identifier"""

    supported_parameters: List[
        Annotated[SupportedParameter, PlainValidator(validate_open_enum(False))]
    ]
    r"""List of parameters supported by this model"""


class GetParametersResponseTypedDict(TypedDict):
    r"""Returns the parameters for the specified model"""

    data: GetParametersDataTypedDict
    r"""Parameter analytics data"""


class GetParametersResponse(BaseModel):
    r"""Returns the parameters for the specified model"""

    data: GetParametersData
    r"""Parameter analytics data"""
