"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .inputmodality import InputModality
from .instructtype import InstructType
from .outputmodality import OutputModality
from .publicendpoint import PublicEndpoint, PublicEndpointTypedDict
from openrouter.types import BaseModel, Nullable, UNSET_SENTINEL, UnrecognizedStr
from openrouter.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import List, Literal, Union
from typing_extensions import Annotated, TypedDict


Tokenizer = Union[
    Literal[
        "Router",
        "Media",
        "Other",
        "GPT",
        "Claude",
        "Gemini",
        "Grok",
        "Cohere",
        "Nova",
        "Qwen",
        "Yi",
        "DeepSeek",
        "Mistral",
        "Llama2",
        "Llama3",
        "Llama4",
        "PaLM",
        "RWKV",
        "Qwen3",
    ],
    UnrecognizedStr,
]
r"""Tokenizer type used by the model"""


class ArchitectureTypedDict(TypedDict):
    r"""Model architecture information"""

    tokenizer: Nullable[Tokenizer]
    instruct_type: Nullable[InstructType]
    r"""Instruction format type"""
    modality: Nullable[str]
    r"""Primary modality of the model"""
    input_modalities: List[InputModality]
    r"""Supported input modalities"""
    output_modalities: List[OutputModality]
    r"""Supported output modalities"""


class Architecture(BaseModel):
    r"""Model architecture information"""

    tokenizer: Annotated[Nullable[Tokenizer], PlainValidator(validate_open_enum(False))]

    instruct_type: Annotated[
        Nullable[InstructType], PlainValidator(validate_open_enum(False))
    ]
    r"""Instruction format type"""

    modality: Nullable[str]
    r"""Primary modality of the model"""

    input_modalities: List[
        Annotated[InputModality, PlainValidator(validate_open_enum(False))]
    ]
    r"""Supported input modalities"""

    output_modalities: List[
        Annotated[OutputModality, PlainValidator(validate_open_enum(False))]
    ]
    r"""Supported output modalities"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["tokenizer", "instruct_type", "modality"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListEndpointsResponseTypedDict(TypedDict):
    r"""List of available endpoints for a model"""

    id: str
    r"""Unique identifier for the model"""
    name: str
    r"""Display name of the model"""
    created: float
    r"""Unix timestamp of when the model was created"""
    description: str
    r"""Description of the model"""
    architecture: ArchitectureTypedDict
    endpoints: List[PublicEndpointTypedDict]
    r"""List of available endpoints for this model"""


class ListEndpointsResponse(BaseModel):
    r"""List of available endpoints for a model"""

    id: str
    r"""Unique identifier for the model"""

    name: str
    r"""Display name of the model"""

    created: float
    r"""Unix timestamp of when the model was created"""

    description: str
    r"""Description of the model"""

    architecture: Architecture

    endpoints: List[PublicEndpoint]
    r"""List of available endpoints for this model"""
