"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from openrouter.utils import FieldMetadata, QueryParamMetadata
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListRequestTypedDict(TypedDict):
    include_disabled: NotRequired[str]
    r"""Whether to include disabled API keys in the response"""
    offset: NotRequired[str]
    r"""Number of API keys to skip for pagination"""


class ListRequest(BaseModel):
    include_disabled: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Whether to include disabled API keys in the response"""

    offset: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Number of API keys to skip for pagination"""


class ListDataTypedDict(TypedDict):
    hash: str
    r"""Unique hash identifier for the API key"""
    name: str
    r"""Name of the API key"""
    label: str
    r"""Human-readable label for the API key"""
    disabled: bool
    r"""Whether the API key is disabled"""
    limit: Nullable[float]
    r"""Spending limit for the API key in USD"""
    limit_remaining: Nullable[float]
    r"""Remaining spending limit in USD"""
    limit_reset: Nullable[str]
    r"""Type of limit reset for the API key"""
    include_byok_in_limit: bool
    r"""Whether to include external BYOK usage in the credit limit"""
    usage: float
    r"""Total OpenRouter credit usage (in USD) for the API key"""
    usage_daily: float
    r"""OpenRouter credit usage (in USD) for the current UTC day"""
    usage_weekly: float
    r"""OpenRouter credit usage (in USD) for the current UTC week (Monday-Sunday)"""
    usage_monthly: float
    r"""OpenRouter credit usage (in USD) for the current UTC month"""
    byok_usage: float
    r"""Total external BYOK usage (in USD) for the API key"""
    byok_usage_daily: float
    r"""External BYOK usage (in USD) for the current UTC day"""
    byok_usage_weekly: float
    r"""External BYOK usage (in USD) for the current UTC week (Monday-Sunday)"""
    byok_usage_monthly: float
    r"""External BYOK usage (in USD) for current UTC month"""
    created_at: str
    r"""ISO 8601 timestamp of when the API key was created"""
    updated_at: Nullable[str]
    r"""ISO 8601 timestamp of when the API key was last updated"""
    expires_at: NotRequired[Nullable[datetime]]
    r"""ISO 8601 UTC timestamp when the API key expires, or null if no expiration"""


class ListData(BaseModel):
    hash: str
    r"""Unique hash identifier for the API key"""

    name: str
    r"""Name of the API key"""

    label: str
    r"""Human-readable label for the API key"""

    disabled: bool
    r"""Whether the API key is disabled"""

    limit: Nullable[float]
    r"""Spending limit for the API key in USD"""

    limit_remaining: Nullable[float]
    r"""Remaining spending limit in USD"""

    limit_reset: Nullable[str]
    r"""Type of limit reset for the API key"""

    include_byok_in_limit: bool
    r"""Whether to include external BYOK usage in the credit limit"""

    usage: float
    r"""Total OpenRouter credit usage (in USD) for the API key"""

    usage_daily: float
    r"""OpenRouter credit usage (in USD) for the current UTC day"""

    usage_weekly: float
    r"""OpenRouter credit usage (in USD) for the current UTC week (Monday-Sunday)"""

    usage_monthly: float
    r"""OpenRouter credit usage (in USD) for the current UTC month"""

    byok_usage: float
    r"""Total external BYOK usage (in USD) for the API key"""

    byok_usage_daily: float
    r"""External BYOK usage (in USD) for the current UTC day"""

    byok_usage_weekly: float
    r"""External BYOK usage (in USD) for the current UTC week (Monday-Sunday)"""

    byok_usage_monthly: float
    r"""External BYOK usage (in USD) for current UTC month"""

    created_at: str
    r"""ISO 8601 timestamp of when the API key was created"""

    updated_at: Nullable[str]
    r"""ISO 8601 timestamp of when the API key was last updated"""

    expires_at: OptionalNullable[datetime] = UNSET
    r"""ISO 8601 UTC timestamp when the API key expires, or null if no expiration"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["expires_at"]
        nullable_fields = [
            "limit",
            "limit_remaining",
            "limit_reset",
            "updated_at",
            "expires_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListResponseTypedDict(TypedDict):
    r"""List of API keys"""

    data: List[ListDataTypedDict]
    r"""List of API keys"""


class ListResponse(BaseModel):
    r"""List of API keys"""

    data: List[ListData]
    r"""List of API keys"""
