"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List
from typing_extensions import NotRequired, TypedDict


class ListProvidersDataTypedDict(TypedDict):
    name: str
    r"""Display name of the provider"""
    slug: str
    r"""URL-friendly identifier for the provider"""
    privacy_policy_url: Nullable[str]
    r"""URL to the provider's privacy policy"""
    terms_of_service_url: NotRequired[Nullable[str]]
    r"""URL to the provider's terms of service"""
    status_page_url: NotRequired[Nullable[str]]
    r"""URL to the provider's status page"""


class ListProvidersData(BaseModel):
    name: str
    r"""Display name of the provider"""

    slug: str
    r"""URL-friendly identifier for the provider"""

    privacy_policy_url: Nullable[str]
    r"""URL to the provider's privacy policy"""

    terms_of_service_url: OptionalNullable[str] = UNSET
    r"""URL to the provider's terms of service"""

    status_page_url: OptionalNullable[str] = UNSET
    r"""URL to the provider's status page"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["terms_of_service_url", "status_page_url"]
        nullable_fields = [
            "privacy_policy_url",
            "terms_of_service_url",
            "status_page_url",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListProvidersResponseTypedDict(TypedDict):
    r"""Returns a list of providers"""

    data: List[ListProvidersDataTypedDict]


class ListProvidersResponse(BaseModel):
    r"""Returns a list of providers"""

    data: List[ListProvidersData]
