"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .assistantmessage import AssistantMessage, AssistantMessageTypedDict
from .chatmessagecontentitemtext import (
    ChatMessageContentItemText,
    ChatMessageContentItemTextTypedDict,
)
from .systemmessage import SystemMessage, SystemMessageTypedDict
from .toolresponsemessage import ToolResponseMessage, ToolResponseMessageTypedDict
from .usermessage import UserMessage, UserMessageTypedDict
from openrouter.types import BaseModel
from openrouter.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


MessageContentTypedDict = TypeAliasType(
    "MessageContentTypedDict", Union[str, List[ChatMessageContentItemTextTypedDict]]
)


MessageContent = TypeAliasType(
    "MessageContent", Union[str, List[ChatMessageContentItemText]]
)


class MessageDeveloperTypedDict(TypedDict):
    content: MessageContentTypedDict
    role: Literal["developer"]
    name: NotRequired[str]


class MessageDeveloper(BaseModel):
    content: MessageContent

    ROLE: Annotated[
        Annotated[Literal["developer"], AfterValidator(validate_const("developer"))],
        pydantic.Field(alias="role"),
    ] = "developer"

    name: Optional[str] = None


MessageTypedDict = TypeAliasType(
    "MessageTypedDict",
    Union[
        SystemMessageTypedDict,
        UserMessageTypedDict,
        MessageDeveloperTypedDict,
        ToolResponseMessageTypedDict,
        AssistantMessageTypedDict,
    ],
)


Message = TypeAliasType(
    "Message",
    Union[
        SystemMessage,
        UserMessage,
        MessageDeveloper,
        ToolResponseMessage,
        AssistantMessage,
    ],
)
