"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .defaultparameters import DefaultParameters, DefaultParametersTypedDict
from .modelarchitecture import ModelArchitecture, ModelArchitectureTypedDict
from .parameter import Parameter
from .perrequestlimits import PerRequestLimits, PerRequestLimitsTypedDict
from .publicpricing import PublicPricing, PublicPricingTypedDict
from .topproviderinfo import TopProviderInfo, TopProviderInfoTypedDict
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from openrouter.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ModelTypedDict(TypedDict):
    r"""Information about an AI model available on OpenRouter"""

    id: str
    r"""Unique identifier for the model"""
    canonical_slug: str
    r"""Canonical slug for the model"""
    name: str
    r"""Display name of the model"""
    created: float
    r"""Unix timestamp of when the model was created"""
    pricing: PublicPricingTypedDict
    r"""Pricing information for the model"""
    context_length: Nullable[float]
    r"""Maximum context length in tokens"""
    architecture: ModelArchitectureTypedDict
    r"""Model architecture information"""
    top_provider: TopProviderInfoTypedDict
    r"""Information about the top provider for this model"""
    per_request_limits: Nullable[PerRequestLimitsTypedDict]
    r"""Per-request token limits"""
    supported_parameters: List[Parameter]
    r"""List of supported parameters for this model"""
    default_parameters: Nullable[DefaultParametersTypedDict]
    r"""Default parameters for this model"""
    hugging_face_id: NotRequired[Nullable[str]]
    r"""Hugging Face model identifier, if applicable"""
    description: NotRequired[str]
    r"""Description of the model"""


class Model(BaseModel):
    r"""Information about an AI model available on OpenRouter"""

    id: str
    r"""Unique identifier for the model"""

    canonical_slug: str
    r"""Canonical slug for the model"""

    name: str
    r"""Display name of the model"""

    created: float
    r"""Unix timestamp of when the model was created"""

    pricing: PublicPricing
    r"""Pricing information for the model"""

    context_length: Nullable[float]
    r"""Maximum context length in tokens"""

    architecture: ModelArchitecture
    r"""Model architecture information"""

    top_provider: TopProviderInfo
    r"""Information about the top provider for this model"""

    per_request_limits: Nullable[PerRequestLimits]
    r"""Per-request token limits"""

    supported_parameters: List[
        Annotated[Parameter, PlainValidator(validate_open_enum(False))]
    ]
    r"""List of supported parameters for this model"""

    default_parameters: Nullable[DefaultParameters]
    r"""Default parameters for this model"""

    hugging_face_id: OptionalNullable[str] = UNSET
    r"""Hugging Face model identifier, if applicable"""

    description: Optional[str] = None
    r"""Description of the model"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["hugging_face_id", "description"]
        nullable_fields = [
            "hugging_face_id",
            "context_length",
            "per_request_limits",
            "default_parameters",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
