"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .inputmodality import InputModality
from .modelgroup import ModelGroup
from .outputmodality import OutputModality
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
    UnrecognizedStr,
)
from openrouter.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


ModelArchitectureInstructType = Union[
    Literal[
        "none",
        "airoboros",
        "alpaca",
        "alpaca-modif",
        "chatml",
        "claude",
        "code-llama",
        "gemma",
        "llama2",
        "llama3",
        "mistral",
        "nemotron",
        "neural",
        "openchat",
        "phi3",
        "rwkv",
        "vicuna",
        "zephyr",
        "deepseek-r1",
        "deepseek-v3.1",
        "qwq",
        "qwen3",
    ],
    UnrecognizedStr,
]
r"""Instruction format type"""


class ModelArchitectureTypedDict(TypedDict):
    r"""Model architecture information"""

    modality: Nullable[str]
    r"""Primary modality of the model"""
    input_modalities: List[InputModality]
    r"""Supported input modalities"""
    output_modalities: List[OutputModality]
    r"""Supported output modalities"""
    tokenizer: NotRequired[ModelGroup]
    r"""Tokenizer type used by the model"""
    instruct_type: NotRequired[Nullable[ModelArchitectureInstructType]]
    r"""Instruction format type"""


class ModelArchitecture(BaseModel):
    r"""Model architecture information"""

    modality: Nullable[str]
    r"""Primary modality of the model"""

    input_modalities: List[
        Annotated[InputModality, PlainValidator(validate_open_enum(False))]
    ]
    r"""Supported input modalities"""

    output_modalities: List[
        Annotated[OutputModality, PlainValidator(validate_open_enum(False))]
    ]
    r"""Supported output modalities"""

    tokenizer: Annotated[
        Optional[ModelGroup], PlainValidator(validate_open_enum(False))
    ] = None
    r"""Tokenizer type used by the model"""

    instruct_type: Annotated[
        OptionalNullable[ModelArchitectureInstructType],
        PlainValidator(validate_open_enum(False)),
    ] = UNSET
    r"""Instruction format type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["tokenizer", "instruct_type"]
        nullable_fields = ["instruct_type", "modality"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
