"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .outputitemimagegenerationcall import (
    OutputItemImageGenerationCall,
    OutputItemImageGenerationCallTypedDict,
)
from .outputmessage import OutputMessage, OutputMessageTypedDict
from .responseinputaudio import ResponseInputAudio, ResponseInputAudioTypedDict
from .responseinputfile import ResponseInputFile, ResponseInputFileTypedDict
from .responseinputimage import ResponseInputImage, ResponseInputImageTypedDict
from .responseinputtext import ResponseInputText, ResponseInputTextTypedDict
from .toolcallstatus import ToolCallStatus
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from openrouter.utils import get_discriminator, validate_open_enum
from pydantic import Discriminator, Tag, model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Any, List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


OpenAIResponsesInputTypeFunctionCall = Literal["function_call",]


class OpenAIResponsesInputFunctionCallTypedDict(TypedDict):
    type: OpenAIResponsesInputTypeFunctionCall
    call_id: str
    name: str
    arguments: str
    id: NotRequired[str]
    status: NotRequired[Nullable[ToolCallStatus]]


class OpenAIResponsesInputFunctionCall(BaseModel):
    type: OpenAIResponsesInputTypeFunctionCall

    call_id: str

    name: str

    arguments: str

    id: Optional[str] = None

    status: Annotated[
        OptionalNullable[ToolCallStatus], PlainValidator(validate_open_enum(False))
    ] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "status"]
        nullable_fields = ["status"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


OpenAIResponsesInputTypeFunctionCallOutput = Literal["function_call_output",]


class OpenAIResponsesInputFunctionCallOutputTypedDict(TypedDict):
    type: OpenAIResponsesInputTypeFunctionCallOutput
    call_id: str
    output: str
    id: NotRequired[Nullable[str]]
    status: NotRequired[Nullable[ToolCallStatus]]


class OpenAIResponsesInputFunctionCallOutput(BaseModel):
    type: OpenAIResponsesInputTypeFunctionCallOutput

    call_id: str

    output: str

    id: OptionalNullable[str] = UNSET

    status: Annotated[
        OptionalNullable[ToolCallStatus], PlainValidator(validate_open_enum(False))
    ] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "status"]
        nullable_fields = ["id", "status"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


OpenAIResponsesInputTypeMessage2 = Literal["message",]


OpenAIResponsesInputRoleDeveloper2 = Literal["developer",]


OpenAIResponsesInputRoleSystem2 = Literal["system",]


OpenAIResponsesInputRoleUser2 = Literal["user",]


OpenAIResponsesInputRoleUnion2TypedDict = TypeAliasType(
    "OpenAIResponsesInputRoleUnion2TypedDict",
    Union[
        OpenAIResponsesInputRoleUser2,
        OpenAIResponsesInputRoleSystem2,
        OpenAIResponsesInputRoleDeveloper2,
    ],
)


OpenAIResponsesInputRoleUnion2 = TypeAliasType(
    "OpenAIResponsesInputRoleUnion2",
    Union[
        OpenAIResponsesInputRoleUser2,
        OpenAIResponsesInputRoleSystem2,
        OpenAIResponsesInputRoleDeveloper2,
    ],
)


OpenAIResponsesInputContent3TypedDict = TypeAliasType(
    "OpenAIResponsesInputContent3TypedDict",
    Union[
        ResponseInputTextTypedDict,
        ResponseInputAudioTypedDict,
        ResponseInputImageTypedDict,
        ResponseInputFileTypedDict,
    ],
)


OpenAIResponsesInputContent3 = Annotated[
    Union[
        Annotated[ResponseInputText, Tag("input_text")],
        Annotated[ResponseInputImage, Tag("input_image")],
        Annotated[ResponseInputFile, Tag("input_file")],
        Annotated[ResponseInputAudio, Tag("input_audio")],
    ],
    Discriminator(lambda m: get_discriminator(m, "type", "type")),
]


class OpenAIResponsesInputMessage2TypedDict(TypedDict):
    id: str
    role: OpenAIResponsesInputRoleUnion2TypedDict
    content: List[OpenAIResponsesInputContent3TypedDict]
    type: NotRequired[OpenAIResponsesInputTypeMessage2]


class OpenAIResponsesInputMessage2(BaseModel):
    id: str

    role: OpenAIResponsesInputRoleUnion2

    content: List[OpenAIResponsesInputContent3]

    type: Optional[OpenAIResponsesInputTypeMessage2] = None


OpenAIResponsesInputTypeMessage1 = Literal["message",]


OpenAIResponsesInputRoleDeveloper1 = Literal["developer",]


OpenAIResponsesInputRoleAssistant = Literal["assistant",]


OpenAIResponsesInputRoleSystem1 = Literal["system",]


OpenAIResponsesInputRoleUser1 = Literal["user",]


OpenAIResponsesInputRoleUnion1TypedDict = TypeAliasType(
    "OpenAIResponsesInputRoleUnion1TypedDict",
    Union[
        OpenAIResponsesInputRoleUser1,
        OpenAIResponsesInputRoleSystem1,
        OpenAIResponsesInputRoleAssistant,
        OpenAIResponsesInputRoleDeveloper1,
    ],
)


OpenAIResponsesInputRoleUnion1 = TypeAliasType(
    "OpenAIResponsesInputRoleUnion1",
    Union[
        OpenAIResponsesInputRoleUser1,
        OpenAIResponsesInputRoleSystem1,
        OpenAIResponsesInputRoleAssistant,
        OpenAIResponsesInputRoleDeveloper1,
    ],
)


OpenAIResponsesInputContent1TypedDict = TypeAliasType(
    "OpenAIResponsesInputContent1TypedDict",
    Union[
        ResponseInputTextTypedDict,
        ResponseInputAudioTypedDict,
        ResponseInputImageTypedDict,
        ResponseInputFileTypedDict,
    ],
)


OpenAIResponsesInputContent1 = Annotated[
    Union[
        Annotated[ResponseInputText, Tag("input_text")],
        Annotated[ResponseInputImage, Tag("input_image")],
        Annotated[ResponseInputFile, Tag("input_file")],
        Annotated[ResponseInputAudio, Tag("input_audio")],
    ],
    Discriminator(lambda m: get_discriminator(m, "type", "type")),
]


OpenAIResponsesInputContent2TypedDict = TypeAliasType(
    "OpenAIResponsesInputContent2TypedDict",
    Union[List[OpenAIResponsesInputContent1TypedDict], str],
)


OpenAIResponsesInputContent2 = TypeAliasType(
    "OpenAIResponsesInputContent2", Union[List[OpenAIResponsesInputContent1], str]
)


class OpenAIResponsesInputMessage1TypedDict(TypedDict):
    role: OpenAIResponsesInputRoleUnion1TypedDict
    content: OpenAIResponsesInputContent2TypedDict
    type: NotRequired[OpenAIResponsesInputTypeMessage1]


class OpenAIResponsesInputMessage1(BaseModel):
    role: OpenAIResponsesInputRoleUnion1

    content: OpenAIResponsesInputContent2

    type: Optional[OpenAIResponsesInputTypeMessage1] = None


OpenAIResponsesInputUnion1TypedDict = TypeAliasType(
    "OpenAIResponsesInputUnion1TypedDict",
    Union[
        OpenAIResponsesInputMessage1TypedDict,
        OpenAIResponsesInputMessage2TypedDict,
        OutputItemImageGenerationCallTypedDict,
        OpenAIResponsesInputFunctionCallOutputTypedDict,
        OutputMessageTypedDict,
        OpenAIResponsesInputFunctionCallTypedDict,
    ],
)


OpenAIResponsesInputUnion1 = TypeAliasType(
    "OpenAIResponsesInputUnion1",
    Union[
        OpenAIResponsesInputMessage1,
        OpenAIResponsesInputMessage2,
        OutputItemImageGenerationCall,
        OpenAIResponsesInputFunctionCallOutput,
        OutputMessage,
        OpenAIResponsesInputFunctionCall,
    ],
)


OpenAIResponsesInputUnionTypedDict = TypeAliasType(
    "OpenAIResponsesInputUnionTypedDict",
    Union[str, List[OpenAIResponsesInputUnion1TypedDict], Any],
)


OpenAIResponsesInputUnion = TypeAliasType(
    "OpenAIResponsesInputUnion", Union[str, List[OpenAIResponsesInputUnion1], Any]
)
