"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .responseinputfile import ResponseInputFile, ResponseInputFileTypedDict
from .responseinputimage import ResponseInputImage, ResponseInputImageTypedDict
from .responseinputtext import ResponseInputText, ResponseInputTextTypedDict
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import Dict, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


VariablesTypedDict = TypeAliasType(
    "VariablesTypedDict",
    Union[
        ResponseInputTextTypedDict,
        ResponseInputImageTypedDict,
        ResponseInputFileTypedDict,
        str,
    ],
)


Variables = TypeAliasType(
    "Variables", Union[ResponseInputText, ResponseInputImage, ResponseInputFile, str]
)


class OpenAIResponsesPromptTypedDict(TypedDict):
    id: str
    variables: NotRequired[Nullable[Dict[str, VariablesTypedDict]]]


class OpenAIResponsesPrompt(BaseModel):
    id: str

    variables: OptionalNullable[Dict[str, Variables]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["variables"]
        nullable_fields = ["variables"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
