"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .toolcallstatus import ToolCallStatus
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from openrouter.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Literal
from typing_extensions import Annotated, NotRequired, TypedDict


OpenResponsesFunctionCallOutputType = Literal["function_call_output",]


class OpenResponsesFunctionCallOutputTypedDict(TypedDict):
    r"""The output from a function call execution"""

    type: OpenResponsesFunctionCallOutputType
    call_id: str
    output: str
    id: NotRequired[Nullable[str]]
    status: NotRequired[Nullable[ToolCallStatus]]


class OpenResponsesFunctionCallOutput(BaseModel):
    r"""The output from a function call execution"""

    type: OpenResponsesFunctionCallOutputType

    call_id: str

    output: str

    id: OptionalNullable[str] = UNSET

    status: Annotated[
        OptionalNullable[ToolCallStatus], PlainValidator(validate_open_enum(False))
    ] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "status"]
        nullable_fields = ["id", "status"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
