"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .responseinputaudio import ResponseInputAudio, ResponseInputAudioTypedDict
from .responseinputfile import ResponseInputFile, ResponseInputFileTypedDict
from .responseinputimage import ResponseInputImage, ResponseInputImageTypedDict
from .responseinputtext import ResponseInputText, ResponseInputTextTypedDict
from openrouter.types import BaseModel
from openrouter.utils import get_discriminator
from pydantic import Discriminator, Tag
from typing import List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


OpenResponsesInputMessageItemType = Literal["message",]


OpenResponsesInputMessageItemRoleDeveloper = Literal["developer",]


OpenResponsesInputMessageItemRoleSystem = Literal["system",]


OpenResponsesInputMessageItemRoleUser = Literal["user",]


OpenResponsesInputMessageItemRoleUnionTypedDict = TypeAliasType(
    "OpenResponsesInputMessageItemRoleUnionTypedDict",
    Union[
        OpenResponsesInputMessageItemRoleUser,
        OpenResponsesInputMessageItemRoleSystem,
        OpenResponsesInputMessageItemRoleDeveloper,
    ],
)


OpenResponsesInputMessageItemRoleUnion = TypeAliasType(
    "OpenResponsesInputMessageItemRoleUnion",
    Union[
        OpenResponsesInputMessageItemRoleUser,
        OpenResponsesInputMessageItemRoleSystem,
        OpenResponsesInputMessageItemRoleDeveloper,
    ],
)


OpenResponsesInputMessageItemContentTypedDict = TypeAliasType(
    "OpenResponsesInputMessageItemContentTypedDict",
    Union[
        ResponseInputTextTypedDict,
        ResponseInputAudioTypedDict,
        ResponseInputImageTypedDict,
        ResponseInputFileTypedDict,
    ],
)


OpenResponsesInputMessageItemContent = Annotated[
    Union[
        Annotated[ResponseInputText, Tag("input_text")],
        Annotated[ResponseInputImage, Tag("input_image")],
        Annotated[ResponseInputFile, Tag("input_file")],
        Annotated[ResponseInputAudio, Tag("input_audio")],
    ],
    Discriminator(lambda m: get_discriminator(m, "type", "type")),
]


class OpenResponsesInputMessageItemTypedDict(TypedDict):
    role: OpenResponsesInputMessageItemRoleUnionTypedDict
    content: List[OpenResponsesInputMessageItemContentTypedDict]
    id: NotRequired[str]
    type: NotRequired[OpenResponsesInputMessageItemType]


class OpenResponsesInputMessageItem(BaseModel):
    role: OpenResponsesInputMessageItemRoleUnion

    content: List[OpenResponsesInputMessageItemContent]

    id: Optional[str] = None

    type: Optional[OpenResponsesInputMessageItemType] = None
