"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .reasoningsummarytext import ReasoningSummaryText, ReasoningSummaryTextTypedDict
from .reasoningtextcontent import ReasoningTextContent, ReasoningTextContentTypedDict
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
    UnrecognizedStr,
)
from openrouter.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


OpenResponsesReasoningType = Literal["reasoning",]


OpenResponsesReasoningStatusInProgress = Literal["in_progress",]


OpenResponsesReasoningStatusIncomplete = Literal["incomplete",]


OpenResponsesReasoningStatusCompleted = Literal["completed",]


OpenResponsesReasoningStatusUnionTypedDict = TypeAliasType(
    "OpenResponsesReasoningStatusUnionTypedDict",
    Union[
        OpenResponsesReasoningStatusCompleted,
        OpenResponsesReasoningStatusIncomplete,
        OpenResponsesReasoningStatusInProgress,
    ],
)


OpenResponsesReasoningStatusUnion = TypeAliasType(
    "OpenResponsesReasoningStatusUnion",
    Union[
        OpenResponsesReasoningStatusCompleted,
        OpenResponsesReasoningStatusIncomplete,
        OpenResponsesReasoningStatusInProgress,
    ],
)


OpenResponsesReasoningFormat = Union[
    Literal[
        "unknown",
        "openai-responses-v1",
        "xai-responses-v1",
        "anthropic-claude-v1",
    ],
    UnrecognizedStr,
]


class OpenResponsesReasoningTypedDict(TypedDict):
    r"""Reasoning output item with signature and format extensions"""

    type: OpenResponsesReasoningType
    id: str
    summary: List[ReasoningSummaryTextTypedDict]
    content: NotRequired[List[ReasoningTextContentTypedDict]]
    encrypted_content: NotRequired[Nullable[str]]
    status: NotRequired[OpenResponsesReasoningStatusUnionTypedDict]
    signature: NotRequired[Nullable[str]]
    format_: NotRequired[Nullable[OpenResponsesReasoningFormat]]


class OpenResponsesReasoning(BaseModel):
    r"""Reasoning output item with signature and format extensions"""

    type: OpenResponsesReasoningType

    id: str

    summary: List[ReasoningSummaryText]

    content: Optional[List[ReasoningTextContent]] = None

    encrypted_content: OptionalNullable[str] = UNSET

    status: Optional[OpenResponsesReasoningStatusUnion] = None

    signature: OptionalNullable[str] = UNSET

    format_: Annotated[
        Annotated[
            OptionalNullable[OpenResponsesReasoningFormat],
            PlainValidator(validate_open_enum(False)),
        ],
        pydantic.Field(alias="format"),
    ] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "content",
            "encrypted_content",
            "status",
            "signature",
            "format",
        ]
        nullable_fields = ["encrypted_content", "signature", "format"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
