"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .openairesponsesreasoningeffort import OpenAIResponsesReasoningEffort
from .reasoningsummaryverbosity import ReasoningSummaryVerbosity
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from openrouter.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class OpenResponsesReasoningConfigTypedDict(TypedDict):
    r"""Configuration for reasoning mode in the response"""

    effort: NotRequired[Nullable[OpenAIResponsesReasoningEffort]]
    summary: NotRequired[ReasoningSummaryVerbosity]
    max_tokens: NotRequired[Nullable[float]]
    enabled: NotRequired[Nullable[bool]]


class OpenResponsesReasoningConfig(BaseModel):
    r"""Configuration for reasoning mode in the response"""

    effort: Annotated[
        OptionalNullable[OpenAIResponsesReasoningEffort],
        PlainValidator(validate_open_enum(False)),
    ] = UNSET

    summary: Annotated[
        Optional[ReasoningSummaryVerbosity], PlainValidator(validate_open_enum(False))
    ] = None

    max_tokens: OptionalNullable[float] = UNSET

    enabled: OptionalNullable[bool] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["effort", "summary", "max_tokens", "enabled"]
        nullable_fields = ["effort", "max_tokens", "enabled"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
