"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .openairesponsesincludable import OpenAIResponsesIncludable
from .openairesponsesprompt import OpenAIResponsesPrompt, OpenAIResponsesPromptTypedDict
from .openairesponsestoolchoice_union import (
    OpenAIResponsesToolChoiceUnion,
    OpenAIResponsesToolChoiceUnionTypedDict,
)
from .openresponsesinput import OpenResponsesInput, OpenResponsesInputTypedDict
from .openresponsesreasoningconfig import (
    OpenResponsesReasoningConfig,
    OpenResponsesReasoningConfigTypedDict,
)
from .openresponsesresponsetext import (
    OpenResponsesResponseText,
    OpenResponsesResponseTextTypedDict,
)
from .openresponseswebsearch20250826tool import (
    OpenResponsesWebSearch20250826Tool,
    OpenResponsesWebSearch20250826ToolTypedDict,
)
from .openresponseswebsearchpreview20250311tool import (
    OpenResponsesWebSearchPreview20250311Tool,
    OpenResponsesWebSearchPreview20250311ToolTypedDict,
)
from .openresponseswebsearchpreviewtool import (
    OpenResponsesWebSearchPreviewTool,
    OpenResponsesWebSearchPreviewToolTypedDict,
)
from .openresponseswebsearchtool import (
    OpenResponsesWebSearchTool,
    OpenResponsesWebSearchToolTypedDict,
)
from .providername import ProviderName
from .quantization import Quantization
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
    UnrecognizedStr,
)
from openrouter.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


OpenResponsesRequestType = Literal["function",]


class OpenResponsesRequestToolFunctionTypedDict(TypedDict):
    r"""Function tool definition"""

    type: OpenResponsesRequestType
    name: str
    parameters: Nullable[Dict[str, Nullable[Any]]]
    description: NotRequired[Nullable[str]]
    strict: NotRequired[Nullable[bool]]


class OpenResponsesRequestToolFunction(BaseModel):
    r"""Function tool definition"""

    type: OpenResponsesRequestType

    name: str

    parameters: Nullable[Dict[str, Nullable[Any]]]

    description: OptionalNullable[str] = UNSET

    strict: OptionalNullable[bool] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "strict"]
        nullable_fields = ["description", "strict", "parameters"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


OpenResponsesRequestToolUnionTypedDict = TypeAliasType(
    "OpenResponsesRequestToolUnionTypedDict",
    Union[
        OpenResponsesWebSearchPreviewToolTypedDict,
        OpenResponsesWebSearchPreview20250311ToolTypedDict,
        OpenResponsesWebSearchToolTypedDict,
        OpenResponsesWebSearch20250826ToolTypedDict,
        OpenResponsesRequestToolFunctionTypedDict,
    ],
)


OpenResponsesRequestToolUnion = TypeAliasType(
    "OpenResponsesRequestToolUnion",
    Union[
        OpenResponsesWebSearchPreviewTool,
        OpenResponsesWebSearchPreview20250311Tool,
        OpenResponsesWebSearchTool,
        OpenResponsesWebSearch20250826Tool,
        OpenResponsesRequestToolFunction,
    ],
)


ServiceTier = Union[
    Literal[
        "auto",
        "default",
        "flex",
        "priority",
        "scale",
    ],
    UnrecognizedStr,
]


Truncation = Union[
    Literal[
        "auto",
        "disabled",
    ],
    UnrecognizedStr,
]


DataCollection = Union[
    Literal[
        "deny",
        "allow",
    ],
    UnrecognizedStr,
]
r"""Data collection setting. If no available model provider meets the requirement, your request will return an error.
- allow: (default) allow providers which store user data non-transiently and may train on it
- deny: use only providers which do not collect user data.

"""


OrderTypedDict = TypeAliasType("OrderTypedDict", Union[ProviderName, str])


Order = TypeAliasType(
    "Order",
    Union[Annotated[ProviderName, PlainValidator(validate_open_enum(False))], str],
)


OnlyTypedDict = TypeAliasType("OnlyTypedDict", Union[ProviderName, str])


Only = TypeAliasType(
    "Only",
    Union[Annotated[ProviderName, PlainValidator(validate_open_enum(False))], str],
)


IgnoreTypedDict = TypeAliasType("IgnoreTypedDict", Union[ProviderName, str])


Ignore = TypeAliasType(
    "Ignore",
    Union[Annotated[ProviderName, PlainValidator(validate_open_enum(False))], str],
)


Sort = Union[
    Literal[
        "price",
        "throughput",
        "latency",
    ],
    UnrecognizedStr,
]
r"""The sorting strategy to use for this request, if \"order\" is not specified. When set, no load balancing is performed."""


class MaxPriceTypedDict(TypedDict):
    r"""The object specifying the maximum price you want to pay for this request. USD price per million tokens, for prompt and completion."""

    prompt: NotRequired[Any]
    r"""A value in string or number format that is a large number"""
    completion: NotRequired[Any]
    r"""A value in string or number format that is a large number"""
    image: NotRequired[Any]
    r"""A value in string or number format that is a large number"""
    audio: NotRequired[Any]
    r"""A value in string or number format that is a large number"""
    request: NotRequired[Any]
    r"""A value in string or number format that is a large number"""


class MaxPrice(BaseModel):
    r"""The object specifying the maximum price you want to pay for this request. USD price per million tokens, for prompt and completion."""

    prompt: Optional[Any] = None
    r"""A value in string or number format that is a large number"""

    completion: Optional[Any] = None
    r"""A value in string or number format that is a large number"""

    image: Optional[Any] = None
    r"""A value in string or number format that is a large number"""

    audio: Optional[Any] = None
    r"""A value in string or number format that is a large number"""

    request: Optional[Any] = None
    r"""A value in string or number format that is a large number"""


class ProviderTypedDict(TypedDict):
    r"""When multiple model providers are available, optionally indicate your routing preference."""

    allow_fallbacks: NotRequired[Nullable[bool]]
    r"""Whether to allow backup providers to serve requests
    - true: (default) when the primary provider (or your custom providers in \"order\") is unavailable, use the next best provider.
    - false: use only the primary/custom provider, and return the upstream error if it's unavailable.

    """
    require_parameters: NotRequired[Nullable[bool]]
    r"""Whether to filter providers to only those that support the parameters you've provided. If this setting is omitted or set to false, then providers will receive only the parameters they support, and ignore the rest."""
    data_collection: NotRequired[Nullable[DataCollection]]
    r"""Data collection setting. If no available model provider meets the requirement, your request will return an error.
    - allow: (default) allow providers which store user data non-transiently and may train on it
    - deny: use only providers which do not collect user data.

    """
    zdr: NotRequired[Nullable[bool]]
    r"""Whether to restrict routing to only ZDR (Zero Data Retention) endpoints. When true, only endpoints that do not retain prompts will be used."""
    enforce_distillable_text: NotRequired[Nullable[bool]]
    r"""Whether to restrict routing to only models that allow text distillation. When true, only models where the author has allowed distillation will be used."""
    order: NotRequired[Nullable[List[OrderTypedDict]]]
    r"""An ordered list of provider slugs. The router will attempt to use the first provider in the subset of this list that supports your requested model, and fall back to the next if it is unavailable. If no providers are available, the request will fail with an error message."""
    only: NotRequired[Nullable[List[OnlyTypedDict]]]
    r"""List of provider slugs to allow. If provided, this list is merged with your account-wide allowed provider settings for this request."""
    ignore: NotRequired[Nullable[List[IgnoreTypedDict]]]
    r"""List of provider slugs to ignore. If provided, this list is merged with your account-wide ignored provider settings for this request."""
    quantizations: NotRequired[Nullable[List[Quantization]]]
    r"""A list of quantization levels to filter the provider by."""
    sort: NotRequired[Nullable[Sort]]
    r"""The sorting strategy to use for this request, if \"order\" is not specified. When set, no load balancing is performed."""
    max_price: NotRequired[MaxPriceTypedDict]
    r"""The object specifying the maximum price you want to pay for this request. USD price per million tokens, for prompt and completion."""


class Provider(BaseModel):
    r"""When multiple model providers are available, optionally indicate your routing preference."""

    allow_fallbacks: OptionalNullable[bool] = UNSET
    r"""Whether to allow backup providers to serve requests
    - true: (default) when the primary provider (or your custom providers in \"order\") is unavailable, use the next best provider.
    - false: use only the primary/custom provider, and return the upstream error if it's unavailable.

    """

    require_parameters: OptionalNullable[bool] = UNSET
    r"""Whether to filter providers to only those that support the parameters you've provided. If this setting is omitted or set to false, then providers will receive only the parameters they support, and ignore the rest."""

    data_collection: Annotated[
        OptionalNullable[DataCollection], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""Data collection setting. If no available model provider meets the requirement, your request will return an error.
    - allow: (default) allow providers which store user data non-transiently and may train on it
    - deny: use only providers which do not collect user data.

    """

    zdr: OptionalNullable[bool] = UNSET
    r"""Whether to restrict routing to only ZDR (Zero Data Retention) endpoints. When true, only endpoints that do not retain prompts will be used."""

    enforce_distillable_text: OptionalNullable[bool] = UNSET
    r"""Whether to restrict routing to only models that allow text distillation. When true, only models where the author has allowed distillation will be used."""

    order: OptionalNullable[List[Order]] = UNSET
    r"""An ordered list of provider slugs. The router will attempt to use the first provider in the subset of this list that supports your requested model, and fall back to the next if it is unavailable. If no providers are available, the request will fail with an error message."""

    only: OptionalNullable[List[Only]] = UNSET
    r"""List of provider slugs to allow. If provided, this list is merged with your account-wide allowed provider settings for this request."""

    ignore: OptionalNullable[List[Ignore]] = UNSET
    r"""List of provider slugs to ignore. If provided, this list is merged with your account-wide ignored provider settings for this request."""

    quantizations: OptionalNullable[
        List[Annotated[Quantization, PlainValidator(validate_open_enum(False))]]
    ] = UNSET
    r"""A list of quantization levels to filter the provider by."""

    sort: Annotated[
        OptionalNullable[Sort], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The sorting strategy to use for this request, if \"order\" is not specified. When set, no load balancing is performed."""

    max_price: Optional[MaxPrice] = None
    r"""The object specifying the maximum price you want to pay for this request. USD price per million tokens, for prompt and completion."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "allow_fallbacks",
            "require_parameters",
            "data_collection",
            "zdr",
            "enforce_distillable_text",
            "order",
            "only",
            "ignore",
            "quantizations",
            "sort",
            "max_price",
        ]
        nullable_fields = [
            "allow_fallbacks",
            "require_parameters",
            "data_collection",
            "zdr",
            "enforce_distillable_text",
            "order",
            "only",
            "ignore",
            "quantizations",
            "sort",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


IDFileParser = Literal["file-parser",]


PdfEngine = Union[
    Literal[
        "mistral-ocr",
        "pdf-text",
        "native",
    ],
    UnrecognizedStr,
]


class PdfTypedDict(TypedDict):
    engine: NotRequired[PdfEngine]


class Pdf(BaseModel):
    engine: Annotated[
        Optional[PdfEngine], PlainValidator(validate_open_enum(False))
    ] = None


class PluginFileParserTypedDict(TypedDict):
    id: IDFileParser
    max_files: NotRequired[float]
    pdf: NotRequired[PdfTypedDict]


class PluginFileParser(BaseModel):
    id: IDFileParser

    max_files: Optional[float] = None

    pdf: Optional[Pdf] = None


IDWeb = Literal["web",]


Engine = Union[
    Literal[
        "native",
        "exa",
    ],
    UnrecognizedStr,
]


class PluginWebTypedDict(TypedDict):
    id: IDWeb
    max_results: NotRequired[float]
    search_prompt: NotRequired[str]
    engine: NotRequired[Engine]


class PluginWeb(BaseModel):
    id: IDWeb

    max_results: Optional[float] = None

    search_prompt: Optional[str] = None

    engine: Annotated[Optional[Engine], PlainValidator(validate_open_enum(False))] = (
        None
    )


IDModeration = Literal["moderation",]


class PluginModerationTypedDict(TypedDict):
    id: IDModeration


class PluginModeration(BaseModel):
    id: IDModeration


PluginTypedDict = TypeAliasType(
    "PluginTypedDict",
    Union[PluginModerationTypedDict, PluginFileParserTypedDict, PluginWebTypedDict],
)


Plugin = TypeAliasType("Plugin", Union[PluginModeration, PluginFileParser, PluginWeb])


class OpenResponsesRequestTypedDict(TypedDict):
    r"""Request schema for Responses endpoint"""

    input: NotRequired[OpenResponsesInputTypedDict]
    r"""Input for a response request - can be a string or array of items"""
    instructions: NotRequired[Nullable[str]]
    metadata: NotRequired[Nullable[Dict[str, str]]]
    r"""Metadata key-value pairs for the request. Keys must be ≤64 characters and cannot contain brackets. Values must be ≤512 characters. Maximum 16 pairs allowed."""
    tools: NotRequired[List[OpenResponsesRequestToolUnionTypedDict]]
    tool_choice: NotRequired[OpenAIResponsesToolChoiceUnionTypedDict]
    parallel_tool_calls: NotRequired[Nullable[bool]]
    model: NotRequired[str]
    models: NotRequired[List[str]]
    text: NotRequired[OpenResponsesResponseTextTypedDict]
    r"""Text output configuration including format and verbosity"""
    reasoning: NotRequired[Nullable[OpenResponsesReasoningConfigTypedDict]]
    r"""Configuration for reasoning mode in the response"""
    max_output_tokens: NotRequired[Nullable[float]]
    temperature: NotRequired[Nullable[float]]
    top_p: NotRequired[Nullable[float]]
    top_k: NotRequired[float]
    prompt_cache_key: NotRequired[Nullable[str]]
    previous_response_id: NotRequired[Nullable[str]]
    prompt: NotRequired[Nullable[OpenAIResponsesPromptTypedDict]]
    include: NotRequired[Nullable[List[OpenAIResponsesIncludable]]]
    background: NotRequired[Nullable[bool]]
    safety_identifier: NotRequired[Nullable[str]]
    store: NotRequired[Nullable[bool]]
    service_tier: NotRequired[Nullable[ServiceTier]]
    truncation: NotRequired[Nullable[Truncation]]
    stream: NotRequired[bool]
    provider: NotRequired[Nullable[ProviderTypedDict]]
    r"""When multiple model providers are available, optionally indicate your routing preference."""
    plugins: NotRequired[List[PluginTypedDict]]
    r"""Plugins you want to enable for this request, including their settings."""
    user: NotRequired[str]
    r"""A unique identifier representing your end-user, which helps distinguish between different users of your app. This allows your app to identify specific users in case of abuse reports, preventing your entire app from being affected by the actions of individual users. Maximum of 128 characters."""


class OpenResponsesRequest(BaseModel):
    r"""Request schema for Responses endpoint"""

    input: Optional[OpenResponsesInput] = None
    r"""Input for a response request - can be a string or array of items"""

    instructions: OptionalNullable[str] = UNSET

    metadata: OptionalNullable[Dict[str, str]] = UNSET
    r"""Metadata key-value pairs for the request. Keys must be ≤64 characters and cannot contain brackets. Values must be ≤512 characters. Maximum 16 pairs allowed."""

    tools: Optional[List[OpenResponsesRequestToolUnion]] = None

    tool_choice: Optional[OpenAIResponsesToolChoiceUnion] = None

    parallel_tool_calls: OptionalNullable[bool] = UNSET

    model: Optional[str] = None

    models: Optional[List[str]] = None

    text: Optional[OpenResponsesResponseText] = None
    r"""Text output configuration including format and verbosity"""

    reasoning: OptionalNullable[OpenResponsesReasoningConfig] = UNSET
    r"""Configuration for reasoning mode in the response"""

    max_output_tokens: OptionalNullable[float] = UNSET

    temperature: OptionalNullable[float] = UNSET

    top_p: OptionalNullable[float] = UNSET

    top_k: Optional[float] = None

    prompt_cache_key: OptionalNullable[str] = UNSET

    previous_response_id: OptionalNullable[str] = UNSET

    prompt: OptionalNullable[OpenAIResponsesPrompt] = UNSET

    include: OptionalNullable[
        List[
            Annotated[
                OpenAIResponsesIncludable, PlainValidator(validate_open_enum(False))
            ]
        ]
    ] = UNSET

    background: OptionalNullable[bool] = UNSET

    safety_identifier: OptionalNullable[str] = UNSET

    store: OptionalNullable[bool] = UNSET

    service_tier: Annotated[
        OptionalNullable[ServiceTier], PlainValidator(validate_open_enum(False))
    ] = UNSET

    truncation: Annotated[
        OptionalNullable[Truncation], PlainValidator(validate_open_enum(False))
    ] = UNSET

    stream: Optional[bool] = False

    provider: OptionalNullable[Provider] = UNSET
    r"""When multiple model providers are available, optionally indicate your routing preference."""

    plugins: Optional[List[Plugin]] = None
    r"""Plugins you want to enable for this request, including their settings."""

    user: Optional[str] = None
    r"""A unique identifier representing your end-user, which helps distinguish between different users of your app. This allows your app to identify specific users in case of abuse reports, preventing your entire app from being affected by the actions of individual users. Maximum of 128 characters."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "input",
            "instructions",
            "metadata",
            "tools",
            "tool_choice",
            "parallel_tool_calls",
            "model",
            "models",
            "text",
            "reasoning",
            "max_output_tokens",
            "temperature",
            "top_p",
            "top_k",
            "prompt_cache_key",
            "previous_response_id",
            "prompt",
            "include",
            "background",
            "safety_identifier",
            "store",
            "service_tier",
            "truncation",
            "stream",
            "provider",
            "plugins",
            "user",
        ]
        nullable_fields = [
            "instructions",
            "metadata",
            "parallel_tool_calls",
            "reasoning",
            "max_output_tokens",
            "temperature",
            "top_p",
            "prompt_cache_key",
            "previous_response_id",
            "prompt",
            "include",
            "background",
            "safety_identifier",
            "store",
            "service_tier",
            "truncation",
            "provider",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
