"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class InputTokensDetailsTypedDict(TypedDict):
    cached_tokens: float


class InputTokensDetails(BaseModel):
    cached_tokens: float


class OutputTokensDetailsTypedDict(TypedDict):
    reasoning_tokens: float


class OutputTokensDetails(BaseModel):
    reasoning_tokens: float


class CostDetailsTypedDict(TypedDict):
    upstream_inference_input_cost: float
    upstream_inference_output_cost: float
    upstream_inference_cost: NotRequired[Nullable[float]]


class CostDetails(BaseModel):
    upstream_inference_input_cost: float

    upstream_inference_output_cost: float

    upstream_inference_cost: OptionalNullable[float] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["upstream_inference_cost"]
        nullable_fields = ["upstream_inference_cost"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class OpenResponsesUsageTypedDict(TypedDict):
    r"""Token usage information for the response"""

    input_tokens: float
    input_tokens_details: InputTokensDetailsTypedDict
    output_tokens: float
    output_tokens_details: OutputTokensDetailsTypedDict
    total_tokens: float
    cost: NotRequired[Nullable[float]]
    r"""Cost of the completion"""
    is_byok: NotRequired[bool]
    r"""Whether a request was made using a Bring Your Own Key configuration"""
    cost_details: NotRequired[CostDetailsTypedDict]


class OpenResponsesUsage(BaseModel):
    r"""Token usage information for the response"""

    input_tokens: float

    input_tokens_details: InputTokensDetails

    output_tokens: float

    output_tokens_details: OutputTokensDetails

    total_tokens: float

    cost: OptionalNullable[float] = UNSET
    r"""Cost of the completion"""

    is_byok: Optional[bool] = None
    r"""Whether a request was made using a Bring Your Own Key configuration"""

    cost_details: Optional[CostDetails] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["cost", "is_byok", "cost_details"]
        nullable_fields = ["cost"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
