"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .responsessearchcontextsize import ResponsesSearchContextSize
from .websearchpreviewtooluserlocation import (
    WebSearchPreviewToolUserLocation,
    WebSearchPreviewToolUserLocationTypedDict,
)
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from openrouter.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


OpenResponsesWebSearchPreviewToolType = Literal["web_search_preview",]


class OpenResponsesWebSearchPreviewToolTypedDict(TypedDict):
    r"""Web search preview tool configuration"""

    type: OpenResponsesWebSearchPreviewToolType
    search_context_size: NotRequired[ResponsesSearchContextSize]
    r"""Size of the search context for web search tools"""
    user_location: NotRequired[Nullable[WebSearchPreviewToolUserLocationTypedDict]]


class OpenResponsesWebSearchPreviewTool(BaseModel):
    r"""Web search preview tool configuration"""

    type: OpenResponsesWebSearchPreviewToolType

    search_context_size: Annotated[
        Optional[ResponsesSearchContextSize], PlainValidator(validate_open_enum(False))
    ] = None
    r"""Size of the search context for web search tools"""

    user_location: OptionalNullable[WebSearchPreviewToolUserLocation] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["search_context_size", "user_location"]
        nullable_fields = ["user_location"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
