"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .responsessearchcontextsize import ResponsesSearchContextSize
from .responseswebsearchuserlocation import (
    ResponsesWebSearchUserLocation,
    ResponsesWebSearchUserLocationTypedDict,
)
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from openrouter.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


OpenResponsesWebSearchToolType = Literal["web_search",]


class OpenResponsesWebSearchToolFiltersTypedDict(TypedDict):
    allowed_domains: NotRequired[Nullable[List[str]]]


class OpenResponsesWebSearchToolFilters(BaseModel):
    allowed_domains: OptionalNullable[List[str]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["allowed_domains"]
        nullable_fields = ["allowed_domains"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class OpenResponsesWebSearchToolTypedDict(TypedDict):
    r"""Web search tool configuration"""

    type: OpenResponsesWebSearchToolType
    filters: NotRequired[Nullable[OpenResponsesWebSearchToolFiltersTypedDict]]
    search_context_size: NotRequired[ResponsesSearchContextSize]
    r"""Size of the search context for web search tools"""
    user_location: NotRequired[Nullable[ResponsesWebSearchUserLocationTypedDict]]
    r"""User location information for web search"""


class OpenResponsesWebSearchTool(BaseModel):
    r"""Web search tool configuration"""

    type: OpenResponsesWebSearchToolType

    filters: OptionalNullable[OpenResponsesWebSearchToolFilters] = UNSET

    search_context_size: Annotated[
        Optional[ResponsesSearchContextSize], PlainValidator(validate_open_enum(False))
    ] = None
    r"""Size of the search context for web search tools"""

    user_location: OptionalNullable[ResponsesWebSearchUserLocation] = UNSET
    r"""User location information for web search"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["filters", "search_context_size", "user_location"]
        nullable_fields = ["filters", "user_location"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
