"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .openairesponsesrefusalcontent import (
    OpenAIResponsesRefusalContent,
    OpenAIResponsesRefusalContentTypedDict,
)
from .responseoutputtext import ResponseOutputText, ResponseOutputTextTypedDict
from openrouter.types import BaseModel
from typing import List, Literal, Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


OutputMessageRole = Literal["assistant",]


OutputMessageType = Literal["message",]


OutputMessageStatusInProgress = Literal["in_progress",]


OutputMessageStatusIncomplete = Literal["incomplete",]


OutputMessageStatusCompleted = Literal["completed",]


OutputMessageStatusUnionTypedDict = TypeAliasType(
    "OutputMessageStatusUnionTypedDict",
    Union[
        OutputMessageStatusCompleted,
        OutputMessageStatusIncomplete,
        OutputMessageStatusInProgress,
    ],
)


OutputMessageStatusUnion = TypeAliasType(
    "OutputMessageStatusUnion",
    Union[
        OutputMessageStatusCompleted,
        OutputMessageStatusIncomplete,
        OutputMessageStatusInProgress,
    ],
)


OutputMessageContentTypedDict = TypeAliasType(
    "OutputMessageContentTypedDict",
    Union[OpenAIResponsesRefusalContentTypedDict, ResponseOutputTextTypedDict],
)


OutputMessageContent = TypeAliasType(
    "OutputMessageContent", Union[OpenAIResponsesRefusalContent, ResponseOutputText]
)


class OutputMessageTypedDict(TypedDict):
    id: str
    role: OutputMessageRole
    type: OutputMessageType
    content: List[OutputMessageContentTypedDict]
    status: NotRequired[OutputMessageStatusUnionTypedDict]


class OutputMessage(BaseModel):
    id: str

    role: OutputMessageRole

    type: OutputMessageType

    content: List[OutputMessageContent]

    status: Optional[OutputMessageStatusUnion] = None
