"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import Literal, Optional
from typing_extensions import NotRequired, TypedDict


ResponseInputFileType = Literal["input_file",]


class ResponseInputFileTypedDict(TypedDict):
    r"""File input content item"""

    type: ResponseInputFileType
    file_id: NotRequired[Nullable[str]]
    file_data: NotRequired[str]
    filename: NotRequired[str]
    file_url: NotRequired[str]


class ResponseInputFile(BaseModel):
    r"""File input content item"""

    type: ResponseInputFileType

    file_id: OptionalNullable[str] = UNSET

    file_data: Optional[str] = None

    filename: Optional[str] = None

    file_url: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["file_id", "file_data", "filename", "file_url"]
        nullable_fields = ["file_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
