"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .reasoningsummarytext import ReasoningSummaryText, ReasoningSummaryTextTypedDict
from .reasoningtextcontent import ReasoningTextContent, ReasoningTextContentTypedDict
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Literal, Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


ResponsesOutputItemReasoningType = Literal["reasoning",]


ResponsesOutputItemReasoningStatusInProgress = Literal["in_progress",]


ResponsesOutputItemReasoningStatusIncomplete = Literal["incomplete",]


ResponsesOutputItemReasoningStatusCompleted = Literal["completed",]


ResponsesOutputItemReasoningStatusUnionTypedDict = TypeAliasType(
    "ResponsesOutputItemReasoningStatusUnionTypedDict",
    Union[
        ResponsesOutputItemReasoningStatusCompleted,
        ResponsesOutputItemReasoningStatusIncomplete,
        ResponsesOutputItemReasoningStatusInProgress,
    ],
)


ResponsesOutputItemReasoningStatusUnion = TypeAliasType(
    "ResponsesOutputItemReasoningStatusUnion",
    Union[
        ResponsesOutputItemReasoningStatusCompleted,
        ResponsesOutputItemReasoningStatusIncomplete,
        ResponsesOutputItemReasoningStatusInProgress,
    ],
)


class ResponsesOutputItemReasoningTypedDict(TypedDict):
    r"""An output item containing reasoning"""

    type: ResponsesOutputItemReasoningType
    id: str
    summary: List[ReasoningSummaryTextTypedDict]
    content: NotRequired[List[ReasoningTextContentTypedDict]]
    encrypted_content: NotRequired[Nullable[str]]
    status: NotRequired[ResponsesOutputItemReasoningStatusUnionTypedDict]


class ResponsesOutputItemReasoning(BaseModel):
    r"""An output item containing reasoning"""

    type: ResponsesOutputItemReasoningType

    id: str

    summary: List[ReasoningSummaryText]

    content: Optional[List[ReasoningTextContent]] = None

    encrypted_content: OptionalNullable[str] = UNSET

    status: Optional[ResponsesOutputItemReasoningStatusUnion] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["content", "encrypted_content", "status"]
        nullable_fields = ["encrypted_content"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
